/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.sql.plugin;

import java.time.ZoneId;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.support.ActionFilters;
import org.elasticsearch.action.support.HandledTransportAction;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.collect.Tuple;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.tasks.Task;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.TransportService;
import org.elasticsearch.xpack.core.XPackSettings;
import org.elasticsearch.xpack.core.security.SecurityContext;
import org.elasticsearch.xpack.ql.type.Schema;
import org.elasticsearch.xpack.sql.SqlIllegalArgumentException;
import org.elasticsearch.xpack.sql.action.SqlQueryRequest;
import org.elasticsearch.xpack.sql.action.SqlQueryResponse;
import org.elasticsearch.xpack.sql.execution.PlanExecutor;
import org.elasticsearch.xpack.sql.plugin.SqlLicenseChecker;
import org.elasticsearch.xpack.sql.plugin.Transports;
import org.elasticsearch.xpack.sql.proto.ColumnInfo;
import org.elasticsearch.xpack.sql.proto.Mode;
import org.elasticsearch.xpack.sql.session.Cursor;
import org.elasticsearch.xpack.sql.session.Cursors;
import org.elasticsearch.xpack.sql.session.RowSet;
import org.elasticsearch.xpack.sql.session.SchemaRowSet;
import org.elasticsearch.xpack.sql.session.SqlConfiguration;
import org.elasticsearch.xpack.sql.type.SqlDataTypes;

public class TransportSqlQueryAction
extends HandledTransportAction<SqlQueryRequest, SqlQueryResponse> {
    private final SecurityContext securityContext;
    private final ClusterService clusterService;
    private final PlanExecutor planExecutor;
    private final SqlLicenseChecker sqlLicenseChecker;

    @Inject
    public TransportSqlQueryAction(Settings settings, ClusterService clusterService, TransportService transportService, ThreadPool threadPool, ActionFilters actionFilters, PlanExecutor planExecutor, SqlLicenseChecker sqlLicenseChecker) {
        super("indices:data/read/sql", transportService, actionFilters, SqlQueryRequest::new);
        this.securityContext = (Boolean)XPackSettings.SECURITY_ENABLED.get(settings) != false ? new SecurityContext(settings, threadPool.getThreadContext()) : null;
        this.clusterService = clusterService;
        this.planExecutor = planExecutor;
        this.sqlLicenseChecker = sqlLicenseChecker;
    }

    protected void doExecute(Task task, SqlQueryRequest request, ActionListener<SqlQueryResponse> listener) {
        this.sqlLicenseChecker.checkIfSqlAllowed(request.mode());
        TransportSqlQueryAction.operation(this.planExecutor, request, listener, Transports.username(this.securityContext), Transports.clusterName(this.clusterService));
    }

    static void operation(PlanExecutor planExecutor, SqlQueryRequest request, ActionListener<SqlQueryResponse> listener, String username, String clusterName) {
        SqlConfiguration cfg = new SqlConfiguration(request.zoneId(), request.fetchSize(), request.requestTimeout(), request.pageTimeout(), request.filter(), request.mode(), request.clientId(), username, clusterName, request.fieldMultiValueLeniency(), request.indexIncludeFrozen());
        if (!Strings.hasText((String)request.cursor())) {
            planExecutor.sql(cfg, request.query(), request.params(), (ActionListener<Cursor.Page>)ActionListener.wrap(p -> listener.onResponse((Object)TransportSqlQueryAction.createResponseWithSchema(request, p)), arg_0 -> listener.onFailure(arg_0)));
        } else {
            Tuple<Cursor, ZoneId> decoded = Cursors.decodeFromStringWithZone(request.cursor());
            planExecutor.nextPage(cfg, (Cursor)decoded.v1(), (ActionListener<Cursor.Page>)ActionListener.wrap(p -> listener.onResponse((Object)TransportSqlQueryAction.createResponse(request, (ZoneId)decoded.v2(), null, p)), arg_0 -> listener.onFailure(arg_0)));
        }
    }

    private static SqlQueryResponse createResponseWithSchema(SqlQueryRequest request, Cursor.Page page) {
        RowSet rset = page.rowSet();
        if (!(rset instanceof SchemaRowSet)) {
            throw new SqlIllegalArgumentException("No schema found inside {}", rset.getClass());
        }
        SchemaRowSet rowSet = (SchemaRowSet)rset;
        ArrayList<ColumnInfo> columns = new ArrayList(rowSet.columnCount());
        for (Schema.Entry entry : rowSet.schema()) {
            if (Mode.isDriver((Mode)request.mode())) {
                columns.add(new ColumnInfo("", entry.name(), entry.type().typeName(), Integer.valueOf(SqlDataTypes.displaySize(entry.type()))));
                continue;
            }
            columns.add(new ColumnInfo("", entry.name(), entry.type().typeName()));
        }
        columns = Collections.unmodifiableList(columns);
        return TransportSqlQueryAction.createResponse(request, request.zoneId(), columns, page);
    }

    private static SqlQueryResponse createResponse(SqlQueryRequest request, ZoneId zoneId, List<ColumnInfo> header, Cursor.Page page) {
        ArrayList rows = new ArrayList();
        page.rowSet().forEachRow(rowView -> {
            ArrayList row = new ArrayList(rowView.columnCount());
            rowView.forEachColumn(row::add);
            rows.add(Collections.unmodifiableList(row));
        });
        return new SqlQueryResponse(Cursors.encodeToString(page.next(), zoneId), request.mode(), request.columnar().booleanValue(), header, rows);
    }
}

