/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.sql.querydsl.agg;

import java.util.List;
import java.util.function.Function;
import org.elasticsearch.search.aggregations.AggregationBuilder;
import org.elasticsearch.search.aggregations.AggregationBuilders;
import org.elasticsearch.search.aggregations.metrics.PercentilesAggregationBuilder;
import org.elasticsearch.search.aggregations.support.ValuesSourceAggregationBuilder;
import org.elasticsearch.xpack.sql.querydsl.agg.AggSource;
import org.elasticsearch.xpack.sql.querydsl.agg.DefaultAggSourceLeafAgg;

public class PercentilesAgg
extends DefaultAggSourceLeafAgg {
    private final List<Double> percents;

    public PercentilesAgg(String id, AggSource source, List<Double> percents) {
        super(id, source);
        this.percents = percents;
    }

    @Override
    AggregationBuilder toBuilder() {
        PercentilesAggregationBuilder builder = (PercentilesAggregationBuilder)super.toBuilder();
        return builder.percentiles(this.percents.stream().mapToDouble(Double::doubleValue).toArray());
    }

    @Override
    Function<String, ValuesSourceAggregationBuilder<?>> builder() {
        return AggregationBuilders::percentiles;
    }
}

