/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.autoscaling;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.Build;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.ActionResponse;
import org.elasticsearch.action.ActionType;
import org.elasticsearch.client.Client;
import org.elasticsearch.cluster.NamedDiff;
import org.elasticsearch.cluster.metadata.IndexNameExpressionResolver;
import org.elasticsearch.cluster.metadata.Metadata;
import org.elasticsearch.cluster.node.DiscoveryNodes;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.ParseField;
import org.elasticsearch.common.io.stream.NamedWriteableRegistry;
import org.elasticsearch.common.settings.ClusterSettings;
import org.elasticsearch.common.settings.IndexScopedSettings;
import org.elasticsearch.common.settings.Setting;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.settings.SettingsFilter;
import org.elasticsearch.common.xcontent.NamedXContentRegistry;
import org.elasticsearch.env.Environment;
import org.elasticsearch.env.NodeEnvironment;
import org.elasticsearch.license.XPackLicenseState;
import org.elasticsearch.plugins.ActionPlugin;
import org.elasticsearch.plugins.ExtensiblePlugin;
import org.elasticsearch.plugins.Plugin;
import org.elasticsearch.repositories.RepositoriesService;
import org.elasticsearch.rest.RestController;
import org.elasticsearch.rest.RestHandler;
import org.elasticsearch.script.ScriptService;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.watcher.ResourceWatcherService;
import org.elasticsearch.xpack.autoscaling.AutoscalingExtension;
import org.elasticsearch.xpack.autoscaling.AutoscalingMetadata;
import org.elasticsearch.xpack.autoscaling.action.DeleteAutoscalingPolicyAction;
import org.elasticsearch.xpack.autoscaling.action.GetAutoscalingDecisionAction;
import org.elasticsearch.xpack.autoscaling.action.GetAutoscalingPolicyAction;
import org.elasticsearch.xpack.autoscaling.action.PutAutoscalingPolicyAction;
import org.elasticsearch.xpack.autoscaling.action.TransportDeleteAutoscalingPolicyAction;
import org.elasticsearch.xpack.autoscaling.action.TransportGetAutoscalingDecisionAction;
import org.elasticsearch.xpack.autoscaling.action.TransportGetAutoscalingPolicyAction;
import org.elasticsearch.xpack.autoscaling.action.TransportPutAutoscalingPolicyAction;
import org.elasticsearch.xpack.autoscaling.decision.AutoscalingDeciderConfiguration;
import org.elasticsearch.xpack.autoscaling.decision.AutoscalingDeciderService;
import org.elasticsearch.xpack.autoscaling.decision.AutoscalingDecision;
import org.elasticsearch.xpack.autoscaling.decision.AutoscalingDecisionService;
import org.elasticsearch.xpack.autoscaling.decision.FixedAutoscalingDeciderConfiguration;
import org.elasticsearch.xpack.autoscaling.decision.FixedAutoscalingDeciderService;
import org.elasticsearch.xpack.autoscaling.rest.RestDeleteAutoscalingPolicyHandler;
import org.elasticsearch.xpack.autoscaling.rest.RestGetAutoscalingDecisionHandler;
import org.elasticsearch.xpack.autoscaling.rest.RestGetAutoscalingPolicyHandler;
import org.elasticsearch.xpack.autoscaling.rest.RestPutAutoscalingPolicyHandler;
import org.elasticsearch.xpack.core.XPackPlugin;

public class Autoscaling
extends Plugin
implements ActionPlugin,
ExtensiblePlugin,
AutoscalingExtension {
    private static final Logger logger = LogManager.getLogger(AutoscalingExtension.class);
    private static final Boolean AUTOSCALING_FEATURE_FLAG_REGISTERED;
    public static final Setting<Boolean> AUTOSCALING_ENABLED_SETTING;
    private final boolean enabled;
    private final List<AutoscalingExtension> autoscalingExtensions;

    public Autoscaling(Settings settings) {
        this.enabled = (Boolean)AUTOSCALING_ENABLED_SETTING.get(settings);
        this.autoscalingExtensions = new ArrayList<AutoscalingExtension>(org.elasticsearch.common.collect.List.of((Object)this));
    }

    public List<Setting<?>> getSettings() {
        if (this.isSnapshot() || AUTOSCALING_FEATURE_FLAG_REGISTERED != null && AUTOSCALING_FEATURE_FLAG_REGISTERED.booleanValue()) {
            return org.elasticsearch.common.collect.List.of(AUTOSCALING_ENABLED_SETTING);
        }
        return org.elasticsearch.common.collect.List.of();
    }

    boolean isSnapshot() {
        return Build.CURRENT.isSnapshot();
    }

    public Collection<Object> createComponents(Client client, ClusterService clusterService, ThreadPool threadPool, ResourceWatcherService resourceWatcherService, ScriptService scriptService, NamedXContentRegistry xContentRegistry, Environment environment, NodeEnvironment nodeEnvironment, NamedWriteableRegistry namedWriteableRegistry, IndexNameExpressionResolver indexNameExpressionResolver, Supplier<RepositoriesService> repositoriesServiceSupplier) {
        return org.elasticsearch.common.collect.List.of((Object)new AutoscalingDecisionService.Holder(this));
    }

    public List<ActionPlugin.ActionHandler<? extends ActionRequest, ? extends ActionResponse>> getActions() {
        if (this.enabled) {
            return org.elasticsearch.common.collect.List.of((Object[])new ActionPlugin.ActionHandler[]{new ActionPlugin.ActionHandler((ActionType)GetAutoscalingDecisionAction.INSTANCE, TransportGetAutoscalingDecisionAction.class, new Class[0]), new ActionPlugin.ActionHandler((ActionType)DeleteAutoscalingPolicyAction.INSTANCE, TransportDeleteAutoscalingPolicyAction.class, new Class[0]), new ActionPlugin.ActionHandler((ActionType)GetAutoscalingPolicyAction.INSTANCE, TransportGetAutoscalingPolicyAction.class, new Class[0]), new ActionPlugin.ActionHandler((ActionType)PutAutoscalingPolicyAction.INSTANCE, TransportPutAutoscalingPolicyAction.class, new Class[0])});
        }
        return org.elasticsearch.common.collect.List.of();
    }

    public List<RestHandler> getRestHandlers(Settings settings, RestController controller, ClusterSettings clusterSettings, IndexScopedSettings indexScopedSettings, SettingsFilter settingsFilter, IndexNameExpressionResolver indexNameExpressionResolver, Supplier<DiscoveryNodes> nodesInCluster) {
        if (this.enabled) {
            return org.elasticsearch.common.collect.List.of((Object[])new RestHandler[]{new RestGetAutoscalingDecisionHandler(), new RestDeleteAutoscalingPolicyHandler(), new RestGetAutoscalingPolicyHandler(), new RestPutAutoscalingPolicyHandler()});
        }
        return org.elasticsearch.common.collect.List.of();
    }

    public List<NamedWriteableRegistry.Entry> getNamedWriteables() {
        return org.elasticsearch.common.collect.List.of((Object[])new NamedWriteableRegistry.Entry[]{new NamedWriteableRegistry.Entry(Metadata.Custom.class, "autoscaling", AutoscalingMetadata::new), new NamedWriteableRegistry.Entry(NamedDiff.class, "autoscaling", AutoscalingMetadata.AutoscalingMetadataDiff::new), new NamedWriteableRegistry.Entry(AutoscalingDeciderConfiguration.class, "fixed", FixedAutoscalingDeciderConfiguration::new), new NamedWriteableRegistry.Entry(AutoscalingDecision.Reason.class, "fixed", FixedAutoscalingDeciderService.FixedReason::new)});
    }

    public List<NamedXContentRegistry.Entry> getNamedXContent() {
        return org.elasticsearch.common.collect.List.of((Object)new NamedXContentRegistry.Entry(Metadata.Custom.class, new ParseField("autoscaling", new String[0]), AutoscalingMetadata::parse), (Object)new NamedXContentRegistry.Entry(AutoscalingDeciderConfiguration.class, new ParseField("fixed", new String[0]), FixedAutoscalingDeciderConfiguration::parse));
    }

    protected XPackLicenseState getLicenseState() {
        return XPackPlugin.getSharedLicenseState();
    }

    public void loadExtensions(ExtensiblePlugin.ExtensionLoader loader) {
        loader.loadExtensions(AutoscalingExtension.class).forEach(this.autoscalingExtensions::add);
    }

    @Override
    public Collection<AutoscalingDeciderService<? extends AutoscalingDeciderConfiguration>> deciders() {
        return org.elasticsearch.common.collect.List.of((Object)new FixedAutoscalingDeciderService());
    }

    public Set<AutoscalingDeciderService<? extends AutoscalingDeciderConfiguration>> createDeciderServices() {
        return this.autoscalingExtensions.stream().flatMap(p -> p.deciders().stream()).collect(Collectors.toSet());
    }

    static {
        String property = System.getProperty("es.autoscaling_feature_flag_registered");
        if (Build.CURRENT.isSnapshot() && property != null) {
            throw new IllegalArgumentException("es.autoscaling_feature_flag_registered is only supported in non-snapshot builds");
        }
        if ("true".equals(property)) {
            AUTOSCALING_FEATURE_FLAG_REGISTERED = true;
        } else if ("false".equals(property)) {
            AUTOSCALING_FEATURE_FLAG_REGISTERED = false;
        } else if (property == null) {
            AUTOSCALING_FEATURE_FLAG_REGISTERED = null;
        } else {
            throw new IllegalArgumentException("expected es.autoscaling_feature_flag_registered to be unset or [true|false] but was [" + property + "]");
        }
        AUTOSCALING_ENABLED_SETTING = Setting.boolSetting((String)"xpack.autoscaling.enabled", (boolean)false, (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope});
    }
}

