/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.autoscaling.action;

import java.io.IOException;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.support.ActionFilters;
import org.elasticsearch.action.support.master.TransportMasterNodeAction;
import org.elasticsearch.cluster.ClusterInfoService;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.block.ClusterBlockException;
import org.elasticsearch.cluster.metadata.IndexNameExpressionResolver;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.TransportService;
import org.elasticsearch.xpack.autoscaling.action.GetAutoscalingDecisionAction;
import org.elasticsearch.xpack.autoscaling.decision.AutoscalingDecisionService;

public class TransportGetAutoscalingDecisionAction
extends TransportMasterNodeAction<GetAutoscalingDecisionAction.Request, GetAutoscalingDecisionAction.Response> {
    private final AutoscalingDecisionService decisionService;
    private final ClusterInfoService clusterInfoService;

    @Inject
    public TransportGetAutoscalingDecisionAction(TransportService transportService, ClusterService clusterService, ThreadPool threadPool, ActionFilters actionFilters, IndexNameExpressionResolver indexNameExpressionResolver, AutoscalingDecisionService.Holder decisionServiceHolder, ClusterInfoService clusterInfoService) {
        super("cluster:admin/autoscaling/get_autoscaling_decision", transportService, clusterService, threadPool, actionFilters, GetAutoscalingDecisionAction.Request::new, indexNameExpressionResolver);
        this.decisionService = decisionServiceHolder.get();
        this.clusterInfoService = clusterInfoService;
        assert (this.decisionService != null);
    }

    protected String executor() {
        return "same";
    }

    protected GetAutoscalingDecisionAction.Response read(StreamInput in) throws IOException {
        return new GetAutoscalingDecisionAction.Response(in);
    }

    protected void masterOperation(GetAutoscalingDecisionAction.Request request, ClusterState state, ActionListener<GetAutoscalingDecisionAction.Response> listener) {
        listener.onResponse((Object)new GetAutoscalingDecisionAction.Response(this.decisionService.decide(state, this.clusterInfoService.getClusterInfo())));
    }

    protected ClusterBlockException checkBlock(GetAutoscalingDecisionAction.Request request, ClusterState state) {
        return null;
    }
}

