/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.autoscaling.decision;

import java.io.IOException;
import java.util.Objects;
import org.elasticsearch.common.ParseField;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Writeable;
import org.elasticsearch.common.unit.ByteSizeValue;
import org.elasticsearch.common.xcontent.ConstructingObjectParser;
import org.elasticsearch.common.xcontent.ObjectParser;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.xpack.autoscaling.decision.AutoscalingDeciderConfiguration;

public class FixedAutoscalingDeciderConfiguration
implements AutoscalingDeciderConfiguration {
    public static final String NAME = "fixed";
    private static final ConstructingObjectParser<FixedAutoscalingDeciderConfiguration, Void> PARSER = new ConstructingObjectParser("fixed", c -> new FixedAutoscalingDeciderConfiguration((ByteSizeValue)c[0], (ByteSizeValue)c[1], (Integer)c[2]));
    private static final ParseField STORAGE = new ParseField("storage", new String[0]);
    private static final ParseField MEMORY = new ParseField("memory", new String[0]);
    private static final ParseField NODES = new ParseField("nodes", new String[0]);
    private final ByteSizeValue storage;
    private final ByteSizeValue memory;
    private final Integer nodes;

    public static FixedAutoscalingDeciderConfiguration parse(XContentParser parser) {
        return (FixedAutoscalingDeciderConfiguration)PARSER.apply(parser, null);
    }

    public FixedAutoscalingDeciderConfiguration() {
        this(null, null, 1);
    }

    public FixedAutoscalingDeciderConfiguration(ByteSizeValue storage, ByteSizeValue memory, Integer nodes) {
        this.storage = storage;
        this.memory = memory;
        this.nodes = nodes;
    }

    public FixedAutoscalingDeciderConfiguration(StreamInput in) throws IOException {
        this.storage = (ByteSizeValue)in.readOptionalWriteable(ByteSizeValue::new);
        this.memory = (ByteSizeValue)in.readOptionalWriteable(ByteSizeValue::new);
        this.nodes = in.readOptionalInt();
    }

    public ByteSizeValue storage() {
        return this.storage;
    }

    public ByteSizeValue memory() {
        return this.memory;
    }

    public Integer nodes() {
        return this.nodes;
    }

    @Override
    public String name() {
        return NAME;
    }

    public String getWriteableName() {
        return NAME;
    }

    public void writeTo(StreamOutput out) throws IOException {
        out.writeOptionalWriteable((Writeable)this.storage);
        out.writeOptionalWriteable((Writeable)this.memory);
        out.writeOptionalInt(this.nodes);
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        if (this.storage != null) {
            builder.field("storage", this.storage.getStringRep());
        }
        if (this.memory != null) {
            builder.field("memory", this.memory.getStringRep());
        }
        if (this.nodes != null) {
            builder.field("nodes", this.nodes);
        }
        builder.endObject();
        return builder;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FixedAutoscalingDeciderConfiguration that = (FixedAutoscalingDeciderConfiguration)o;
        return Objects.equals(this.storage, that.storage) && Objects.equals(this.memory, that.memory) && Objects.equals(this.nodes, that.nodes);
    }

    public int hashCode() {
        return Objects.hash(this.storage, this.memory, this.nodes);
    }

    static {
        PARSER.declareField(ConstructingObjectParser.optionalConstructorArg(), (p, c) -> ByteSizeValue.parseBytesSizeValue((String)p.textOrNull(), (String)STORAGE.getPreferredName()), STORAGE, ObjectParser.ValueType.VALUE);
        PARSER.declareField(ConstructingObjectParser.optionalConstructorArg(), (p, c) -> ByteSizeValue.parseBytesSizeValue((String)p.textOrNull(), (String)MEMORY.getPreferredName()), MEMORY, ObjectParser.ValueType.VALUE);
        PARSER.declareInt(ConstructingObjectParser.optionalConstructorArg(), NODES);
    }
}

