/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.spatial.index.fielddata;

import org.apache.lucene.geo.GeoEncodingUtils;
import org.elasticsearch.xpack.spatial.index.fielddata.CoordinateEncoder;

public final class GeoShapeCoordinateEncoder
implements CoordinateEncoder {
    public static final GeoShapeCoordinateEncoder INSTANCE = new GeoShapeCoordinateEncoder();

    @Override
    public int encodeX(double x) {
        if (x == Double.NEGATIVE_INFINITY) {
            return Integer.MIN_VALUE;
        }
        if (x == Double.POSITIVE_INFINITY) {
            return Integer.MAX_VALUE;
        }
        return GeoEncodingUtils.encodeLongitude((double)x);
    }

    @Override
    public int encodeY(double y) {
        if (y == Double.NEGATIVE_INFINITY) {
            return Integer.MIN_VALUE;
        }
        if (y == Double.POSITIVE_INFINITY) {
            return Integer.MAX_VALUE;
        }
        return GeoEncodingUtils.encodeLatitude((double)y);
    }

    @Override
    public double decodeX(int x) {
        return GeoEncodingUtils.decodeLongitude((int)x);
    }

    @Override
    public double decodeY(int y) {
        return GeoEncodingUtils.decodeLatitude((int)y);
    }
}

