/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.spatial.search.aggregations.bucket.geogrid;

import org.elasticsearch.geometry.Rectangle;
import org.elasticsearch.geometry.utils.Geohash;
import org.elasticsearch.xpack.spatial.index.fielddata.GeoRelation;
import org.elasticsearch.xpack.spatial.index.fielddata.MultiGeoShapeValues;
import org.elasticsearch.xpack.spatial.search.aggregations.bucket.geogrid.GeoGridTiler;
import org.elasticsearch.xpack.spatial.search.aggregations.bucket.geogrid.GeoShapeCellValues;

public class GeoHashGridTiler
implements GeoGridTiler {
    @Override
    public long encode(double x, double y, int precision) {
        return Geohash.longEncode((double)x, (double)y, (int)precision);
    }

    @Override
    public int setValues(GeoShapeCellValues values, MultiGeoShapeValues.GeoShapeValue geoValue, int precision) {
        if (precision == 1) {
            values.resizeCell(1);
            values.add(0, Geohash.longEncode((double)0.0, (double)0.0, (int)0));
        }
        MultiGeoShapeValues.BoundingBox bounds = geoValue.boundingBox();
        assert (bounds.minX() <= bounds.maxX());
        if (bounds.minX() == bounds.maxX() && bounds.minY() == bounds.maxY()) {
            return this.setValue(values, geoValue, bounds, precision);
        }
        return this.setValuesByRasterization("", values, 0, precision, geoValue);
    }

    protected int setValue(GeoShapeCellValues docValues, MultiGeoShapeValues.GeoShapeValue geoValue, MultiGeoShapeValues.BoundingBox bounds, int precision) {
        String hash = Geohash.stringEncode((double)bounds.minX(), (double)bounds.minY(), (int)precision);
        docValues.resizeCell(1);
        docValues.add(0, Geohash.longEncode((String)hash));
        return 1;
    }

    protected GeoRelation relateTile(MultiGeoShapeValues.GeoShapeValue geoValue, String hash) {
        Rectangle rectangle = Geohash.toBoundingBox((String)hash);
        return geoValue.relate(rectangle);
    }

    protected int setValuesByBruteForceScan(GeoShapeCellValues values, MultiGeoShapeValues.GeoShapeValue geoValue, int precision, MultiGeoShapeValues.BoundingBox bounds) {
        int idx = 0;
        String min = Geohash.stringEncode((double)bounds.minX(), (double)bounds.minY(), (int)precision);
        String max = Geohash.stringEncode((double)bounds.maxX(), (double)bounds.maxY(), (int)precision);
        String minNeighborBelow = Geohash.getNeighbor((String)min, (int)precision, (int)0, (int)-1);
        double minY = Geohash.decodeLatitude((String)(minNeighborBelow == null ? min : minNeighborBelow));
        double minX = Geohash.decodeLongitude((String)min);
        double maxY = Geohash.decodeLatitude((String)max);
        double maxX = Geohash.decodeLongitude((String)max);
        for (double i = minX; i <= maxX; i += Geohash.lonWidthInDegrees((int)precision)) {
            for (double j = minY; j <= maxY; j += Geohash.latHeightInDegrees((int)precision)) {
                String hash = Geohash.stringEncode((double)i, (double)j, (int)precision);
                GeoRelation relation = this.relateTile(geoValue, hash);
                if (relation == GeoRelation.QUERY_DISJOINT) continue;
                values.resizeCell(idx + 1);
                values.add(idx++, this.encode(i, j, precision));
            }
        }
        return idx;
    }

    protected int setValuesByRasterization(String hash, GeoShapeCellValues values, int valuesIndex, int targetPrecision, MultiGeoShapeValues.GeoShapeValue geoValue) {
        String[] hashes = Geohash.getSubGeohashes((String)hash);
        for (int i = 0; i < hashes.length; ++i) {
            GeoRelation relation = this.relateTile(geoValue, hashes[i]);
            if (relation == GeoRelation.QUERY_CROSSES) {
                if (hashes[i].length() == targetPrecision) {
                    values.resizeCell(valuesIndex + 1);
                    values.add(valuesIndex++, Geohash.longEncode((String)hashes[i]));
                    continue;
                }
                valuesIndex = this.setValuesByRasterization(hashes[i], values, valuesIndex, targetPrecision, geoValue);
                continue;
            }
            if (relation != GeoRelation.QUERY_INSIDE) continue;
            if (hashes[i].length() == targetPrecision) {
                values.resizeCell(valuesIndex + 1);
                values.add(valuesIndex++, Geohash.longEncode((String)hashes[i]));
                continue;
            }
            values.resizeCell(valuesIndex + (int)Math.pow(32.0, targetPrecision - hash.length()) + 1);
            valuesIndex = this.setValuesForFullyContainedTile(hashes[i], values, valuesIndex, targetPrecision);
        }
        return valuesIndex;
    }

    protected int setValuesForFullyContainedTile(String hash, GeoShapeCellValues values, int valuesIndex, int targetPrecision) {
        String[] hashes = Geohash.getSubGeohashes((String)hash);
        for (int i = 0; i < hashes.length; ++i) {
            if (hashes[i].length() == targetPrecision) {
                values.add(valuesIndex++, Geohash.longEncode((String)hashes[i]));
                continue;
            }
            valuesIndex = this.setValuesForFullyContainedTile(hashes[i], values, valuesIndex, targetPrecision);
        }
        return valuesIndex;
    }
}

