/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.spatial.search.aggregations.bucket.geogrid;

import org.elasticsearch.geometry.Rectangle;
import org.elasticsearch.search.aggregations.bucket.geogrid.GeoTileUtils;
import org.elasticsearch.xpack.spatial.index.fielddata.GeoRelation;
import org.elasticsearch.xpack.spatial.index.fielddata.MultiGeoShapeValues;
import org.elasticsearch.xpack.spatial.search.aggregations.bucket.geogrid.GeoGridTiler;
import org.elasticsearch.xpack.spatial.search.aggregations.bucket.geogrid.GeoShapeCellValues;

public class GeoTileGridTiler
implements GeoGridTiler {
    @Override
    public long encode(double x, double y, int precision) {
        return GeoTileUtils.longEncode((double)x, (double)y, (int)precision);
    }

    public int advancePointValue(long[] values, double x, double y, int precision, int valuesIdx) {
        values[valuesIdx] = this.encode(x, y, precision);
        return valuesIdx + 1;
    }

    @Override
    public int setValues(GeoShapeCellValues values, MultiGeoShapeValues.GeoShapeValue geoValue, int precision) {
        int maxYTile;
        MultiGeoShapeValues.BoundingBox bounds = geoValue.boundingBox();
        assert (bounds.minX() <= bounds.maxX());
        if (precision == 0) {
            values.resizeCell(1);
            values.add(0, GeoTileUtils.longEncodeTiles((int)0, (long)0L, (long)0L));
            return 1;
        }
        if (bounds.top > GeoTileUtils.NORMALIZED_LATITUDE_MASK && bounds.bottom > GeoTileUtils.NORMALIZED_LATITUDE_MASK || bounds.top < GeoTileUtils.NORMALIZED_NEGATIVE_LATITUDE_MASK && bounds.bottom < GeoTileUtils.NORMALIZED_NEGATIVE_LATITUDE_MASK) {
            return 0;
        }
        double tiles = 1 << precision;
        int minXTile = GeoTileUtils.getXTile((double)bounds.minX(), (long)((long)tiles));
        int minYTile = GeoTileUtils.getYTile((double)bounds.maxY(), (long)((long)tiles));
        int maxXTile = GeoTileUtils.getXTile((double)bounds.maxX(), (long)((long)tiles));
        int count = (maxXTile - minXTile + 1) * ((maxYTile = GeoTileUtils.getYTile((double)bounds.minY(), (long)((long)tiles))) - minYTile + 1);
        if (count == 1) {
            return this.setValue(values, geoValue, minXTile, minYTile, precision);
        }
        if (count <= precision) {
            return this.setValuesByBruteForceScan(values, geoValue, precision, minXTile, minYTile, maxXTile, maxYTile);
        }
        return this.setValuesByRasterization(0, 0, 0, values, 0, precision, geoValue);
    }

    protected GeoRelation relateTile(MultiGeoShapeValues.GeoShapeValue geoValue, int xTile, int yTile, int precision) {
        Rectangle rectangle = GeoTileUtils.toBoundingBox((int)xTile, (int)yTile, (int)precision);
        return geoValue.relate(rectangle);
    }

    protected int setValue(GeoShapeCellValues docValues, MultiGeoShapeValues.GeoShapeValue geoValue, int xTile, int yTile, int precision) {
        docValues.resizeCell(1);
        docValues.add(0, GeoTileUtils.longEncodeTiles((int)precision, (long)xTile, (long)yTile));
        return 1;
    }

    protected int setValuesByBruteForceScan(GeoShapeCellValues values, MultiGeoShapeValues.GeoShapeValue geoValue, int precision, int minXTile, int minYTile, int maxXTile, int maxYTile) {
        int idx = 0;
        for (int i = minXTile; i <= maxXTile; ++i) {
            for (int j = minYTile; j <= maxYTile; ++j) {
                GeoRelation relation = this.relateTile(geoValue, i, j, precision);
                if (relation == GeoRelation.QUERY_DISJOINT) continue;
                values.resizeCell(idx + 1);
                values.add(idx++, GeoTileUtils.longEncodeTiles((int)precision, (long)i, (long)j));
            }
        }
        return idx;
    }

    protected int setValuesByRasterization(int xTile, int yTile, int zTile, GeoShapeCellValues values, int valuesIndex, int targetPrecision, MultiGeoShapeValues.GeoShapeValue geoValue) {
        ++zTile;
        for (int i = 0; i < 2; ++i) {
            for (int j = 0; j < 2; ++j) {
                int nextX = 2 * xTile + i;
                int nextY = 2 * yTile + j;
                GeoRelation relation = this.relateTile(geoValue, nextX, nextY, zTile);
                if (GeoRelation.QUERY_INSIDE == relation) {
                    if (zTile == targetPrecision) {
                        values.resizeCell(valuesIndex + 1);
                        values.add(valuesIndex++, GeoTileUtils.longEncodeTiles((int)zTile, (long)nextX, (long)nextY));
                        continue;
                    }
                    values.resizeCell(valuesIndex + 1 << 2 * (targetPrecision - zTile) + 1);
                    valuesIndex = this.setValuesForFullyContainedTile(nextX, nextY, zTile, values, valuesIndex, targetPrecision);
                    continue;
                }
                if (GeoRelation.QUERY_CROSSES != relation) continue;
                if (zTile == targetPrecision) {
                    values.resizeCell(valuesIndex + 1);
                    values.add(valuesIndex++, GeoTileUtils.longEncodeTiles((int)zTile, (long)nextX, (long)nextY));
                    continue;
                }
                valuesIndex = this.setValuesByRasterization(nextX, nextY, zTile, values, valuesIndex, targetPrecision, geoValue);
            }
        }
        return valuesIndex;
    }

    protected int setValuesForFullyContainedTile(int xTile, int yTile, int zTile, GeoShapeCellValues values, int valuesIndex, int targetPrecision) {
        ++zTile;
        for (int i = 0; i < 2; ++i) {
            for (int j = 0; j < 2; ++j) {
                int nextX = 2 * xTile + i;
                int nextY = 2 * yTile + j;
                if (zTile == targetPrecision) {
                    values.add(valuesIndex++, GeoTileUtils.longEncodeTiles((int)zTile, (long)nextX, (long)nextY));
                    continue;
                }
                valuesIndex = this.setValuesForFullyContainedTile(nextX, nextY, zTile, values, valuesIndex, targetPrecision);
            }
        }
        return valuesIndex;
    }
}

