/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.vectors.query;

import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import org.apache.lucene.index.BinaryDocValues;
import org.apache.lucene.index.DocValues;
import org.apache.lucene.index.LeafReader;
import org.apache.lucene.util.Accountable;
import org.apache.lucene.util.BytesRef;
import org.elasticsearch.index.fielddata.LeafFieldData;
import org.elasticsearch.index.fielddata.ScriptDocValues;
import org.elasticsearch.index.fielddata.SortedBinaryDocValues;
import org.elasticsearch.xpack.vectors.query.VectorScriptDocValues;

final class VectorDVLeafFieldData
implements LeafFieldData {
    private final LeafReader reader;
    private final String field;
    private final boolean isDense;

    VectorDVLeafFieldData(LeafReader reader, String field, boolean isDense) {
        this.reader = reader;
        this.field = field;
        this.isDense = isDense;
    }

    public long ramBytesUsed() {
        return 0L;
    }

    public Collection<Accountable> getChildResources() {
        return Collections.emptyList();
    }

    public SortedBinaryDocValues getBytesValues() {
        throw new UnsupportedOperationException("String representation of doc values for vector fields is not supported");
    }

    public ScriptDocValues<BytesRef> getScriptValues() {
        try {
            BinaryDocValues values = DocValues.getBinary((LeafReader)this.reader, (String)this.field);
            if (this.isDense) {
                return new VectorScriptDocValues.DenseVectorScriptDocValues(values);
            }
            return new VectorScriptDocValues.SparseVectorScriptDocValues(values);
        }
        catch (IOException e) {
            throw new IllegalStateException("Cannot load doc values for vector field!", e);
        }
    }

    public void close() {
    }
}

