/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.security.action.token;

import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.support.ActionFilters;
import org.elasticsearch.action.support.HandledTransportAction;
import org.elasticsearch.common.collect.Tuple;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.tasks.Task;
import org.elasticsearch.transport.TransportService;
import org.elasticsearch.xpack.core.security.action.token.CreateTokenRequest;
import org.elasticsearch.xpack.core.security.action.token.CreateTokenResponse;
import org.elasticsearch.xpack.security.action.token.TransportCreateTokenAction;
import org.elasticsearch.xpack.security.authc.TokenService;

public class TransportRefreshTokenAction
extends HandledTransportAction<CreateTokenRequest, CreateTokenResponse> {
    private final TokenService tokenService;

    @Inject
    public TransportRefreshTokenAction(TransportService transportService, ActionFilters actionFilters, TokenService tokenService) {
        super("cluster:admin/xpack/security/token/refresh", transportService, actionFilters, CreateTokenRequest::new);
        this.tokenService = tokenService;
    }

    protected void doExecute(Task task, CreateTokenRequest request, ActionListener<CreateTokenResponse> listener) {
        this.tokenService.refreshToken(request.getRefreshToken(), (ActionListener<Tuple<String, String>>)ActionListener.wrap(tuple -> {
            String scope = TransportCreateTokenAction.getResponseScopeValue(request.getScope());
            CreateTokenResponse response = new CreateTokenResponse((String)tuple.v1(), this.tokenService.getExpirationDelay(), scope, (String)tuple.v2(), null);
            listener.onResponse((Object)response);
        }, arg_0 -> listener.onFailure(arg_0)));
    }
}

