/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.security.authc.oidc;

import com.nimbusds.oauth2.sdk.id.State;
import com.nimbusds.openid.connect.sdk.Nonce;
import org.elasticsearch.common.Nullable;
import org.elasticsearch.xpack.core.security.authc.AuthenticationToken;

public class OpenIdConnectToken
implements AuthenticationToken {
    private String redirectUrl;
    private State state;
    private Nonce nonce;
    private String authenticatingRealm;

    public OpenIdConnectToken(String redirectUrl, State state, Nonce nonce, @Nullable String authenticatingRealm) {
        this.redirectUrl = redirectUrl;
        this.state = state;
        this.nonce = nonce;
        this.authenticatingRealm = authenticatingRealm;
    }

    public String principal() {
        return "<OIDC Token>";
    }

    public Object credentials() {
        return this.redirectUrl;
    }

    public void clearCredentials() {
        this.redirectUrl = null;
    }

    public State getState() {
        return this.state;
    }

    public Nonce getNonce() {
        return this.nonce;
    }

    public String getRedirectUrl() {
        return this.redirectUrl;
    }

    public String getAuthenticatingRealm() {
        return this.authenticatingRealm;
    }

    public String toString() {
        return this.getClass().getSimpleName() + "{ redirectUrl=" + this.redirectUrl + ", state=" + this.state + ", nonce=" + this.nonce + ", authenticatingRealm=" + this.authenticatingRealm + "}";
    }
}

