/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.security.authz.interceptor;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.elasticsearch.ElasticsearchSecurityException;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.admin.indices.alias.IndicesAliasesRequest;
import org.elasticsearch.action.support.ContextPreservingActionListener;
import org.elasticsearch.common.MemoizedSupplier;
import org.elasticsearch.common.collect.Tuple;
import org.elasticsearch.common.util.concurrent.ThreadContext;
import org.elasticsearch.license.XPackLicenseState;
import org.elasticsearch.rest.RestStatus;
import org.elasticsearch.transport.TransportRequest;
import org.elasticsearch.xpack.core.security.authz.AuthorizationEngine;
import org.elasticsearch.xpack.core.security.authz.accesscontrol.IndicesAccessControl;
import org.elasticsearch.xpack.core.security.support.Exceptions;
import org.elasticsearch.xpack.security.audit.AuditTrail;
import org.elasticsearch.xpack.security.audit.AuditTrailService;
import org.elasticsearch.xpack.security.audit.AuditUtil;
import org.elasticsearch.xpack.security.authz.interceptor.RequestInterceptor;

public final class IndicesAliasesRequestInterceptor
implements RequestInterceptor {
    private final ThreadContext threadContext;
    private final XPackLicenseState licenseState;
    private final AuditTrailService auditTrailService;

    public IndicesAliasesRequestInterceptor(ThreadContext threadContext, XPackLicenseState licenseState, AuditTrailService auditTrailService) {
        this.threadContext = threadContext;
        this.licenseState = licenseState;
        this.auditTrailService = auditTrailService;
    }

    @Override
    public void intercept(AuthorizationEngine.RequestInfo requestInfo, AuthorizationEngine authorizationEngine, AuthorizationEngine.AuthorizationInfo authorizationInfo, ActionListener<Void> listener) {
        if (requestInfo.getRequest() instanceof IndicesAliasesRequest) {
            IndicesAliasesRequest request = (IndicesAliasesRequest)requestInfo.getRequest();
            XPackLicenseState frozenLicenseState = this.licenseState.copyCurrentLicenseState();
            AuditTrail auditTrail = this.auditTrailService.get();
            if (frozenLicenseState.isSecurityEnabled()) {
                MemoizedSupplier licenseChecker = new MemoizedSupplier(() -> frozenLicenseState.checkFeature(XPackLicenseState.Feature.SECURITY_DLS_FLS));
                IndicesAccessControl indicesAccessControl = (IndicesAccessControl)this.threadContext.getTransient("_indices_permissions");
                for (IndicesAliasesRequest.AliasActions aliasAction2 : request.getAliasActions()) {
                    if (aliasAction2.actionType() != IndicesAliasesRequest.AliasActions.Type.ADD) continue;
                    for (String index : aliasAction2.indices()) {
                        IndicesAccessControl.IndexAccessControl indexAccessControl = indicesAccessControl.getIndexPermissions(index);
                        if (indexAccessControl == null) continue;
                        boolean fls = indexAccessControl.getFieldPermissions().hasFieldLevelSecurity();
                        boolean dls = indexAccessControl.getDocumentPermissions().hasDocumentLevelPermissions();
                        if (!fls && !dls || !((Boolean)licenseChecker.get()).booleanValue()) continue;
                        listener.onFailure((Exception)new ElasticsearchSecurityException("Alias requests are not allowed for users who have field or document level security enabled on one of the indices", RestStatus.BAD_REQUEST, new Object[0]));
                        return;
                    }
                }
                Map<String, List> indexToAliasesMap = request.getAliasActions().stream().filter(aliasAction -> aliasAction.actionType() == IndicesAliasesRequest.AliasActions.Type.ADD).flatMap(aliasActions -> Arrays.stream(aliasActions.indices()).map(indexName -> new Tuple(indexName, Arrays.asList(aliasActions.aliases())))).collect(Collectors.toMap(Tuple::v1, Tuple::v2, (existing, toMerge) -> {
                    ArrayList list = new ArrayList(existing.size() + toMerge.size());
                    list.addAll(existing);
                    list.addAll(toMerge);
                    return list;
                }));
                authorizationEngine.validateIndexPermissionsAreSubset(requestInfo, authorizationInfo, indexToAliasesMap, (ActionListener)ContextPreservingActionListener.wrapPreservingContext((ActionListener)ActionListener.wrap(authzResult -> {
                    if (authzResult.isGranted()) {
                        listener.onResponse(null);
                    } else {
                        auditTrail.accessDenied(AuditUtil.extractRequestId(this.threadContext), requestInfo.getAuthentication(), requestInfo.getAction(), (TransportRequest)request, authorizationInfo);
                        listener.onFailure((Exception)Exceptions.authorizationError((String)"Adding an alias is not allowed when the alias has more permissions than any of the indices", (Object[])new Object[0]));
                    }
                }, arg_0 -> listener.onFailure(arg_0)), (ThreadContext)this.threadContext));
            } else {
                listener.onResponse(null);
            }
        } else {
            listener.onResponse(null);
        }
    }
}

