/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.security.rest.action.privilege;

import java.io.IOException;
import java.util.Collections;
import java.util.List;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.ActionType;
import org.elasticsearch.client.node.NodeClient;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.license.XPackLicenseState;
import org.elasticsearch.rest.BaseRestHandler;
import org.elasticsearch.rest.RestHandler;
import org.elasticsearch.rest.RestRequest;
import org.elasticsearch.rest.action.RestActions;
import org.elasticsearch.xpack.core.security.action.privilege.ClearPrivilegesCacheAction;
import org.elasticsearch.xpack.core.security.action.privilege.ClearPrivilegesCacheRequest;
import org.elasticsearch.xpack.security.rest.action.SecurityBaseRestHandler;

public class RestClearPrivilegesCacheAction
extends SecurityBaseRestHandler {
    public RestClearPrivilegesCacheAction(Settings settings, XPackLicenseState licenseState) {
        super(settings, licenseState);
    }

    public String getName() {
        return "security_clear_privileges_cache_action";
    }

    public List<RestHandler.Route> routes() {
        return Collections.singletonList(new RestHandler.Route(RestRequest.Method.POST, "/_security/privilege/{application}/_clear_cache"));
    }

    @Override
    protected BaseRestHandler.RestChannelConsumer innerPrepareRequest(RestRequest request, NodeClient client) throws IOException {
        String[] applicationNames = request.paramAsStringArrayOrEmptyIfAll("application");
        ClearPrivilegesCacheRequest req = new ClearPrivilegesCacheRequest().applicationNames(applicationNames);
        return channel -> client.execute((ActionType)ClearPrivilegesCacheAction.INSTANCE, (ActionRequest)req, (ActionListener)new RestActions.NodesResponseRestListener(channel));
    }
}

