/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.security.support;

import java.util.Collection;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.elasticsearch.xpack.security.support.SecurityIndexManager;

public class CacheInvalidatorRegistry {
    private final Map<String, CacheInvalidator> cacheInvalidators = new ConcurrentHashMap<String, CacheInvalidator>();

    public void registerCacheInvalidator(String name, CacheInvalidator cacheInvalidator) {
        if (this.cacheInvalidators.containsKey(name)) {
            throw new IllegalArgumentException("Cache invalidator registry already has an entry with name: [" + name + "]");
        }
        this.cacheInvalidators.put(name, cacheInvalidator);
    }

    public void onSecurityIndexStageChange(SecurityIndexManager.State previousState, SecurityIndexManager.State currentState) {
        if (SecurityIndexManager.isMoveFromRedToNonRed(previousState, currentState) || SecurityIndexManager.isIndexDeleted(previousState, currentState) || previousState.isIndexUpToDate != currentState.isIndexUpToDate) {
            this.cacheInvalidators.values().forEach(CacheInvalidator::invalidateAll);
        }
    }

    public void invalidateByKey(String cacheName, Collection<String> keys) {
        CacheInvalidator cacheInvalidator = this.cacheInvalidators.get(cacheName);
        if (cacheInvalidator == null) {
            throw new IllegalArgumentException("No cache named [" + cacheName + "] is found");
        }
        cacheInvalidator.invalidate(keys);
    }

    public void invalidateCache(String cacheName) {
        CacheInvalidator cacheInvalidator = this.cacheInvalidators.get(cacheName);
        if (cacheInvalidator == null) {
            throw new IllegalArgumentException("No cache named [" + cacheName + "] is found");
        }
        cacheInvalidator.invalidateAll();
    }

    public static interface CacheInvalidator {
        public void invalidate(Collection<String> var1);

        public void invalidateAll();
    }
}

