/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.security.transport.nio;

import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.function.IntFunction;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLEngineResult;
import javax.net.ssl.SSLException;
import javax.net.ssl.SSLSession;
import org.elasticsearch.nio.FlushOperation;
import org.elasticsearch.nio.InboundChannelBuffer;
import org.elasticsearch.nio.Page;
import org.elasticsearch.nio.utils.ByteBufferUtils;
import org.elasticsearch.nio.utils.ExceptionsHelper;
import org.elasticsearch.xpack.security.transport.nio.SSLOutboundBuffer;

public class SSLDriver
implements AutoCloseable {
    private static final ByteBuffer[] EMPTY_BUFFERS = new ByteBuffer[]{ByteBuffer.allocate(0)};
    private static final FlushOperation EMPTY_FLUSH_OPERATION = new FlushOperation(EMPTY_BUFFERS, (r, t) -> {});
    private final SSLEngine engine;
    private final IntFunction<Page> pageAllocator;
    private final SSLOutboundBuffer outboundBuffer;
    private Page networkReadPage;
    private final boolean isClientMode;
    private Mode currentMode = new RegularMode();
    private int packetSize;

    public SSLDriver(SSLEngine engine, IntFunction<Page> pageAllocator, boolean isClientMode) {
        this.engine = engine;
        this.pageAllocator = pageAllocator;
        this.outboundBuffer = new SSLOutboundBuffer(pageAllocator);
        this.isClientMode = isClientMode;
        SSLSession session = engine.getSession();
        this.packetSize = session.getPacketBufferSize();
    }

    public void init() throws SSLException {
        this.engine.setUseClientMode(this.isClientMode);
        if (this.currentMode.isClose()) {
            throw new AssertionError((Object)("Attempted to init outside from non-handshaking mode: " + this.currentMode.modeName()));
        }
        this.engine.beginHandshake();
        ((RegularMode)this.currentMode).startHandshake();
        try {
            ((RegularMode)this.currentMode).handshake();
        }
        catch (SSLException e) {
            this.currentMode = new CloseMode(((RegularMode)this.currentMode).isHandshaking, false);
            throw e;
        }
    }

    public void renegotiate() throws SSLException {
        if (this.currentMode.isClose()) {
            throw new IllegalStateException("Attempted to renegotiate while in invalid mode: " + this.currentMode.modeName());
        }
        this.engine.beginHandshake();
        ((RegularMode)this.currentMode).startHandshake();
    }

    public SSLEngine getSSLEngine() {
        return this.engine;
    }

    public SSLOutboundBuffer getOutboundBuffer() {
        return this.outboundBuffer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void read(InboundChannelBuffer encryptedBuffer, InboundChannelBuffer applicationBuffer) throws SSLException {
        this.networkReadPage = this.pageAllocator.apply(this.packetSize);
        try {
            boolean continueUnwrap = true;
            while (continueUnwrap && encryptedBuffer.getIndex() > 0L) {
                int bytesConsumed = this.currentMode.read(encryptedBuffer, applicationBuffer);
                continueUnwrap = bytesConsumed > 0;
            }
        }
        finally {
            this.networkReadPage.close();
            this.networkReadPage = null;
        }
    }

    public boolean readyForApplicationData() {
        return this.currentMode.readyForApplicationData();
    }

    public int write(FlushOperation applicationBytes) throws SSLException {
        int totalBytesProduced = 0;
        boolean continueWrap = true;
        while (continueWrap && !applicationBytes.isFullyFlushed()) {
            int bytesProduced = this.currentMode.write(applicationBytes);
            totalBytesProduced += bytesProduced;
            continueWrap = bytesProduced > 0;
        }
        return totalBytesProduced;
    }

    public void initiateClose() throws SSLException {
        this.internalClose();
    }

    public boolean isClosed() {
        return this.currentMode.isClose() && ((CloseMode)this.currentMode).isCloseDone();
    }

    @Override
    public void close() throws SSLException {
        CloseMode closeMode;
        this.outboundBuffer.close();
        ArrayList<SSLException> closingExceptions = new ArrayList<SSLException>(2);
        if (!this.currentMode.isClose()) {
            this.currentMode = new CloseMode(((RegularMode)this.currentMode).isHandshaking, false);
        }
        if ((closeMode = (CloseMode)this.currentMode).needToSendClose) {
            closingExceptions.add(new SSLException("Closed engine without completely sending the close alert message."));
            this.engine.closeOutbound();
        }
        if (closeMode.needToReceiveClose) {
            closingExceptions.add(new SSLException("Closed engine without receiving the close alert message."));
        }
        closeMode.closeInboundAndSwallowPeerDidNotCloseException();
        ExceptionsHelper.rethrowAndSuppress(closingExceptions);
    }

    private SSLEngineResult unwrap(InboundChannelBuffer networkBuffer, InboundChannelBuffer applicationBuffer) throws SSLException {
        SSLEngineResult result;
        block6: while (true) {
            this.ensureApplicationBufferSize(applicationBuffer);
            ByteBuffer networkReadBuffer = this.networkReadPage.byteBuffer();
            networkReadBuffer.clear();
            ByteBufferUtils.copyBytes((ByteBuffer[])networkBuffer.sliceBuffersTo(Math.min(networkBuffer.getIndex(), (long)this.packetSize)), (ByteBuffer)networkReadBuffer);
            networkReadBuffer.flip();
            result = this.engine.unwrap(networkReadBuffer, applicationBuffer.sliceBuffersFrom(applicationBuffer.getIndex()));
            networkBuffer.release((long)result.bytesConsumed());
            applicationBuffer.incrementIndex((long)result.bytesProduced());
            switch (result.getStatus()) {
                case OK: {
                    return result;
                }
                case BUFFER_UNDERFLOW: {
                    this.packetSize = this.engine.getSession().getPacketBufferSize();
                    if (this.networkReadPage.byteBuffer().capacity() < this.packetSize) {
                        this.networkReadPage.close();
                        this.networkReadPage = this.pageAllocator.apply(this.packetSize);
                        continue block6;
                    }
                    return result;
                }
                case BUFFER_OVERFLOW: {
                    this.ensureApplicationBufferSize(applicationBuffer);
                    continue block6;
                }
                case CLOSED: {
                    assert (this.engine.isInboundDone()) : "We received close_notify so read should be done";
                    this.internalClose();
                    return result;
                }
            }
            break;
        }
        throw new IllegalStateException("Unexpected UNWRAP result: " + (Object)((Object)result.getStatus()));
    }

    private SSLEngineResult wrap(SSLOutboundBuffer outboundBuffer) throws SSLException {
        return this.wrap(outboundBuffer, EMPTY_FLUSH_OPERATION);
    }

    private SSLEngineResult wrap(SSLOutboundBuffer outboundBuffer, FlushOperation applicationBytes) throws SSLException {
        SSLEngineResult result;
        ByteBuffer[] buffers = applicationBytes.getBuffersToWrite(this.engine.getSession().getApplicationBufferSize());
        block7: while (true) {
            ByteBuffer networkBuffer = outboundBuffer.nextWriteBuffer(this.packetSize);
            try {
                result = this.engine.wrap(buffers, networkBuffer);
            }
            catch (SSLException e) {
                outboundBuffer.incrementEncryptedBytes(0);
                throw e;
            }
            outboundBuffer.incrementEncryptedBytes(result.bytesProduced());
            applicationBytes.incrementIndex(result.bytesConsumed());
            switch (result.getStatus()) {
                case OK: 
                case CLOSED: {
                    return result;
                }
                case BUFFER_UNDERFLOW: {
                    throw new IllegalStateException("Should not receive BUFFER_UNDERFLOW on WRAP");
                }
                case BUFFER_OVERFLOW: {
                    this.packetSize = this.engine.getSession().getPacketBufferSize();
                    continue block7;
                }
            }
            break;
        }
        throw new IllegalStateException("Unexpected WRAP result: " + (Object)((Object)result.getStatus()));
    }

    private void internalClose() throws SSLException {
        if (!this.currentMode.isClose()) {
            this.currentMode = new CloseMode(((RegularMode)this.currentMode).isHandshaking);
        }
    }

    private void ensureApplicationBufferSize(InboundChannelBuffer applicationBuffer) {
        int applicationBufferSize = this.engine.getSession().getApplicationBufferSize();
        if (applicationBuffer.getRemaining() < (long)applicationBufferSize) {
            applicationBuffer.ensureCapacity(applicationBuffer.getIndex() + (long)this.engine.getSession().getApplicationBufferSize());
        }
    }

    private class CloseMode
    implements Mode {
        private boolean needToSendClose = true;
        private boolean needToReceiveClose = true;

        private CloseMode(boolean isHandshaking) throws SSLException {
            this(isHandshaking, true);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private CloseMode(boolean isHandshaking, boolean tryToWrap) throws SSLException {
            if (isHandshaking && !SSLDriver.this.engine.isInboundDone()) {
                this.needToReceiveClose = false;
            } else if (SSLDriver.this.engine.isInboundDone()) {
                this.needToReceiveClose = false;
            }
            if (SSLDriver.this.engine.isOutboundDone()) {
                this.needToSendClose = false;
            } else {
                SSLDriver.this.engine.closeOutbound();
                if (tryToWrap) {
                    try {
                        boolean continueWrap = true;
                        while (continueWrap) {
                            continueWrap = SSLDriver.this.wrap(SSLDriver.this.outboundBuffer).getHandshakeStatus() == SSLEngineResult.HandshakeStatus.NEED_WRAP;
                        }
                    }
                    finally {
                        this.needToSendClose = false;
                    }
                }
            }
        }

        @Override
        public int read(InboundChannelBuffer encryptedBuffer, InboundChannelBuffer applicationBuffer) throws SSLException {
            if (!this.needToReceiveClose) {
                return 0;
            }
            SSLEngineResult result = SSLDriver.this.unwrap(encryptedBuffer, applicationBuffer);
            if (SSLDriver.this.engine.isInboundDone()) {
                this.needToReceiveClose = false;
            }
            return result.bytesConsumed();
        }

        @Override
        public int write(FlushOperation applicationBytes) {
            return 0;
        }

        @Override
        public boolean isClose() {
            return true;
        }

        @Override
        public boolean readyForApplicationData() {
            return false;
        }

        @Override
        public String modeName() {
            return "CLOSE";
        }

        private boolean isCloseDone() {
            return !this.needToReceiveClose;
        }

        private void closeInboundAndSwallowPeerDidNotCloseException() throws SSLException {
            block2: {
                try {
                    SSLDriver.this.engine.closeInbound();
                }
                catch (SSLException e) {
                    if (e.getMessage().contains("before receiving peer's close_notify")) break block2;
                    throw e;
                }
            }
        }
    }

    private class RegularMode
    implements Mode {
        private SSLEngineResult.HandshakeStatus handshakeStatus;
        private boolean isHandshaking = false;

        private RegularMode() {
        }

        private void startHandshake() {
            this.handshakeStatus = SSLDriver.this.engine.getHandshakeStatus();
            this.isHandshaking = true;
        }

        private void handshake() throws SSLException {
            boolean continueHandshaking = true;
            while (continueHandshaking) {
                switch (this.handshakeStatus) {
                    case NEED_UNWRAP: {
                        this.isHandshaking = true;
                        continueHandshaking = false;
                        break;
                    }
                    case NEED_WRAP: {
                        this.isHandshaking = true;
                        this.handshakeStatus = SSLDriver.this.wrap(SSLDriver.this.outboundBuffer).getHandshakeStatus();
                        break;
                    }
                    case NEED_TASK: {
                        this.runTasks();
                        this.isHandshaking = true;
                        this.handshakeStatus = SSLDriver.this.engine.getHandshakeStatus();
                        break;
                    }
                    case NOT_HANDSHAKING: 
                    case FINISHED: {
                        this.isHandshaking = false;
                        continueHandshaking = false;
                    }
                }
            }
        }

        @Override
        public int read(InboundChannelBuffer encryptedBuffer, InboundChannelBuffer applicationBuffer) throws SSLException {
            try {
                SSLEngineResult result = SSLDriver.this.unwrap(encryptedBuffer, applicationBuffer);
                this.handshakeStatus = result.getHandshakeStatus();
                if (result.getStatus() != SSLEngineResult.Status.CLOSED) {
                    this.handshake();
                }
                return result.bytesConsumed();
            }
            catch (SSLException e) {
                this.handshakeStatus = SSLDriver.this.engine.getHandshakeStatus();
                try {
                    SSLDriver.this.internalClose();
                }
                catch (SSLException closeException) {
                    e.addSuppressed(closeException);
                }
                throw e;
            }
        }

        @Override
        public int write(FlushOperation applicationBytes) throws SSLException {
            SSLEngineResult result = SSLDriver.this.wrap(SSLDriver.this.outboundBuffer, applicationBytes);
            this.handshakeStatus = result.getHandshakeStatus();
            return result.bytesProduced();
        }

        @Override
        public boolean isClose() {
            return false;
        }

        @Override
        public boolean readyForApplicationData() {
            return !this.isHandshaking;
        }

        @Override
        public String modeName() {
            return "REGULAR";
        }

        private void runTasks() {
            Runnable delegatedTask;
            while ((delegatedTask = SSLDriver.this.engine.getDelegatedTask()) != null) {
                delegatedTask.run();
            }
        }
    }

    private static interface Mode {
        public int read(InboundChannelBuffer var1, InboundChannelBuffer var2) throws SSLException;

        public int write(FlushOperation var1) throws SSLException;

        public boolean isClose();

        public boolean readyForApplicationData();

        public String modeName();
    }
}

