/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.cluster.metadata;

import java.io.IOException;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.elasticsearch.Version;
import org.elasticsearch.cluster.Diff;
import org.elasticsearch.cluster.DiffableUtils;
import org.elasticsearch.cluster.NamedDiff;
import org.elasticsearch.cluster.metadata.DataStream;
import org.elasticsearch.cluster.metadata.Metadata;
import org.elasticsearch.common.ParseField;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.xcontent.ConstructingObjectParser;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentParser;

public class DataStreamMetadata
implements Metadata.Custom {
    public static final String TYPE = "data_stream";
    private static final ParseField DATA_STREAM = new ParseField("data_stream", new String[0]);
    private static final ConstructingObjectParser<DataStreamMetadata, Void> PARSER = new ConstructingObjectParser("data_stream", false, a -> new DataStreamMetadata((Map)a[0]));
    private final Map<String, DataStream> dataStreams;

    public DataStreamMetadata(Map<String, DataStream> dataStreams) {
        this.dataStreams = dataStreams;
    }

    public DataStreamMetadata(StreamInput in) throws IOException {
        this.dataStreams = in.readMap(StreamInput::readString, DataStream::new);
    }

    public Map<String, DataStream> dataStreams() {
        return this.dataStreams;
    }

    @Override
    public Diff<Metadata.Custom> diff(Metadata.Custom before) {
        return new DataStreamMetadataDiff((DataStreamMetadata)before, this);
    }

    public static NamedDiff<Metadata.Custom> readDiffFrom(StreamInput in) throws IOException {
        return new DataStreamMetadataDiff(in);
    }

    @Override
    public EnumSet<Metadata.XContentContext> context() {
        return Metadata.ALL_CONTEXTS;
    }

    @Override
    public String getWriteableName() {
        return TYPE;
    }

    @Override
    public Version getMinimalSupportedVersion() {
        return Version.V_7_7_0;
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        out.writeMap(this.dataStreams, StreamOutput::writeString, (stream, val) -> val.writeTo(stream));
    }

    public static DataStreamMetadata fromXContent(XContentParser parser) throws IOException {
        return PARSER.parse(parser, null);
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject(DATA_STREAM.getPreferredName());
        for (Map.Entry<String, DataStream> dataStream : this.dataStreams.entrySet()) {
            builder.field(dataStream.getKey(), dataStream.getValue());
        }
        builder.endObject();
        return builder;
    }

    public static Builder builder() {
        return new Builder();
    }

    public int hashCode() {
        return Objects.hash(this.dataStreams);
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj.getClass() != this.getClass()) {
            return false;
        }
        DataStreamMetadata other = (DataStreamMetadata)obj;
        return Objects.equals(this.dataStreams, other.dataStreams);
    }

    public String toString() {
        return Strings.toString(this);
    }

    static {
        PARSER.declareObject(ConstructingObjectParser.constructorArg(), (p, c) -> {
            HashMap<String, DataStream> dataStreams = new HashMap<String, DataStream>();
            while (p.nextToken() != XContentParser.Token.END_OBJECT) {
                String name = p.currentName();
                dataStreams.put(name, DataStream.fromXContent(p));
            }
            return dataStreams;
        }, DATA_STREAM);
    }

    static class DataStreamMetadataDiff
    implements NamedDiff<Metadata.Custom> {
        final Diff<Map<String, DataStream>> dataStreamDiff;

        DataStreamMetadataDiff(DataStreamMetadata before, DataStreamMetadata after) {
            this.dataStreamDiff = DiffableUtils.diff(before.dataStreams, after.dataStreams, DiffableUtils.getStringKeySerializer());
        }

        DataStreamMetadataDiff(StreamInput in) throws IOException {
            this.dataStreamDiff = DiffableUtils.readJdkMapDiff(in, DiffableUtils.getStringKeySerializer(), DataStream::new, DataStream::readDiffFrom);
        }

        @Override
        public Metadata.Custom apply(Metadata.Custom part) {
            return new DataStreamMetadata(this.dataStreamDiff.apply(((DataStreamMetadata)part).dataStreams));
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
            this.dataStreamDiff.writeTo(out);
        }

        @Override
        public String getWriteableName() {
            return DataStreamMetadata.TYPE;
        }
    }

    public static class Builder {
        private final Map<String, DataStream> dataStreams = new HashMap<String, DataStream>();

        public Builder putDataStream(DataStream dataStream) {
            this.dataStreams.put(dataStream.getName(), dataStream);
            return this;
        }

        public DataStreamMetadata build() {
            return new DataStreamMetadata(this.dataStreams);
        }
    }
}

