/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.seqno;

import java.util.Objects;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.support.replication.ReplicationResponse;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.index.seqno.RetentionLeaseBackgroundSyncAction;
import org.elasticsearch.index.seqno.RetentionLeaseSyncAction;
import org.elasticsearch.index.seqno.RetentionLeases;
import org.elasticsearch.index.shard.ShardId;

public class RetentionLeaseSyncer {
    private final SyncAction syncAction;
    private final BackgroundSyncAction backgroundSyncAction;
    public static final RetentionLeaseSyncer EMPTY = new RetentionLeaseSyncer((shardId, primaryAllocationId, primaryTerm, retentionLeases, listener) -> listener.onResponse(new ReplicationResponse()), (shardId, primaryAllocationId, primaryTerm, retentionLeases) -> {});

    @Inject
    public RetentionLeaseSyncer(RetentionLeaseSyncAction syncAction, RetentionLeaseBackgroundSyncAction backgroundSyncAction) {
        this(syncAction::sync, backgroundSyncAction::backgroundSync);
    }

    public RetentionLeaseSyncer(SyncAction syncAction, BackgroundSyncAction backgroundSyncAction) {
        this.syncAction = Objects.requireNonNull(syncAction);
        this.backgroundSyncAction = Objects.requireNonNull(backgroundSyncAction);
    }

    public void sync(ShardId shardId, String primaryAllocationId, long primaryTerm, RetentionLeases retentionLeases, ActionListener<ReplicationResponse> listener) {
        this.syncAction.sync(shardId, primaryAllocationId, primaryTerm, retentionLeases, listener);
    }

    public void backgroundSync(ShardId shardId, String primaryAllocationId, long primaryTerm, RetentionLeases retentionLeases) {
        this.backgroundSyncAction.backgroundSync(shardId, primaryAllocationId, primaryTerm, retentionLeases);
    }

    public static interface BackgroundSyncAction {
        public void backgroundSync(ShardId var1, String var2, long var3, RetentionLeases var5);
    }

    public static interface SyncAction {
        public void sync(ShardId var1, String var2, long var3, RetentionLeases var5, ActionListener<ReplicationResponse> var6);
    }
}

