/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.Objects;
import org.apache.lucene.search.SortField;
import org.apache.lucene.search.TotalHits;
import org.elasticsearch.Version;
import org.elasticsearch.common.Nullable;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Writeable;
import org.elasticsearch.common.lucene.Lucene;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.ToXContentFragment;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.common.xcontent.XContentParserUtils;
import org.elasticsearch.search.SearchHit;

public final class SearchHits
implements Writeable,
ToXContentFragment,
Iterable<SearchHit> {
    public static final SearchHit[] EMPTY = new SearchHit[0];
    private final SearchHit[] hits;
    private final TotalHits totalHits;
    private final float maxScore;
    @Nullable
    private final SortField[] sortFields;
    @Nullable
    private final String collapseField;
    @Nullable
    private final Object[] collapseValues;

    public static SearchHits empty() {
        return SearchHits.empty(true);
    }

    public static SearchHits empty(boolean withTotalHits) {
        return new SearchHits(EMPTY, withTotalHits ? new TotalHits(0L, TotalHits.Relation.EQUAL_TO) : null, 0.0f);
    }

    public SearchHits(SearchHit[] hits, @Nullable TotalHits totalHits, float maxScore) {
        this(hits, totalHits, maxScore, null, null, null);
    }

    public SearchHits(SearchHit[] hits, @Nullable TotalHits totalHits, float maxScore, @Nullable SortField[] sortFields, @Nullable String collapseField, @Nullable Object[] collapseValues) {
        this.hits = hits;
        this.totalHits = totalHits;
        this.maxScore = maxScore;
        this.sortFields = sortFields;
        this.collapseField = collapseField;
        this.collapseValues = collapseValues;
    }

    public SearchHits(StreamInput in) throws IOException {
        this.totalHits = in.readBoolean() ? Lucene.readTotalHits(in) : null;
        this.maxScore = in.readFloat();
        int size = in.readVInt();
        if (size == 0) {
            this.hits = EMPTY;
        } else {
            this.hits = new SearchHit[size];
            for (int i = 0; i < this.hits.length; ++i) {
                this.hits[i] = new SearchHit(in);
            }
        }
        if (in.getVersion().onOrAfter(Version.V_6_6_0)) {
            this.sortFields = in.readOptionalArray(Lucene::readSortField, SortField[]::new);
            this.collapseField = in.readOptionalString();
            this.collapseValues = in.readOptionalArray(Lucene::readSortValue, Object[]::new);
        } else {
            this.sortFields = null;
            this.collapseField = null;
            this.collapseValues = null;
        }
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        boolean hasTotalHits = this.totalHits != null;
        out.writeBoolean(hasTotalHits);
        if (hasTotalHits) {
            Lucene.writeTotalHits(out, this.totalHits);
        }
        out.writeFloat(this.maxScore);
        out.writeVInt(this.hits.length);
        if (this.hits.length > 0) {
            for (SearchHit hit : this.hits) {
                hit.writeTo(out);
            }
        }
        if (out.getVersion().onOrAfter(Version.V_6_6_0)) {
            out.writeOptionalArray(Lucene::writeSortField, this.sortFields);
            out.writeOptionalString(this.collapseField);
            out.writeOptionalArray(Lucene::writeSortValue, this.collapseValues);
        }
    }

    @Nullable
    public TotalHits getTotalHits() {
        return this.totalHits;
    }

    public float getMaxScore() {
        return this.maxScore;
    }

    public SearchHit[] getHits() {
        return this.hits;
    }

    public SearchHit getAt(int position) {
        return this.hits[position];
    }

    @Nullable
    public SortField[] getSortFields() {
        return this.sortFields;
    }

    @Nullable
    public String getCollapseField() {
        return this.collapseField;
    }

    @Nullable
    public Object[] getCollapseValues() {
        return this.collapseValues;
    }

    @Override
    public Iterator<SearchHit> iterator() {
        return Arrays.stream(this.getHits()).iterator();
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject("hits");
        boolean totalHitAsInt = params.paramAsBoolean("rest_total_hits_as_int", false);
        if (totalHitAsInt) {
            long total = this.totalHits == null ? -1L : this.totalHits.value;
            builder.field("total", total);
        } else if (this.totalHits != null) {
            builder.startObject("total");
            builder.field("value", this.totalHits.value);
            builder.field("relation", this.totalHits.relation == TotalHits.Relation.EQUAL_TO ? "eq" : "gte");
            builder.endObject();
        }
        if (Float.isNaN(this.maxScore)) {
            builder.nullField("max_score");
        } else {
            builder.field("max_score", this.maxScore);
        }
        builder.field("hits");
        builder.startArray();
        for (SearchHit hit : this.hits) {
            hit.toXContent(builder, params);
        }
        builder.endArray();
        builder.endObject();
        return builder;
    }

    public static SearchHits fromXContent(XContentParser parser) throws IOException {
        if (parser.currentToken() != XContentParser.Token.START_OBJECT) {
            parser.nextToken();
            XContentParserUtils.ensureExpectedToken(XContentParser.Token.START_OBJECT, parser.currentToken(), parser);
        }
        XContentParser.Token token = parser.currentToken();
        String currentFieldName = null;
        ArrayList<SearchHit> hits = new ArrayList<SearchHit>();
        TotalHits totalHits = null;
        float maxScore = 0.0f;
        while ((token = parser.nextToken()) != XContentParser.Token.END_OBJECT) {
            if (token == XContentParser.Token.FIELD_NAME) {
                currentFieldName = parser.currentName();
                continue;
            }
            if (token.isValue()) {
                if ("total".equals(currentFieldName)) {
                    long value = parser.longValue();
                    totalHits = value == -1L ? null : new TotalHits(value, TotalHits.Relation.EQUAL_TO);
                    continue;
                }
                if (!"max_score".equals(currentFieldName)) continue;
                maxScore = parser.floatValue();
                continue;
            }
            if (token == XContentParser.Token.VALUE_NULL) {
                if (!"max_score".equals(currentFieldName)) continue;
                maxScore = Float.NaN;
                continue;
            }
            if (token == XContentParser.Token.START_ARRAY) {
                if ("hits".equals(currentFieldName)) {
                    while ((token = parser.nextToken()) != XContentParser.Token.END_ARRAY) {
                        hits.add(SearchHit.fromXContent(parser));
                    }
                    continue;
                }
                parser.skipChildren();
                continue;
            }
            if (token != XContentParser.Token.START_OBJECT) continue;
            if ("total".equals(currentFieldName)) {
                totalHits = SearchHits.parseTotalHitsFragment(parser);
                continue;
            }
            parser.skipChildren();
        }
        return new SearchHits(hits.toArray(new SearchHit[0]), totalHits, maxScore);
    }

    public boolean equals(Object obj) {
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        SearchHits other = (SearchHits)obj;
        return Objects.equals(this.totalHits, other.totalHits) && Objects.equals(Float.valueOf(this.maxScore), Float.valueOf(other.maxScore)) && Arrays.equals(this.hits, other.hits) && Arrays.equals(this.sortFields, other.sortFields) && Objects.equals(this.collapseField, other.collapseField) && Arrays.equals(this.collapseValues, other.collapseValues);
    }

    public int hashCode() {
        return Objects.hash(this.totalHits, Float.valueOf(this.maxScore), Arrays.hashCode(this.hits), Arrays.hashCode(this.sortFields), this.collapseField, Arrays.hashCode(this.collapseValues));
    }

    public static TotalHits parseTotalHitsFragment(XContentParser parser) throws IOException {
        XContentParser.Token token;
        long value = -1L;
        TotalHits.Relation relation = null;
        String currentFieldName = null;
        while ((token = parser.nextToken()) != XContentParser.Token.END_OBJECT) {
            if (token == XContentParser.Token.FIELD_NAME) {
                currentFieldName = parser.currentName();
                continue;
            }
            if (token.isValue()) {
                if ("value".equals(currentFieldName)) {
                    value = parser.longValue();
                    continue;
                }
                if (!"relation".equals(currentFieldName)) continue;
                relation = SearchHits.parseRelation(parser.text());
                continue;
            }
            parser.skipChildren();
        }
        return new TotalHits(value, relation);
    }

    private static TotalHits.Relation parseRelation(String relation) {
        if ("gte".equals(relation)) {
            return TotalHits.Relation.GREATER_THAN_OR_EQUAL_TO;
        }
        if ("eq".equals(relation)) {
            return TotalHits.Relation.EQUAL_TO;
        }
        throw new IllegalArgumentException("invalid total hits relation: " + relation);
    }

    public static final class Fields {
        public static final String HITS = "hits";
        public static final String TOTAL = "total";
        public static final String MAX_SCORE = "max_score";
    }
}

