/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.cluster.metadata;

import com.carrotsearch.hppc.cursors.ObjectCursor;
import com.carrotsearch.hppc.cursors.ObjectObjectCursor;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.TreeSet;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.lucene.util.CollectionUtil;
import org.apache.lucene.util.automaton.Automaton;
import org.apache.lucene.util.automaton.Operations;
import org.elasticsearch.Version;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.admin.indices.alias.Alias;
import org.elasticsearch.action.support.master.AcknowledgedResponse;
import org.elasticsearch.action.support.master.MasterNodeRequest;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.ClusterStateUpdateTask;
import org.elasticsearch.cluster.metadata.AliasMetadata;
import org.elasticsearch.cluster.metadata.AliasValidator;
import org.elasticsearch.cluster.metadata.ComponentTemplate;
import org.elasticsearch.cluster.metadata.ComposableIndexTemplate;
import org.elasticsearch.cluster.metadata.IndexMetadata;
import org.elasticsearch.cluster.metadata.IndexTemplateMetadata;
import org.elasticsearch.cluster.metadata.Metadata;
import org.elasticsearch.cluster.metadata.MetadataCreateDataStreamService;
import org.elasticsearch.cluster.metadata.MetadataCreateIndexService;
import org.elasticsearch.cluster.metadata.Template;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.Nullable;
import org.elasticsearch.common.Priority;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.UUIDs;
import org.elasticsearch.common.ValidationException;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.common.compress.CompressedXContent;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.logging.HeaderWarning;
import org.elasticsearch.common.regex.Regex;
import org.elasticsearch.common.settings.IndexScopedSettings;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.unit.TimeValue;
import org.elasticsearch.common.util.set.Sets;
import org.elasticsearch.common.xcontent.NamedXContentRegistry;
import org.elasticsearch.common.xcontent.XContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentFactory;
import org.elasticsearch.common.xcontent.XContentParseException;
import org.elasticsearch.common.xcontent.XContentType;
import org.elasticsearch.index.AbstractIndexComponent;
import org.elasticsearch.index.Index;
import org.elasticsearch.index.IndexService;
import org.elasticsearch.index.mapper.MapperParsingException;
import org.elasticsearch.index.mapper.MapperService;
import org.elasticsearch.indices.IndexTemplateMissingException;
import org.elasticsearch.indices.IndicesService;
import org.elasticsearch.indices.InvalidIndexTemplateException;
import org.elasticsearch.indices.cluster.IndicesClusterStateService;

public class MetadataIndexTemplateService {
    public static final String DEFAULT_TIMESTAMP_FIELD = "@timestamp";
    public static final String DEFAULT_TIMESTAMP_MAPPING = "{\n   \"_doc\": {\n     \"properties\": {\n       \"@timestamp\": {\n         \"type\": \"date\"\n       }\n     }\n   }\n }";
    private static final Logger logger = LogManager.getLogger(MetadataIndexTemplateService.class);
    private final ClusterService clusterService;
    private final AliasValidator aliasValidator;
    private final IndicesService indicesService;
    private final MetadataCreateIndexService metadataCreateIndexService;
    private final IndexScopedSettings indexScopedSettings;
    private final NamedXContentRegistry xContentRegistry;

    @Inject
    public MetadataIndexTemplateService(ClusterService clusterService, MetadataCreateIndexService metadataCreateIndexService, AliasValidator aliasValidator, IndicesService indicesService, IndexScopedSettings indexScopedSettings, NamedXContentRegistry xContentRegistry) {
        this.clusterService = clusterService;
        this.aliasValidator = aliasValidator;
        this.indicesService = indicesService;
        this.metadataCreateIndexService = metadataCreateIndexService;
        this.indexScopedSettings = indexScopedSettings;
        this.xContentRegistry = xContentRegistry;
    }

    public void removeTemplates(final RemoveRequest request, final RemoveListener listener) {
        this.clusterService.submitStateUpdateTask("remove-index-template [" + request.name + "]", new ClusterStateUpdateTask(Priority.URGENT){

            @Override
            public TimeValue timeout() {
                return request.masterTimeout;
            }

            @Override
            public void onFailure(String source, Exception e) {
                listener.onFailure(e);
            }

            @Override
            public ClusterState execute(ClusterState currentState) {
                HashSet<String> templateNames = new HashSet<String>();
                for (ObjectCursor cursor : currentState.metadata().templates().keys()) {
                    String templateName = (String)cursor.value;
                    if (!Regex.simpleMatch(request.name, templateName)) continue;
                    templateNames.add(templateName);
                }
                if (templateNames.isEmpty()) {
                    if (Regex.isMatchAllPattern(request.name)) {
                        return currentState;
                    }
                    throw new IndexTemplateMissingException(request.name);
                }
                Metadata.Builder metadata = Metadata.builder(currentState.metadata());
                for (String templateName : templateNames) {
                    logger.info("removing template [{}]", (Object)templateName);
                    metadata.removeTemplate(templateName);
                }
                return ClusterState.builder(currentState).metadata(metadata).build();
            }

            @Override
            public void clusterStateProcessed(String source, ClusterState oldState, ClusterState newState) {
                listener.onResponse(new RemoveResponse(true));
            }
        });
    }

    public void putComponentTemplate(String cause, final boolean create, final String name, final TimeValue masterTimeout, final ComponentTemplate template, final ActionListener<AcknowledgedResponse> listener) {
        this.clusterService.submitStateUpdateTask("create-component-template [" + name + "], cause [" + cause + "]", new ClusterStateUpdateTask(Priority.URGENT){

            @Override
            public TimeValue timeout() {
                return masterTimeout;
            }

            @Override
            public void onFailure(String source, Exception e) {
                listener.onFailure(e);
            }

            @Override
            public ClusterState execute(ClusterState currentState) throws Exception {
                return MetadataIndexTemplateService.this.addComponentTemplate(currentState, create, name, template);
            }

            @Override
            public void clusterStateProcessed(String source, ClusterState oldState, ClusterState newState) {
                listener.onResponse(new AcknowledgedResponse(true));
            }
        });
    }

    ClusterState addComponentTemplate(ClusterState currentState, boolean create, String name, ComponentTemplate template) throws Exception {
        Template finalTemplate;
        ComponentTemplate finalComponentTemplate;
        Map<String, Object> parsedMappings;
        ComponentTemplate existing = currentState.metadata().componentTemplates().get(name);
        if (create && existing != null) {
            throw new IllegalArgumentException("component template [" + name + "] already exists");
        }
        CompressedXContent mappings = template.template().mappings();
        String stringMappings = mappings == null ? null : mappings.string();
        Settings finalSettings = template.template().settings();
        if (finalSettings != null) {
            finalSettings = Settings.builder().put(finalSettings).normalizePrefix("index.").build();
        }
        Map<String, ComposableIndexTemplate> templatesUsingComponent = currentState.metadata().templatesV2().entrySet().stream().filter(e -> ((ComposableIndexTemplate)e.getValue()).composedOf().contains(name)).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
        if (!create && finalSettings != null && IndexMetadata.INDEX_HIDDEN_SETTING.exists(finalSettings)) {
            ArrayList<String> globalTemplatesThatUseThisComponent = new ArrayList<String>();
            for (Map.Entry<String, ComposableIndexTemplate> entry : templatesUsingComponent.entrySet()) {
                ComposableIndexTemplate templateV2 = entry.getValue();
                if (!templateV2.indexPatterns().stream().anyMatch(Regex::isMatchAllPattern)) continue;
                globalTemplatesThatUseThisComponent.add(entry.getKey());
            }
            if (!globalTemplatesThatUseThisComponent.isEmpty()) {
                throw new IllegalArgumentException("cannot update component template [" + name + "] because the following global templates would resolve to specifying the [" + "index.hidden" + "] setting: [" + String.join((CharSequence)",", globalTemplatesThatUseThisComponent) + "]");
            }
        }
        if (stringMappings != null && (parsedMappings = MapperService.parseMapping(this.xContentRegistry, stringMappings)).size() > 0) {
            stringMappings = Strings.toString(XContentFactory.jsonBuilder().startObject().field("_doc", parsedMappings).endObject());
        }
        if ((finalComponentTemplate = new ComponentTemplate(finalTemplate = new Template(finalSettings, stringMappings == null ? null : new CompressedXContent(stringMappings), template.template().aliases()), template.version(), template.metadata())).equals(existing)) {
            return currentState;
        }
        MetadataIndexTemplateService.validateTemplate(finalSettings, stringMappings, this.indicesService, this.xContentRegistry);
        this.validate(name, finalComponentTemplate);
        if (templatesUsingComponent.size() > 0) {
            ClusterState tempStateWithComponentTemplateAdded = ClusterState.builder(currentState).metadata(Metadata.builder(currentState.metadata()).put(name, finalComponentTemplate)).build();
            Throwable validationFailure = null;
            for (Map.Entry<String, ComposableIndexTemplate> entry : templatesUsingComponent.entrySet()) {
                String composableTemplateName = entry.getKey();
                ComposableIndexTemplate composableTemplate = entry.getValue();
                try {
                    MetadataIndexTemplateService.validateCompositeTemplate(tempStateWithComponentTemplateAdded, composableTemplateName, composableTemplate, this.indicesService, this.xContentRegistry);
                }
                catch (Exception e2) {
                    if (validationFailure == null) {
                        validationFailure = new IllegalArgumentException("updating component template [" + name + "] results in invalid composable template [" + composableTemplateName + "] after templates are merged", e2);
                        continue;
                    }
                    validationFailure.addSuppressed(e2);
                }
            }
            if (validationFailure != null) {
                throw validationFailure;
            }
        }
        logger.info("{} component template [{}]", (Object)(existing == null ? "adding" : "updating"), (Object)name);
        return ClusterState.builder(currentState).metadata(Metadata.builder(currentState.metadata()).put(name, finalComponentTemplate)).build();
    }

    public void removeComponentTemplate(final String name, final TimeValue masterTimeout, final ActionListener<AcknowledgedResponse> listener) {
        MetadataIndexTemplateService.validateNotInUse(this.clusterService.state().metadata(), name);
        this.clusterService.submitStateUpdateTask("remove-component-template [" + name + "]", new ClusterStateUpdateTask(Priority.URGENT){

            @Override
            public TimeValue timeout() {
                return masterTimeout;
            }

            @Override
            public void onFailure(String source, Exception e) {
                listener.onFailure(e);
            }

            @Override
            public ClusterState execute(ClusterState currentState) {
                HashSet<String> templateNames = new HashSet<String>();
                for (String templateName : currentState.metadata().componentTemplates().keySet()) {
                    if (!Regex.simpleMatch(name, templateName)) continue;
                    templateNames.add(templateName);
                }
                if (templateNames.isEmpty()) {
                    if (Regex.isMatchAllPattern(name)) {
                        return currentState;
                    }
                    throw new IndexTemplateMissingException(name);
                }
                Metadata.Builder metadata = Metadata.builder(currentState.metadata());
                for (String templateName : templateNames) {
                    logger.info("removing component template [{}]", (Object)templateName);
                    metadata.removeComponentTemplate(templateName);
                }
                return ClusterState.builder(currentState).metadata(metadata).build();
            }

            @Override
            public void clusterStateProcessed(String source, ClusterState oldState, ClusterState newState) {
                listener.onResponse(new AcknowledgedResponse(true));
            }
        });
    }

    static void validateNotInUse(Metadata metadata, String templateNameOrWildcard) {
        Set matchingComponentTemplates = metadata.componentTemplates().keySet().stream().filter(name -> Regex.simpleMatch(templateNameOrWildcard, name)).collect(Collectors.toSet());
        HashSet componentsBeingUsed = new HashSet();
        List templatesStillUsing = metadata.templatesV2().entrySet().stream().filter(e -> {
            Set<String> intersecting = Sets.intersection(new HashSet<String>(((ComposableIndexTemplate)e.getValue()).composedOf()), matchingComponentTemplates);
            if (intersecting.size() > 0) {
                componentsBeingUsed.addAll(intersecting);
                return true;
            }
            return false;
        }).map(Map.Entry::getKey).collect(Collectors.toList());
        if (templatesStillUsing.size() > 0) {
            throw new IllegalArgumentException("component templates " + componentsBeingUsed + " cannot be removed as they are still in use by index templates " + templatesStillUsing);
        }
    }

    public void putIndexTemplateV2(String cause, final boolean create, final String name, final TimeValue masterTimeout, final ComposableIndexTemplate template, final ActionListener<AcknowledgedResponse> listener) {
        MetadataIndexTemplateService.validateV2TemplateRequest(this.clusterService.state().metadata(), name, template);
        this.clusterService.submitStateUpdateTask("create-index-template-v2 [" + name + "], cause [" + cause + "]", new ClusterStateUpdateTask(Priority.URGENT){

            @Override
            public TimeValue timeout() {
                return masterTimeout;
            }

            @Override
            public void onFailure(String source, Exception e) {
                listener.onFailure(e);
            }

            @Override
            public ClusterState execute(ClusterState currentState) throws Exception {
                return MetadataIndexTemplateService.this.addIndexTemplateV2(currentState, create, name, template);
            }

            @Override
            public void clusterStateProcessed(String source, ClusterState oldState, ClusterState newState) {
                listener.onResponse(new AcknowledgedResponse(true));
            }
        });
    }

    public static void validateV2TemplateRequest(Metadata metadata, String name, ComposableIndexTemplate template) {
        Settings mergedSettings;
        if (template.indexPatterns().stream().anyMatch(Regex::isMatchAllPattern) && IndexMetadata.INDEX_HIDDEN_SETTING.exists(mergedSettings = MetadataIndexTemplateService.resolveSettings(metadata, template))) {
            throw new InvalidIndexTemplateException(name, "global composable templates may not specify the setting " + IndexMetadata.INDEX_HIDDEN_SETTING.getKey());
        }
        Map<String, ComponentTemplate> componentTemplates = metadata.componentTemplates();
        List missingComponentTemplates = template.composedOf().stream().filter(componentTemplate -> !componentTemplates.containsKey(componentTemplate)).collect(Collectors.toList());
        if (missingComponentTemplates.size() > 0) {
            throw new InvalidIndexTemplateException(name, "index template [" + name + "] specifies component templates " + missingComponentTemplates + " that do not exist");
        }
    }

    public ClusterState addIndexTemplateV2(ClusterState currentState, boolean create, String name, ComposableIndexTemplate template) throws Exception {
        ComposableIndexTemplate existing = currentState.metadata().templatesV2().get(name);
        if (create && existing != null) {
            throw new IllegalArgumentException("index template [" + name + "] already exists");
        }
        Map<String, List<String>> overlaps = MetadataIndexTemplateService.findConflictingV2Templates(currentState, name, template.indexPatterns(), true, template.priorityOrZero());
        overlaps.remove(name);
        if (overlaps.size() > 0) {
            String error = String.format(Locale.ROOT, "index template [%s] has index patterns %s matching patterns from existing templates [%s] with patterns (%s) that have the same priority [%d], multiple index templates may not match during index creation, please use a different priority", name, template.indexPatterns(), Strings.collectionToCommaDelimitedString(overlaps.keySet()), overlaps.entrySet().stream().map(e -> (String)e.getKey() + " => " + e.getValue()).collect(Collectors.joining(",")), template.priorityOrZero());
            throw new IllegalArgumentException(error);
        }
        overlaps = MetadataIndexTemplateService.findConflictingV1Templates(currentState, name, template.indexPatterns());
        if (overlaps.size() > 0) {
            String warning = String.format(Locale.ROOT, "index template [%s] has index patterns %s matching patterns from existing older templates [%s] with patterns (%s); this template [%s] will take precedence during new index creation", name, template.indexPatterns(), Strings.collectionToCommaDelimitedString(overlaps.keySet()), overlaps.entrySet().stream().map(e -> (String)e.getKey() + " => " + e.getValue()).collect(Collectors.joining(",")), name);
            logger.warn(warning);
            HeaderWarning.addWarning(warning, new Object[0]);
        }
        ComposableIndexTemplate finalIndexTemplate = template;
        Template innerTemplate = template.template();
        if (innerTemplate != null) {
            Map<String, Object> parsedMappings;
            CompressedXContent mappings;
            String stringMappings;
            Settings finalSettings = innerTemplate.settings();
            if (finalSettings != null) {
                finalSettings = Settings.builder().put(finalSettings).normalizePrefix("index.").build();
            }
            String string = stringMappings = (mappings = innerTemplate.mappings()) == null ? null : mappings.string();
            if (stringMappings != null && (parsedMappings = MapperService.parseMapping(this.xContentRegistry, stringMappings)).size() > 0) {
                stringMappings = Strings.toString(XContentFactory.jsonBuilder().startObject().field("_doc", parsedMappings).endObject());
            }
            Template finalTemplate = new Template(finalSettings, stringMappings == null ? null : new CompressedXContent(stringMappings), innerTemplate.aliases());
            finalIndexTemplate = new ComposableIndexTemplate(template.indexPatterns(), finalTemplate, template.composedOf(), template.priority(), template.version(), template.metadata(), template.getDataStreamTemplate());
        }
        if (finalIndexTemplate.equals(existing)) {
            return currentState;
        }
        this.validate(name, finalIndexTemplate);
        MetadataIndexTemplateService.validateDataStreamsStillReferenced(currentState, name, finalIndexTemplate);
        try {
            MetadataIndexTemplateService.validateCompositeTemplate(currentState, name, finalIndexTemplate, this.indicesService, this.xContentRegistry);
        }
        catch (Exception e2) {
            throw new IllegalArgumentException("composable template [" + name + "] template after composition " + (finalIndexTemplate.composedOf().size() > 0 ? "with component templates " + finalIndexTemplate.composedOf() + " " : "") + "is invalid", e2);
        }
        logger.info("{} index template [{}] for index patterns {}", (Object)(existing == null ? "adding" : "updating"), (Object)name, template.indexPatterns());
        return ClusterState.builder(currentState).metadata(Metadata.builder(currentState.metadata()).put(name, finalIndexTemplate)).build();
    }

    private static void validateDataStreamsStillReferenced(ClusterState state, String templateName, ComposableIndexTemplate newTemplate) {
        Set<String> dataStreams = state.metadata().dataStreams().keySet();
        Function<Metadata, Set> findUnreferencedDataStreams = meta -> {
            HashSet<String> unreferenced = new HashSet<String>();
            for (String dataStream : dataStreams) {
                String matchingTemplate = MetadataIndexTemplateService.findV2Template(meta, dataStream, false);
                if (matchingTemplate == null) {
                    unreferenced.add(dataStream);
                    continue;
                }
                if (meta.templatesV2().get(matchingTemplate).getDataStreamTemplate() != null) continue;
                unreferenced.add(dataStream);
            }
            return unreferenced;
        };
        Set currentlyUnreferenced = findUnreferencedDataStreams.apply(state.metadata());
        Metadata updatedMetadata = Metadata.builder(state.metadata()).put(templateName, newTemplate).build();
        Set newlyUnreferenced = findUnreferencedDataStreams.apply(updatedMetadata);
        if (newlyUnreferenced.size() > currentlyUnreferenced.size()) {
            throw new IllegalArgumentException("composable template [" + templateName + "] with index patterns " + newTemplate.indexPatterns() + ", priority [" + newTemplate.priority() + "] " + (newTemplate.getDataStreamTemplate() == null ? "and no data stream configuration " : "") + "would cause data streams " + newlyUnreferenced + " to no longer match a data stream template");
        }
    }

    public static Map<String, List<String>> findConflictingV1Templates(ClusterState state, String candidateName, List<String> indexPatterns) {
        Automaton v2automaton = Regex.simpleMatchToAutomaton(indexPatterns.toArray(Strings.EMPTY_ARRAY));
        HashMap<String, List<String>> overlappingTemplates = new HashMap<String, List<String>>();
        for (ObjectObjectCursor<String, IndexTemplateMetadata> objectObjectCursor : state.metadata().templates()) {
            String name = (String)objectObjectCursor.key;
            IndexTemplateMetadata template = (IndexTemplateMetadata)objectObjectCursor.value;
            Automaton v1automaton = Regex.simpleMatchToAutomaton(template.patterns().toArray(Strings.EMPTY_ARRAY));
            if (Operations.isEmpty((Automaton)Operations.intersection((Automaton)v2automaton, (Automaton)v1automaton))) continue;
            logger.debug("composable template {} and legacy template {} would overlap: {} <=> {}", (Object)candidateName, (Object)name, indexPatterns, template.patterns());
            overlappingTemplates.put(name, template.patterns());
        }
        return overlappingTemplates;
    }

    public static Map<String, List<String>> findConflictingV2Templates(ClusterState state, String candidateName, List<String> indexPatterns) {
        return MetadataIndexTemplateService.findConflictingV2Templates(state, candidateName, indexPatterns, false, 0L);
    }

    static Map<String, List<String>> findConflictingV2Templates(ClusterState state, String candidateName, List<String> indexPatterns, boolean checkPriority, long priority) {
        Automaton v1automaton = Regex.simpleMatchToAutomaton(indexPatterns.toArray(Strings.EMPTY_ARRAY));
        HashMap<String, List<String>> overlappingTemplates = new HashMap<String, List<String>>();
        for (Map.Entry<String, ComposableIndexTemplate> entry : state.metadata().templatesV2().entrySet()) {
            String name = entry.getKey();
            ComposableIndexTemplate template = entry.getValue();
            Automaton v2automaton = Regex.simpleMatchToAutomaton(template.indexPatterns().toArray(Strings.EMPTY_ARRAY));
            if (Operations.isEmpty((Automaton)Operations.intersection((Automaton)v1automaton, (Automaton)v2automaton)) || checkPriority && priority != template.priorityOrZero()) continue;
            logger.debug("legacy template {} and composable template {} would overlap: {} <=> {}", (Object)candidateName, (Object)name, indexPatterns, template.indexPatterns());
            overlappingTemplates.put(name, template.indexPatterns());
        }
        overlappingTemplates.remove(candidateName);
        return overlappingTemplates;
    }

    public void removeIndexTemplateV2(final String name, final TimeValue masterTimeout, final ActionListener<AcknowledgedResponse> listener) {
        this.clusterService.submitStateUpdateTask("remove-index-template-v2 [" + name + "]", new ClusterStateUpdateTask(Priority.URGENT){

            @Override
            public TimeValue timeout() {
                return masterTimeout;
            }

            @Override
            public void onFailure(String source, Exception e) {
                listener.onFailure(e);
            }

            @Override
            public ClusterState execute(ClusterState currentState) {
                return MetadataIndexTemplateService.innerRemoveIndexTemplateV2(currentState, name);
            }

            @Override
            public void clusterStateProcessed(String source, ClusterState oldState, ClusterState newState) {
                listener.onResponse(new AcknowledgedResponse(true));
            }
        });
    }

    static ClusterState innerRemoveIndexTemplateV2(ClusterState currentState, String name) {
        HashSet<String> templateNames = new HashSet<String>();
        for (String templateName2 : currentState.metadata().templatesV2().keySet()) {
            if (!Regex.simpleMatch(name, templateName2)) continue;
            templateNames.add(templateName2);
        }
        if (templateNames.isEmpty()) {
            if (Regex.isMatchAllPattern(name)) {
                return currentState;
            }
            throw new IndexTemplateMissingException(name);
        }
        Optional<Set> dataStreamsUsingTemplates = templateNames.stream().map(templateName -> MetadataIndexTemplateService.dataStreamsUsingTemplate(currentState, templateName)).reduce(Sets::union);
        dataStreamsUsingTemplates.ifPresent(set -> {
            if (set.size() > 0) {
                throw new IllegalArgumentException("unable to remove composable templates " + new TreeSet(templateNames) + " as they are in use by a data streams " + new TreeSet(set));
            }
        });
        Metadata.Builder metadata = Metadata.builder(currentState.metadata());
        for (String templateName3 : templateNames) {
            logger.info("removing index template [{}]", (Object)templateName3);
            metadata.removeIndexTemplate(templateName3);
        }
        return ClusterState.builder(currentState).metadata(metadata).build();
    }

    static Set<String> dataStreamsUsingTemplate(ClusterState state, String templateName) {
        ComposableIndexTemplate template = state.metadata().templatesV2().get(templateName);
        if (template == null) {
            return Collections.emptySet();
        }
        Set<String> dataStreams = state.metadata().dataStreams().keySet();
        HashSet<String> matches = new HashSet<String>();
        template.indexPatterns().forEach(indexPattern -> matches.addAll(dataStreams.stream().filter(stream -> Regex.simpleMatch(indexPattern, stream)).collect(Collectors.toList())));
        return matches;
    }

    public void putTemplate(final PutRequest request, final PutListener listener) {
        Settings.Builder updatedSettingsBuilder = Settings.builder();
        updatedSettingsBuilder.put(request.settings).normalizePrefix("index.");
        request.settings(updatedSettingsBuilder.build());
        if (request.name == null) {
            listener.onFailure(new IllegalArgumentException("index_template must provide a name"));
            return;
        }
        if (request.indexPatterns == null) {
            listener.onFailure(new IllegalArgumentException("index_template must provide a template"));
            return;
        }
        try {
            this.validate(request);
        }
        catch (Exception e) {
            listener.onFailure(e);
            return;
        }
        final IndexTemplateMetadata.Builder templateBuilder = IndexTemplateMetadata.builder(request.name);
        this.clusterService.submitStateUpdateTask("create-index-template [" + request.name + "], cause [" + request.cause + "]", new ClusterStateUpdateTask(Priority.URGENT){

            @Override
            public TimeValue timeout() {
                return request.masterTimeout;
            }

            @Override
            public void onFailure(String source, Exception e) {
                listener.onFailure(e);
            }

            @Override
            public ClusterState execute(ClusterState currentState) throws Exception {
                MetadataIndexTemplateService.validateTemplate(request.settings, request.mappings, MetadataIndexTemplateService.this.indicesService, MetadataIndexTemplateService.this.xContentRegistry);
                return MetadataIndexTemplateService.innerPutTemplate(currentState, request, templateBuilder);
            }

            @Override
            public void clusterStateProcessed(String source, ClusterState oldState, ClusterState newState) {
                listener.onResponse(new PutResponse(true));
            }
        });
    }

    static ClusterState innerPutTemplate(ClusterState currentState, PutRequest request, IndexTemplateMetadata.Builder templateBuilder) {
        boolean isUpdate = currentState.metadata().templates().containsKey(request.name);
        if (request.create && isUpdate) {
            throw new IllegalArgumentException("index_template [" + request.name + "] already exists");
        }
        Map<String, List<String>> overlaps = MetadataIndexTemplateService.findConflictingV2Templates(currentState, request.name, request.indexPatterns);
        if (overlaps.size() > 0) {
            String warning = String.format(Locale.ROOT, "legacy template [%s] has index patterns %s matching patterns from existing composable templates [%s] with patterns (%s); this template [%s] may be ignored in favor of a composable template at index creation time", request.name, request.indexPatterns, Strings.collectionToCommaDelimitedString(overlaps.keySet()), overlaps.entrySet().stream().map(e -> (String)e.getKey() + " => " + e.getValue()).collect(Collectors.joining(",")), request.name);
            logger.warn(warning);
            HeaderWarning.addWarning(warning, new Object[0]);
        }
        templateBuilder.order(request.order);
        templateBuilder.version(request.version);
        templateBuilder.patterns(request.indexPatterns);
        templateBuilder.settings(request.settings);
        for (Map.Entry<String, String> entry : request.mappings.entrySet()) {
            try {
                templateBuilder.putMapping(entry.getKey(), entry.getValue());
            }
            catch (Exception e2) {
                throw new MapperParsingException("Failed to parse mapping [{}]: {}", (Throwable)e2, entry.getKey(), e2.getMessage());
            }
        }
        for (Alias alias : request.aliases) {
            AliasMetadata aliasMetadata = AliasMetadata.builder(alias.name()).filter(alias.filter()).indexRouting(alias.indexRouting()).searchRouting(alias.searchRouting()).build();
            templateBuilder.putAlias(aliasMetadata);
        }
        IndexTemplateMetadata template = templateBuilder.build();
        Metadata.Builder builder = Metadata.builder(currentState.metadata()).put(template);
        logger.info("adding template [{}] for index patterns {}", (Object)request.name, request.indexPatterns);
        return ClusterState.builder(currentState).metadata(builder).build();
    }

    public static List<IndexTemplateMetadata> findV1Templates(Metadata metadata, String indexName, @Nullable Boolean isHidden) {
        Optional<IndexTemplateMetadata> templateWithHiddenSetting;
        Predicate<String> patternMatchPredicate = pattern -> Regex.simpleMatch(pattern, indexName);
        ArrayList<IndexTemplateMetadata> matchedTemplates = new ArrayList<IndexTemplateMetadata>();
        for (ObjectCursor cursor : metadata.templates().values()) {
            IndexTemplateMetadata template2 = (IndexTemplateMetadata)cursor.value;
            if (isHidden == null || isHidden == Boolean.FALSE) {
                boolean matched = template2.patterns().stream().anyMatch(patternMatchPredicate);
                if (!matched) continue;
                matchedTemplates.add(template2);
                continue;
            }
            assert (isHidden == Boolean.TRUE);
            boolean isNotMatchAllTemplate = template2.patterns().stream().noneMatch(Regex::isMatchAllPattern);
            if (!isNotMatchAllTemplate || !template2.patterns().stream().anyMatch(patternMatchPredicate)) continue;
            matchedTemplates.add(template2);
        }
        CollectionUtil.timSort(matchedTemplates, Comparator.comparingInt(IndexTemplateMetadata::order).reversed());
        if (isHidden == null && (templateWithHiddenSetting = matchedTemplates.stream().filter(template -> IndexMetadata.INDEX_HIDDEN_SETTING.exists(template.settings())).findFirst()).isPresent()) {
            Optional<IndexTemplateMetadata> templateWithHiddenSettingPostRemoval;
            boolean templatedIsHidden = IndexMetadata.INDEX_HIDDEN_SETTING.get(templateWithHiddenSetting.get().settings());
            if (templatedIsHidden) {
                matchedTemplates.removeIf(current -> current.patterns().stream().anyMatch(Regex::isMatchAllPattern));
            }
            if (!(templateWithHiddenSettingPostRemoval = matchedTemplates.stream().filter(template -> IndexMetadata.INDEX_HIDDEN_SETTING.exists(template.settings())).findFirst()).isPresent() || templateWithHiddenSetting.get() != templateWithHiddenSettingPostRemoval.get()) {
                throw new IllegalStateException("A global index template [" + templateWithHiddenSetting.get().name() + "] defined the index hidden setting, which is not allowed");
            }
        }
        return Collections.unmodifiableList(matchedTemplates);
    }

    @Nullable
    public static String findV2Template(Metadata metadata, String indexName, boolean isHidden) {
        Predicate<String> patternMatchPredicate = pattern -> Regex.simpleMatch(pattern, indexName);
        HashMap<ComposableIndexTemplate, String> matchedTemplates = new HashMap<ComposableIndexTemplate, String>();
        for (Map.Entry<String, ComposableIndexTemplate> entry : metadata.templatesV2().entrySet()) {
            String name = entry.getKey();
            ComposableIndexTemplate template = entry.getValue();
            if (!isHidden) {
                boolean matched = template.indexPatterns().stream().anyMatch(patternMatchPredicate);
                if (!matched) continue;
                matchedTemplates.put(template, name);
                continue;
            }
            boolean isNotMatchAllTemplate = template.indexPatterns().stream().noneMatch(Regex::isMatchAllPattern);
            if (!isNotMatchAllTemplate || !template.indexPatterns().stream().anyMatch(patternMatchPredicate)) continue;
            matchedTemplates.put(template, name);
        }
        if (matchedTemplates.size() == 0) {
            return null;
        }
        ArrayList candidates = new ArrayList(matchedTemplates.keySet());
        CollectionUtil.timSort(candidates, Comparator.comparing(ComposableIndexTemplate::priorityOrZero, Comparator.reverseOrder()));
        assert (candidates.size() > 0) : "we should have returned early with no candidates";
        ComposableIndexTemplate winner = (ComposableIndexTemplate)candidates.get(0);
        String winnerName = (String)matchedTemplates.get(winner);
        if (winner.indexPatterns().stream().anyMatch(Regex::isMatchAllPattern) && IndexMetadata.INDEX_HIDDEN_SETTING.exists(MetadataIndexTemplateService.resolveSettings(metadata, winnerName))) {
            throw new IllegalStateException("global index template [" + winnerName + "], composed of component templates [" + String.join((CharSequence)",", winner.composedOf()) + "] defined the index.hidden setting, which is not allowed");
        }
        return winnerName;
    }

    public static List<CompressedXContent> collectMappings(ClusterState state, String templateName, String indexName) throws Exception {
        ComposableIndexTemplate template = state.metadata().templatesV2().get(templateName);
        assert (template != null) : "attempted to resolve mappings for a template [" + templateName + "] that did not exist in the cluster state";
        if (template == null) {
            return Collections.emptyList();
        }
        Map<String, ComponentTemplate> componentTemplates = state.metadata().componentTemplates();
        List mappings = template.composedOf().stream().map(componentTemplates::get).filter(Objects::nonNull).map(ComponentTemplate::template).map(Template::mappings).filter(Objects::nonNull).collect(Collectors.toCollection(LinkedList::new));
        Optional.ofNullable(template.template()).map(Template::mappings).ifPresent(mappings::add);
        if (template.getDataStreamTemplate() != null && indexName.startsWith(".ds-")) {
            mappings.add(0, new CompressedXContent(DEFAULT_TIMESTAMP_MAPPING));
        }
        if (indexName.startsWith(".ds-")) {
            Optional.ofNullable(template.getDataStreamTemplate()).map(ComposableIndexTemplate.DataStreamTemplate::getDataStreamMappingSnippet).map(mapping -> {
                CompressedXContent compressedXContent;
                block8: {
                    XContentBuilder builder = XContentBuilder.builder((XContent)XContentType.JSON.xContent());
                    try {
                        builder.value(mapping);
                        compressedXContent = new CompressedXContent(BytesReference.bytes(builder));
                        if (builder == null) break block8;
                    }
                    catch (Throwable throwable) {
                        try {
                            if (builder != null) {
                                try {
                                    builder.close();
                                }
                                catch (Throwable throwable2) {
                                    throwable.addSuppressed(throwable2);
                                }
                            }
                            throw throwable;
                        }
                        catch (IOException e) {
                            throw new UncheckedIOException(e);
                        }
                    }
                    builder.close();
                }
                return compressedXContent;
            }).ifPresent(mappings::add);
        }
        return Collections.unmodifiableList(mappings);
    }

    public static Settings resolveSettings(List<IndexTemplateMetadata> templates) {
        Settings.Builder templateSettings = Settings.builder();
        for (int i = templates.size() - 1; i >= 0; --i) {
            templateSettings.put(templates.get(i).settings());
        }
        return templateSettings.build();
    }

    public static Settings resolveSettings(Metadata metadata, String templateName) {
        ComposableIndexTemplate template = metadata.templatesV2().get(templateName);
        assert (template != null) : "attempted to resolve settings for a template [" + templateName + "] that did not exist in the cluster state";
        if (template == null) {
            return Settings.EMPTY;
        }
        return MetadataIndexTemplateService.resolveSettings(metadata, template);
    }

    private static Settings resolveSettings(Metadata metadata, ComposableIndexTemplate template) {
        Map<String, ComponentTemplate> componentTemplates = metadata.componentTemplates();
        List<Settings> componentSettings = template.composedOf().stream().map(componentTemplates::get).filter(Objects::nonNull).map(ComponentTemplate::template).map(Template::settings).filter(Objects::nonNull).collect(Collectors.toList());
        Settings.Builder templateSettings = Settings.builder();
        componentSettings.forEach(templateSettings::put);
        Optional.ofNullable(template.template()).map(Template::settings).ifPresent(templateSettings::put);
        return templateSettings.build();
    }

    public static List<Map<String, AliasMetadata>> resolveAliases(List<IndexTemplateMetadata> templates) {
        ArrayList resolvedAliases = new ArrayList();
        templates.forEach(template -> {
            if (template.aliases() != null) {
                HashMap<String, AliasMetadata> aliasMeta = new HashMap<String, AliasMetadata>();
                for (ObjectObjectCursor<String, AliasMetadata> objectObjectCursor : template.aliases()) {
                    aliasMeta.put((String)objectObjectCursor.key, (AliasMetadata)objectObjectCursor.value);
                }
                resolvedAliases.add(aliasMeta);
            }
        });
        return Collections.unmodifiableList(resolvedAliases);
    }

    public static List<Map<String, AliasMetadata>> resolveAliases(Metadata metadata, String templateName) {
        ComposableIndexTemplate template = metadata.templatesV2().get(templateName);
        assert (template != null) : "attempted to resolve aliases for a template [" + templateName + "] that did not exist in the cluster state";
        if (template == null) {
            return Collections.emptyList();
        }
        Map<String, ComponentTemplate> componentTemplates = metadata.componentTemplates();
        List aliases = template.composedOf().stream().map(componentTemplates::get).filter(Objects::nonNull).map(ComponentTemplate::template).map(Template::aliases).filter(Objects::nonNull).collect(Collectors.toList());
        Optional.ofNullable(template.template()).map(Template::aliases).ifPresent(aliases::add);
        Collections.reverse(aliases);
        return Collections.unmodifiableList(aliases);
    }

    private static void validateCompositeTemplate(ClusterState state, String templateName, ComposableIndexTemplate template, IndicesService indicesService, NamedXContentRegistry xContentRegistry) throws Exception {
        Settings resolvedSettings;
        ClusterState stateWithTemplate = ClusterState.builder(state).metadata(Metadata.builder(state.metadata()).put(templateName, template)).build();
        String temporaryIndexName = "validate-template-" + UUIDs.randomBase64UUID().toLowerCase(Locale.ROOT);
        int dummyPartitionSize = IndexMetadata.INDEX_ROUTING_PARTITION_SIZE_SETTING.get(resolvedSettings = MetadataIndexTemplateService.resolveSettings(stateWithTemplate.metadata(), templateName));
        int dummyShards = resolvedSettings.getAsInt("index.number_of_shards", dummyPartitionSize == 1 ? 1 : dummyPartitionSize + 1);
        int shardReplicas = resolvedSettings.getAsInt("index.number_of_replicas", 0);
        Settings finalResolvedSettings = Settings.builder().put("index.version.created", Version.CURRENT).put(resolvedSettings).put("index.number_of_shards", dummyShards).put("index.number_of_replicas", shardReplicas).put("index.uuid", UUIDs.randomBase64UUID()).build();
        ClusterState stateWithIndex = ClusterState.builder(stateWithTemplate).metadata(Metadata.builder(stateWithTemplate.metadata()).put(IndexMetadata.builder(temporaryIndexName).settings(finalResolvedSettings)).build()).build();
        IndexMetadata tmpIndexMetadata = stateWithIndex.metadata().index(temporaryIndexName);
        indicesService.withTempIndexService(tmpIndexMetadata, tempIndexService -> {
            MetadataCreateIndexService.resolveAndValidateAliases(temporaryIndexName, Collections.emptySet(), MetadataIndexTemplateService.resolveAliases(stateWithIndex.metadata(), templateName), stateWithIndex.metadata(), new AliasValidator(), xContentRegistry, tempIndexService.newQueryShardContext(0, null, () -> 0L, null));
            String indexName = ".ds-" + temporaryIndexName;
            if (template.getDataStreamTemplate() != null && !tempIndexService.mapperService().isMetadataField("_data_stream_timestamp")) {
                throw new XContentParseException("[index_template] unknown field [data_stream]");
            }
            List<CompressedXContent> mappings = MetadataIndexTemplateService.collectMappings(stateWithIndex, templateName, indexName);
            try {
                MapperService mapperService = tempIndexService.mapperService();
                for (CompressedXContent mapping : mappings) {
                    mapperService.merge("_doc", mapping, MapperService.MergeReason.INDEX_TEMPLATE);
                }
                if (template.getDataStreamTemplate() != null) {
                    String tsFieldName = template.getDataStreamTemplate().getTimestampField();
                    MetadataCreateDataStreamService.validateTimestampFieldMapping(tsFieldName, mapperService);
                }
            }
            catch (Exception e) {
                throw new IllegalArgumentException("invalid composite mappings for [" + templateName + "]", e);
            }
            return null;
        });
    }

    private static void validateTemplate(Settings validateSettings, String mappings, IndicesService indicesService, NamedXContentRegistry xContentRegistry) throws Exception {
        MetadataIndexTemplateService.validateTemplate(validateSettings, Collections.singletonMap("_doc", mappings), indicesService, xContentRegistry);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void validateTemplate(Settings validateSettings, Map<String, String> mappings, IndicesService indicesService, NamedXContentRegistry xContentRegistry) throws Exception {
        Settings settings;
        HashMap<String, Map<String, Object>> mappingsForValidation = new HashMap<String, Map<String, Object>>();
        if (mappings != null) {
            for (Map.Entry<String, String> entry : mappings.entrySet()) {
                if (entry.getValue() == null) continue;
                try {
                    new CompressedXContent(entry.getValue());
                    mappingsForValidation.put(entry.getKey(), MapperService.parseMapping(xContentRegistry, entry.getValue()));
                }
                catch (Exception e) {
                    throw new MapperParsingException("Failed to parse mapping [{}]: {}", (Throwable)e, entry.getKey(), e.getMessage());
                }
            }
        }
        if ((settings = validateSettings) == null) {
            settings = Settings.EMPTY;
        }
        Index createdIndex = null;
        String temporaryIndexName = UUIDs.randomBase64UUID();
        try {
            int dummyPartitionSize = IndexMetadata.INDEX_ROUTING_PARTITION_SIZE_SETTING.get(settings);
            int dummyShards = settings.getAsInt("index.number_of_shards", dummyPartitionSize == 1 ? 1 : dummyPartitionSize + 1);
            int shardReplicas = settings.getAsInt("index.number_of_replicas", 0);
            Settings dummySettings = Settings.builder().put("index.version.created", Version.CURRENT).put(settings).put("index.number_of_shards", dummyShards).put("index.number_of_replicas", shardReplicas).put("index.uuid", UUIDs.randomBase64UUID()).build();
            IndexMetadata tmpIndexMetadata = IndexMetadata.builder(temporaryIndexName).settings(dummySettings).build();
            IndicesClusterStateService.AllocatedIndex dummyIndexService = indicesService.createIndex(tmpIndexMetadata, Collections.emptyList(), false);
            createdIndex = ((AbstractIndexComponent)((Object)dummyIndexService)).index();
            ((IndexService)dummyIndexService).mapperService().merge(mappingsForValidation, MapperService.MergeReason.MAPPING_UPDATE);
            if (createdIndex != null) {
                indicesService.removeIndex(createdIndex, IndicesClusterStateService.AllocatedIndices.IndexRemovalReason.NO_LONGER_ASSIGNED, " created for parsing template mapping");
            }
        }
        catch (Throwable throwable) {
            if (createdIndex != null) {
                indicesService.removeIndex(createdIndex, IndicesClusterStateService.AllocatedIndices.IndexRemovalReason.NO_LONGER_ASSIGNED, " created for parsing template mapping");
            }
            throw throwable;
        }
    }

    private void validate(String name, ComponentTemplate template) {
        this.validate(name, template.template(), Collections.emptyList());
    }

    private void validate(String name, ComposableIndexTemplate template) {
        this.validate(name, template.template(), template.indexPatterns());
    }

    private void validate(String name, Template template, List<String> indexPatterns) {
        Optional<Template> maybeTemplate = Optional.ofNullable(template);
        this.validate(name, maybeTemplate.map(Template::settings).orElse(Settings.EMPTY), indexPatterns, maybeTemplate.map(Template::aliases).orElse(Collections.emptyMap()).values().stream().map(MetadataIndexTemplateService::toAlias).collect(Collectors.toList()));
    }

    private static Alias toAlias(AliasMetadata aliasMeta) {
        Alias a = new Alias(aliasMeta.alias());
        if (aliasMeta.filter() != null) {
            a.filter(aliasMeta.filter().string());
        }
        a.searchRouting(aliasMeta.searchRouting());
        a.indexRouting(aliasMeta.indexRouting());
        a.isHidden(aliasMeta.isHidden());
        a.writeIndex(aliasMeta.writeIndex());
        return a;
    }

    private void validate(PutRequest putRequest) {
        this.validate(putRequest.name, putRequest.settings, putRequest.indexPatterns, putRequest.aliases);
    }

    private void validate(String name, @Nullable Settings settings, List<String> indexPatterns, List<Alias> aliases) {
        ArrayList<String> validationErrors = new ArrayList<String>();
        if (name.contains(" ")) {
            validationErrors.add("name must not contain a space");
        }
        if (name.contains(",")) {
            validationErrors.add("name must not contain a ','");
        }
        if (name.contains("#")) {
            validationErrors.add("name must not contain a '#'");
        }
        if (name.contains("*")) {
            validationErrors.add("name must not contain a '*'");
        }
        if (name.startsWith("_")) {
            validationErrors.add("name must not start with '_'");
        }
        if (!name.toLowerCase(Locale.ROOT).equals(name)) {
            validationErrors.add("name must be lower cased");
        }
        for (String string : indexPatterns) {
            if (string.contains(" ")) {
                validationErrors.add("index_patterns [" + string + "] must not contain a space");
            }
            if (string.contains(",")) {
                validationErrors.add("index_pattern [" + string + "] must not contain a ','");
            }
            if (string.contains("#")) {
                validationErrors.add("index_pattern [" + string + "] must not contain a '#'");
            }
            if (string.contains(":")) {
                validationErrors.add("index_pattern [" + string + "] must not contain a ':'");
            }
            if (string.startsWith("_")) {
                validationErrors.add("index_pattern [" + string + "] must not start with '_'");
            }
            if (Strings.validFileNameExcludingAstrix(string)) continue;
            validationErrors.add("index_pattern [" + string + "] must not contain the following characters " + Strings.INVALID_FILENAME_CHARS);
        }
        if (settings != null) {
            try {
                this.indexScopedSettings.validate(settings, true);
            }
            catch (IllegalArgumentException iae) {
                validationErrors.add(iae.getMessage());
                for (Throwable t : iae.getSuppressed()) {
                    validationErrors.add(t.getMessage());
                }
            }
            List<String> indexSettingsValidation = this.metadataCreateIndexService.getIndexSettingsValidationErrors(settings, true);
            validationErrors.addAll(indexSettingsValidation);
        }
        if (indexPatterns.stream().anyMatch(Regex::isMatchAllPattern) && settings != null && IndexMetadata.INDEX_HIDDEN_SETTING.exists(settings)) {
            validationErrors.add("global templates may not specify the setting " + IndexMetadata.INDEX_HIDDEN_SETTING.getKey());
        }
        if (validationErrors.size() > 0) {
            ValidationException validationException = new ValidationException();
            validationException.addValidationErrors(validationErrors);
            throw new InvalidIndexTemplateException(name, validationException.getMessage());
        }
        for (Alias alias : aliases) {
            this.aliasValidator.validateAliasStandalone(alias);
            if (!indexPatterns.contains(alias.name())) continue;
            throw new IllegalArgumentException("alias [" + alias.name() + "] cannot be the same as any pattern in [" + String.join((CharSequence)", ", indexPatterns) + "]");
        }
    }

    public static interface RemoveListener {
        public void onResponse(RemoveResponse var1);

        public void onFailure(Exception var1);
    }

    public static class RemoveResponse {
        private final boolean acknowledged;

        public RemoveResponse(boolean acknowledged) {
            this.acknowledged = acknowledged;
        }

        public boolean acknowledged() {
            return this.acknowledged;
        }
    }

    public static class RemoveRequest {
        final String name;
        TimeValue masterTimeout = MasterNodeRequest.DEFAULT_MASTER_NODE_TIMEOUT;

        public RemoveRequest(String name) {
            this.name = name;
        }

        public RemoveRequest masterTimeout(TimeValue masterTimeout) {
            this.masterTimeout = masterTimeout;
            return this;
        }
    }

    public static class PutResponse {
        private final boolean acknowledged;

        public PutResponse(boolean acknowledged) {
            this.acknowledged = acknowledged;
        }

        public boolean acknowledged() {
            return this.acknowledged;
        }
    }

    public static class PutRequest {
        final String name;
        final String cause;
        boolean create;
        int order;
        Integer version;
        List<String> indexPatterns;
        Settings settings = Settings.Builder.EMPTY_SETTINGS;
        Map<String, String> mappings = new HashMap<String, String>();
        List<Alias> aliases = new ArrayList<Alias>();
        TimeValue masterTimeout = MasterNodeRequest.DEFAULT_MASTER_NODE_TIMEOUT;

        public PutRequest(String cause, String name) {
            this.cause = cause;
            this.name = name;
        }

        public PutRequest order(int order) {
            this.order = order;
            return this;
        }

        public PutRequest patterns(List<String> indexPatterns) {
            this.indexPatterns = indexPatterns;
            return this;
        }

        public PutRequest create(boolean create) {
            this.create = create;
            return this;
        }

        public PutRequest settings(Settings settings) {
            this.settings = settings;
            return this;
        }

        public PutRequest mappings(Map<String, String> mappings) {
            this.mappings.putAll(mappings);
            return this;
        }

        public PutRequest aliases(Set<Alias> aliases) {
            this.aliases.addAll(aliases);
            return this;
        }

        public PutRequest putMapping(String mappingType, String mappingSource) {
            this.mappings.put(mappingType, mappingSource);
            return this;
        }

        public PutRequest masterTimeout(TimeValue masterTimeout) {
            this.masterTimeout = masterTimeout;
            return this;
        }

        public PutRequest version(Integer version) {
            this.version = version;
            return this;
        }
    }

    public static interface PutListener {
        public void onResponse(PutResponse var1);

        public void onFailure(Exception var1);
    }
}

