/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.gateway;

import com.carrotsearch.hppc.cursors.ObjectCursor;
import java.io.Closeable;
import java.io.IOError;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.IntPredicate;
import java.util.function.LongSupplier;
import java.util.function.Supplier;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.message.Message;
import org.apache.logging.log4j.message.ParameterizedMessage;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.core.KeywordAnalyzer;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.Field;
import org.apache.lucene.document.StoredField;
import org.apache.lucene.document.StringField;
import org.apache.lucene.index.DirectoryReader;
import org.apache.lucene.index.IndexNotFoundException;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.index.IndexWriterConfig;
import org.apache.lucene.index.IndexableField;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.index.MergeScheduler;
import org.apache.lucene.index.SerialMergeScheduler;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.DocIdSetIterator;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.ScoreMode;
import org.apache.lucene.search.Scorer;
import org.apache.lucene.search.TermQuery;
import org.apache.lucene.search.Weight;
import org.apache.lucene.store.AlreadyClosedException;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.SimpleFSDirectory;
import org.apache.lucene.util.Bits;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.BytesRefIterator;
import org.apache.lucene.util.SetOnce;
import org.elasticsearch.Version;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.metadata.IndexMetadata;
import org.elasticsearch.cluster.metadata.Metadata;
import org.elasticsearch.common.CheckedConsumer;
import org.elasticsearch.common.Nullable;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.common.bytes.RecyclingBytesStreamOutput;
import org.elasticsearch.common.io.Streams;
import org.elasticsearch.common.lease.Releasable;
import org.elasticsearch.common.lease.Releasables;
import org.elasticsearch.common.logging.Loggers;
import org.elasticsearch.common.lucene.Lucene;
import org.elasticsearch.common.settings.ClusterSettings;
import org.elasticsearch.common.settings.Setting;
import org.elasticsearch.common.unit.TimeValue;
import org.elasticsearch.common.util.BigArrays;
import org.elasticsearch.common.util.ByteArray;
import org.elasticsearch.common.xcontent.DeprecationHandler;
import org.elasticsearch.common.xcontent.LoggingDeprecationHandler;
import org.elasticsearch.common.xcontent.NamedXContentRegistry;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentFactory;
import org.elasticsearch.common.xcontent.XContentType;
import org.elasticsearch.core.internal.io.IOUtils;
import org.elasticsearch.env.NodeEnvironment;
import org.elasticsearch.env.NodeMetadata;
import org.elasticsearch.index.Index;

public class PersistedClusterStateService {
    private static final Logger logger = LogManager.getLogger(PersistedClusterStateService.class);
    private static final String CURRENT_TERM_KEY = "current_term";
    private static final String LAST_ACCEPTED_VERSION_KEY = "last_accepted_version";
    private static final String NODE_ID_KEY = "node_id";
    private static final String NODE_VERSION_KEY = "node_version";
    private static final String TYPE_FIELD_NAME = "type";
    private static final String DATA_FIELD_NAME = "data";
    private static final String GLOBAL_TYPE_NAME = "global";
    private static final String INDEX_TYPE_NAME = "index";
    private static final String INDEX_UUID_FIELD_NAME = "index_uuid";
    private static final int COMMIT_DATA_SIZE = 4;
    public static final String METADATA_DIRECTORY_NAME = "_state";
    public static final Setting<TimeValue> SLOW_WRITE_LOGGING_THRESHOLD = Setting.timeSetting("gateway.slow_write_logging_threshold", TimeValue.timeValueSeconds((long)10L), TimeValue.ZERO, Setting.Property.NodeScope, Setting.Property.Dynamic);
    private final Path[] dataPaths;
    private final String nodeId;
    private final NamedXContentRegistry namedXContentRegistry;
    private final BigArrays bigArrays;
    private final LongSupplier relativeTimeMillisSupplier;
    private volatile TimeValue slowWriteLoggingThreshold;
    private static final ToXContent.Params FORMAT_PARAMS;

    public PersistedClusterStateService(NodeEnvironment nodeEnvironment, NamedXContentRegistry namedXContentRegistry, BigArrays bigArrays, ClusterSettings clusterSettings, LongSupplier relativeTimeMillisSupplier) {
        this(nodeEnvironment.nodeDataPaths(), nodeEnvironment.nodeId(), namedXContentRegistry, bigArrays, clusterSettings, relativeTimeMillisSupplier);
    }

    public PersistedClusterStateService(Path[] dataPaths, String nodeId, NamedXContentRegistry namedXContentRegistry, BigArrays bigArrays, ClusterSettings clusterSettings, LongSupplier relativeTimeMillisSupplier) {
        this.dataPaths = dataPaths;
        this.nodeId = nodeId;
        this.namedXContentRegistry = namedXContentRegistry;
        this.bigArrays = bigArrays;
        this.relativeTimeMillisSupplier = relativeTimeMillisSupplier;
        this.slowWriteLoggingThreshold = clusterSettings.get(SLOW_WRITE_LOGGING_THRESHOLD);
        clusterSettings.addSettingsUpdateConsumer(SLOW_WRITE_LOGGING_THRESHOLD, this::setSlowWriteLoggingThreshold);
    }

    private void setSlowWriteLoggingThreshold(TimeValue slowWriteLoggingThreshold) {
        this.slowWriteLoggingThreshold = slowWriteLoggingThreshold;
    }

    public String getNodeId() {
        return this.nodeId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Writer createWriter() throws IOException {
        ArrayList<MetadataIndexWriter> metadataIndexWriters = new ArrayList<MetadataIndexWriter>();
        ArrayList<Object> closeables = new ArrayList<Object>();
        boolean success = false;
        try {
            for (Path path : this.dataPaths) {
                Directory directory = this.createDirectory(path.resolve(METADATA_DIRECTORY_NAME));
                closeables.add(directory);
                IndexWriter indexWriter = PersistedClusterStateService.createIndexWriter(directory, false);
                closeables.add(indexWriter);
                metadataIndexWriters.add(new MetadataIndexWriter(directory, indexWriter));
            }
            success = true;
        }
        finally {
            if (!success) {
                IOUtils.closeWhileHandlingException(closeables);
            }
        }
        return new Writer(metadataIndexWriters, this.nodeId, this.bigArrays, this.relativeTimeMillisSupplier, () -> this.slowWriteLoggingThreshold);
    }

    private static IndexWriter createIndexWriter(Directory directory, boolean openExisting) throws IOException {
        IndexWriterConfig indexWriterConfig = new IndexWriterConfig((Analyzer)new KeywordAnalyzer());
        indexWriterConfig.setOpenMode(openExisting ? IndexWriterConfig.OpenMode.APPEND : IndexWriterConfig.OpenMode.CREATE);
        indexWriterConfig.setCommitOnClose(false);
        indexWriterConfig.setRAMBufferSizeMB(1.0);
        indexWriterConfig.setMergeScheduler((MergeScheduler)new SerialMergeScheduler());
        return new IndexWriter(directory, indexWriterConfig);
    }

    public static void deleteAll(Path[] dataPaths) throws IOException {
        for (Path dataPath : dataPaths) {
            Lucene.cleanLuceneIndex((Directory)new SimpleFSDirectory(dataPath.resolve(METADATA_DIRECTORY_NAME)));
        }
    }

    Directory createDirectory(Path path) throws IOException {
        return new SimpleFSDirectory(path);
    }

    public Path[] getDataPaths() {
        return this.dataPaths;
    }

    @Nullable
    public static NodeMetadata nodeMetadata(Path ... dataPaths) throws IOException {
        String nodeId = null;
        Version version = null;
        for (Path dataPath : dataPaths) {
            Path indexPath = dataPath.resolve(METADATA_DIRECTORY_NAME);
            if (!Files.exists(indexPath, new LinkOption[0])) continue;
            try (DirectoryReader reader = DirectoryReader.open((Directory)new SimpleFSDirectory(dataPath.resolve(METADATA_DIRECTORY_NAME)));){
                Map userData = reader.getIndexCommit().getUserData();
                assert (userData.get(NODE_VERSION_KEY) != null);
                String thisNodeId = (String)userData.get(NODE_ID_KEY);
                assert (thisNodeId != null);
                if (nodeId != null && !nodeId.equals(thisNodeId)) {
                    throw new IllegalStateException("unexpected node ID in metadata, found [" + thisNodeId + "] in [" + dataPath + "] but expected [" + nodeId + "]");
                }
                if (nodeId != null) continue;
                nodeId = thisNodeId;
                version = Version.fromId(Integer.parseInt((String)userData.get(NODE_VERSION_KEY)));
            }
            catch (IndexNotFoundException e) {
                logger.debug((Message)new ParameterizedMessage("no on-disk state at {}", (Object)indexPath), (Throwable)e);
            }
        }
        if (nodeId == null) {
            return null;
        }
        return new NodeMetadata(nodeId, version);
    }

    public static void overrideVersion(Version newVersion, Path ... dataPaths) throws IOException {
        for (Path dataPath : dataPaths) {
            Path indexPath = dataPath.resolve(METADATA_DIRECTORY_NAME);
            if (!Files.exists(indexPath, new LinkOption[0])) continue;
            try (DirectoryReader reader = DirectoryReader.open((Directory)new SimpleFSDirectory(dataPath.resolve(METADATA_DIRECTORY_NAME)));){
                Map userData = reader.getIndexCommit().getUserData();
                assert (userData.get(NODE_VERSION_KEY) != null);
                try (IndexWriter indexWriter = PersistedClusterStateService.createIndexWriter((Directory)new SimpleFSDirectory(dataPath.resolve(METADATA_DIRECTORY_NAME)), true);){
                    HashMap<String, String> commitData = new HashMap<String, String>(userData);
                    commitData.put(NODE_VERSION_KEY, Integer.toString(newVersion.id));
                    indexWriter.setLiveCommitData(commitData.entrySet());
                    indexWriter.commit();
                }
            }
            catch (IndexNotFoundException e) {
                logger.debug((Message)new ParameterizedMessage("no on-disk state at {}", (Object)indexPath), (Throwable)e);
            }
        }
    }

    public OnDiskState loadBestOnDiskState() throws IOException {
        OnDiskState bestOnDiskState;
        String committedClusterUuid = null;
        Path committedClusterUuidPath = null;
        OnDiskState maxCurrentTermOnDiskState = bestOnDiskState = OnDiskState.NO_ON_DISK_STATE;
        for (Path dataPath : this.dataPaths) {
            Path indexPath = dataPath.resolve(METADATA_DIRECTORY_NAME);
            if (!Files.exists(indexPath, new LinkOption[0])) continue;
            try (Directory directory = this.createDirectory(indexPath);
                 DirectoryReader directoryReader = DirectoryReader.open((Directory)directory);){
                OnDiskState onDiskState = this.loadOnDiskState(dataPath, directoryReader);
                if (!this.nodeId.equals(onDiskState.nodeId)) {
                    throw new IllegalStateException("unexpected node ID in metadata, found [" + onDiskState.nodeId + "] in [" + dataPath + "] but expected [" + this.nodeId + "]");
                }
                if (onDiskState.metadata.clusterUUIDCommitted()) {
                    if (committedClusterUuid == null) {
                        committedClusterUuid = onDiskState.metadata.clusterUUID();
                        committedClusterUuidPath = dataPath;
                    } else if (!committedClusterUuid.equals(onDiskState.metadata.clusterUUID())) {
                        throw new IllegalStateException("mismatched cluster UUIDs in metadata, found [" + committedClusterUuid + "] in [" + committedClusterUuidPath + "] and [" + onDiskState.metadata.clusterUUID() + "] in [" + dataPath + "]");
                    }
                }
                if (maxCurrentTermOnDiskState.empty() || maxCurrentTermOnDiskState.currentTerm < onDiskState.currentTerm) {
                    maxCurrentTermOnDiskState = onDiskState;
                }
                long acceptedTerm = onDiskState.metadata.coordinationMetadata().term();
                long maxAcceptedTerm = bestOnDiskState.metadata.coordinationMetadata().term();
                if (!bestOnDiskState.empty() && acceptedTerm <= maxAcceptedTerm && (acceptedTerm != maxAcceptedTerm || onDiskState.lastAcceptedVersion <= bestOnDiskState.lastAcceptedVersion && (onDiskState.lastAcceptedVersion != bestOnDiskState.lastAcceptedVersion || onDiskState.currentTerm <= bestOnDiskState.currentTerm))) continue;
                bestOnDiskState = onDiskState;
            }
            catch (IndexNotFoundException e) {
                logger.debug((Message)new ParameterizedMessage("no on-disk state at {}", (Object)indexPath), (Throwable)e);
            }
        }
        if (bestOnDiskState.currentTerm != maxCurrentTermOnDiskState.currentTerm) {
            throw new IllegalStateException("inconsistent terms found: best state is from [" + bestOnDiskState.dataPath + "] in term [" + bestOnDiskState.currentTerm + "] but there is a stale state in [" + maxCurrentTermOnDiskState.dataPath + "] with greater term [" + maxCurrentTermOnDiskState.currentTerm + "]");
        }
        return bestOnDiskState;
    }

    private OnDiskState loadOnDiskState(Path dataPath, DirectoryReader reader) throws IOException {
        IndexSearcher searcher = new IndexSearcher((IndexReader)reader);
        searcher.setQueryCache(null);
        SetOnce builderReference = new SetOnce();
        PersistedClusterStateService.consumeFromType(searcher, GLOBAL_TYPE_NAME, (CheckedConsumer<BytesRef, IOException>)((CheckedConsumer)bytes -> {
            Metadata metadata = Metadata.Builder.fromXContent(XContentFactory.xContent((XContentType)XContentType.SMILE).createParser(this.namedXContentRegistry, (DeprecationHandler)LoggingDeprecationHandler.INSTANCE, bytes.bytes, bytes.offset, bytes.length));
            logger.trace("found global metadata with last-accepted term [{}]", (Object)metadata.coordinationMetadata().term());
            if (builderReference.get() != null) {
                throw new IllegalStateException("duplicate global metadata found in [" + dataPath + "]");
            }
            builderReference.set((Object)Metadata.builder(metadata));
        }));
        Metadata.Builder builder = (Metadata.Builder)builderReference.get();
        if (builder == null) {
            throw new IllegalStateException("no global metadata found in [" + dataPath + "]");
        }
        logger.trace("got global metadata, now reading index metadata");
        HashSet indexUUIDs = new HashSet();
        PersistedClusterStateService.consumeFromType(searcher, INDEX_TYPE_NAME, (CheckedConsumer<BytesRef, IOException>)((CheckedConsumer)bytes -> {
            IndexMetadata indexMetadata = IndexMetadata.fromXContent(XContentFactory.xContent((XContentType)XContentType.SMILE).createParser(this.namedXContentRegistry, (DeprecationHandler)LoggingDeprecationHandler.INSTANCE, bytes.bytes, bytes.offset, bytes.length));
            logger.trace("found index metadata for {}", (Object)indexMetadata.getIndex());
            if (!indexUUIDs.add(indexMetadata.getIndexUUID())) {
                throw new IllegalStateException("duplicate metadata found for " + indexMetadata.getIndex() + " in [" + dataPath + "]");
            }
            builder.put(indexMetadata, false);
        }));
        Map userData = reader.getIndexCommit().getUserData();
        logger.trace("loaded metadata [{}] from [{}]", (Object)userData, (Object)reader.directory());
        assert (userData.size() == 4) : userData;
        assert (userData.get(CURRENT_TERM_KEY) != null);
        assert (userData.get(LAST_ACCEPTED_VERSION_KEY) != null);
        assert (userData.get(NODE_ID_KEY) != null);
        assert (userData.get(NODE_VERSION_KEY) != null);
        return new OnDiskState((String)userData.get(NODE_ID_KEY), dataPath, Long.parseLong((String)userData.get(CURRENT_TERM_KEY)), Long.parseLong((String)userData.get(LAST_ACCEPTED_VERSION_KEY)), builder.build());
    }

    private static void consumeFromType(IndexSearcher indexSearcher, String type, CheckedConsumer<BytesRef, IOException> bytesRefConsumer) throws IOException {
        TermQuery query = new TermQuery(new Term(TYPE_FIELD_NAME, type));
        Weight weight = indexSearcher.createWeight((Query)query, ScoreMode.COMPLETE_NO_SCORES, 0.0f);
        logger.trace("running query [{}]", (Object)query);
        for (LeafReaderContext leafReaderContext : indexSearcher.getIndexReader().leaves()) {
            logger.trace("new leafReaderContext: {}", (Object)leafReaderContext);
            Scorer scorer = weight.scorer(leafReaderContext);
            if (scorer == null) continue;
            Bits liveDocs = leafReaderContext.reader().getLiveDocs();
            IntPredicate isLiveDoc = liveDocs == null ? i -> true : arg_0 -> ((Bits)liveDocs).get(arg_0);
            DocIdSetIterator docIdSetIterator = scorer.iterator();
            while (docIdSetIterator.nextDoc() != Integer.MAX_VALUE) {
                if (!isLiveDoc.test(docIdSetIterator.docID())) continue;
                logger.trace("processing doc {}", (Object)docIdSetIterator.docID());
                bytesRefConsumer.accept((Object)leafReaderContext.reader().document(docIdSetIterator.docID()).getBinaryValue(DATA_FIELD_NAME));
            }
        }
    }

    static {
        HashMap<String, String> params = new HashMap<String, String>(2);
        params.put("binary", "true");
        params.put("context_mode", Metadata.CONTEXT_MODE_GATEWAY);
        FORMAT_PARAMS = new ToXContent.MapParams(params);
    }

    private static class DocumentBuffer
    implements Releasable {
        private final BigArrays bigArrays;
        @Nullable
        private final Releasable releasable;
        private byte[] buffer;
        private int maxUsed;

        DocumentBuffer(int size, BigArrays bigArrays) {
            if (size <= 16384) {
                BytesRef firstPage;
                ByteArray byteArray = bigArrays.newByteArray(16384L);
                BytesRefIterator iterator = BytesReference.fromByteArray(byteArray, Math.toIntExact(byteArray.size())).iterator();
                try {
                    firstPage = iterator.next();
                    assert (iterator.next() == null) : "should be one page";
                }
                catch (IOException e) {
                    throw new AssertionError("impossible", e);
                }
                assert (firstPage.offset == 0) : firstPage.offset;
                assert (firstPage.bytes.length == 16384) : firstPage.bytes.length;
                this.buffer = firstPage.bytes;
                this.releasable = byteArray;
            } else {
                this.buffer = new byte[size];
                this.releasable = null;
            }
            this.bigArrays = bigArrays;
            this.maxUsed = 0;
        }

        RecyclingBytesStreamOutput streamOutput() {
            return new RecyclingBytesStreamOutput(this.buffer, this.bigArrays){

                @Override
                public BytesRef toBytesRef() {
                    BytesRef bytesRef = super.toBytesRef();
                    maxUsed = Math.max(maxUsed, bytesRef.length);
                    if (buffer != bytesRef.bytes) {
                        assert (bytesRef.length > buffer.length);
                        logger.trace("growing document buffer from [{}] to [{}]", (Object)buffer.length, (Object)maxUsed);
                        DocumentBuffer.access$902(this, bytesRef.bytes);
                    }
                    assert (maxUsed <= buffer.length);
                    return bytesRef;
                }
            };
        }

        int getMaxUsed() {
            return this.maxUsed;
        }

        @Override
        public void close() {
            Releasables.close(this.releasable);
        }

        static /* synthetic */ byte[] access$902(DocumentBuffer x0, byte[] x1) {
            x0.buffer = x1;
            return x1;
        }
    }

    public static class Writer
    implements Closeable {
        private final List<MetadataIndexWriter> metadataIndexWriters;
        private final String nodeId;
        private final BigArrays bigArrays;
        private final LongSupplier relativeTimeMillisSupplier;
        private final Supplier<TimeValue> slowWriteLoggingThresholdSupplier;
        boolean fullStateWritten = false;
        private final AtomicBoolean closed = new AtomicBoolean();
        private int documentBufferUsed;

        private Writer(List<MetadataIndexWriter> metadataIndexWriters, String nodeId, BigArrays bigArrays, LongSupplier relativeTimeMillisSupplier, Supplier<TimeValue> slowWriteLoggingThresholdSupplier) {
            this.metadataIndexWriters = metadataIndexWriters;
            this.nodeId = nodeId;
            this.bigArrays = bigArrays;
            this.relativeTimeMillisSupplier = relativeTimeMillisSupplier;
            this.slowWriteLoggingThresholdSupplier = slowWriteLoggingThresholdSupplier;
        }

        private void ensureOpen() {
            if (this.closed.get()) {
                throw new AlreadyClosedException("cluster state writer is closed already");
            }
        }

        public boolean isOpen() {
            return !this.closed.get();
        }

        private void closeIfAnyIndexWriterHasTragedyOrIsClosed() {
            if (this.metadataIndexWriters.stream().map(writer -> ((MetadataIndexWriter)writer).indexWriter).anyMatch(iw -> iw.getTragicException() != null || !iw.isOpen())) {
                try {
                    this.close();
                }
                catch (Exception e) {
                    logger.warn("failed on closing cluster state writer", (Throwable)e);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void writeFullStateAndCommit(long currentTerm, ClusterState clusterState) throws IOException {
            this.ensureOpen();
            try {
                long startTimeMillis = this.relativeTimeMillisSupplier.getAsLong();
                WriterStats stats = this.overwriteMetadata(clusterState.metadata());
                this.commit(currentTerm, clusterState.version());
                this.fullStateWritten = true;
                long durationMillis = this.relativeTimeMillisSupplier.getAsLong() - startTimeMillis;
                TimeValue finalSlowWriteLoggingThreshold = this.slowWriteLoggingThresholdSupplier.get();
                if (durationMillis >= finalSlowWriteLoggingThreshold.getMillis()) {
                    logger.warn("writing cluster state took [{}ms] which is above the warn threshold of [{}]; wrote full state with [{}] indices", (Object)durationMillis, (Object)finalSlowWriteLoggingThreshold, (Object)stats.numIndicesUpdated);
                } else {
                    logger.debug("writing cluster state took [{}ms]; wrote full state with [{}] indices", (Object)durationMillis, (Object)stats.numIndicesUpdated);
                }
            }
            finally {
                this.closeIfAnyIndexWriterHasTragedyOrIsClosed();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void writeIncrementalStateAndCommit(long currentTerm, ClusterState previousClusterState, ClusterState clusterState) throws IOException {
            this.ensureOpen();
            this.ensureFullStateWritten();
            try {
                long startTimeMillis = this.relativeTimeMillisSupplier.getAsLong();
                WriterStats stats = this.updateMetadata(previousClusterState.metadata(), clusterState.metadata());
                this.commit(currentTerm, clusterState.version());
                long durationMillis = this.relativeTimeMillisSupplier.getAsLong() - startTimeMillis;
                TimeValue finalSlowWriteLoggingThreshold = this.slowWriteLoggingThresholdSupplier.get();
                if (durationMillis >= finalSlowWriteLoggingThreshold.getMillis()) {
                    logger.warn("writing cluster state took [{}ms] which is above the warn threshold of [{}]; wrote global metadata [{}] and metadata for [{}] indices and skipped [{}] unchanged indices", (Object)durationMillis, (Object)finalSlowWriteLoggingThreshold, (Object)stats.globalMetaUpdated, (Object)stats.numIndicesUpdated, (Object)stats.numIndicesUnchanged);
                } else {
                    logger.debug("writing cluster state took [{}ms]; wrote global metadata [{}] and metadata for [{}] indices and skipped [{}] unchanged indices", (Object)durationMillis, (Object)stats.globalMetaUpdated, (Object)stats.numIndicesUpdated, (Object)stats.numIndicesUnchanged);
                }
            }
            finally {
                this.closeIfAnyIndexWriterHasTragedyOrIsClosed();
            }
        }

        private void ensureFullStateWritten() {
            assert (this.fullStateWritten) : "Need to write full state first before doing incremental writes";
            if (!this.fullStateWritten) {
                logger.error("cannot write incremental state");
                throw new IllegalStateException("cannot write incremental state");
            }
        }

        private WriterStats updateMetadata(Metadata previouslyWrittenMetadata, Metadata metadata) throws IOException {
            assert (previouslyWrittenMetadata.coordinationMetadata().term() == metadata.coordinationMetadata().term());
            logger.trace("currentTerm [{}] matches previous currentTerm, writing changes only", (Object)metadata.coordinationMetadata().term());
            try (DocumentBuffer documentBuffer = this.allocateBuffer();){
                boolean updateGlobalMeta;
                boolean bl = updateGlobalMeta = !Metadata.isGlobalStateEquals(previouslyWrittenMetadata, metadata);
                if (updateGlobalMeta) {
                    Document globalMetadataDocument = this.makeGlobalMetadataDocument(metadata, documentBuffer);
                    for (MetadataIndexWriter metadataIndexWriter : this.metadataIndexWriters) {
                        metadataIndexWriter.updateGlobalMetadata(globalMetadataDocument);
                    }
                }
                HashMap<String, Long> indexMetadataVersionByUUID = new HashMap<String, Long>(previouslyWrittenMetadata.indices().size());
                for (ObjectCursor cursor : previouslyWrittenMetadata.indices().values()) {
                    IndexMetadata indexMetadata = (IndexMetadata)cursor.value;
                    Long previousValue = indexMetadataVersionByUUID.putIfAbsent(indexMetadata.getIndexUUID(), indexMetadata.getVersion());
                    assert (previousValue == null) : indexMetadata.getIndexUUID() + " already mapped to " + previousValue;
                }
                int numIndicesUpdated = 0;
                int numIndicesUnchanged = 0;
                for (ObjectCursor cursor : metadata.indices().values()) {
                    IndexMetadata indexMetadata = (IndexMetadata)cursor.value;
                    Long previousVersion = (Long)indexMetadataVersionByUUID.get(indexMetadata.getIndexUUID());
                    if (previousVersion == null || indexMetadata.getVersion() != previousVersion.longValue()) {
                        logger.trace("updating metadata for [{}], changing version from [{}] to [{}]", (Object)indexMetadata.getIndex(), (Object)previousVersion, (Object)indexMetadata.getVersion());
                        ++numIndicesUpdated;
                        Document indexMetadataDocument = this.makeIndexMetadataDocument(indexMetadata, documentBuffer);
                        for (MetadataIndexWriter metadataIndexWriter : this.metadataIndexWriters) {
                            metadataIndexWriter.updateIndexMetadataDocument(indexMetadataDocument, indexMetadata.getIndex());
                        }
                    } else {
                        ++numIndicesUnchanged;
                        logger.trace("no action required for [{}]", (Object)indexMetadata.getIndex());
                    }
                    indexMetadataVersionByUUID.remove(indexMetadata.getIndexUUID());
                }
                this.documentBufferUsed = documentBuffer.getMaxUsed();
                for (String removedIndexUUID : indexMetadataVersionByUUID.keySet()) {
                    for (MetadataIndexWriter metadataIndexWriter : this.metadataIndexWriters) {
                        metadataIndexWriter.deleteIndexMetadata(removedIndexUUID);
                    }
                }
                for (MetadataIndexWriter metadataIndexWriter : this.metadataIndexWriters) {
                    metadataIndexWriter.flush();
                }
                WriterStats writerStats = new WriterStats(updateGlobalMeta, numIndicesUpdated, numIndicesUnchanged);
                return writerStats;
            }
        }

        private WriterStats overwriteMetadata(Metadata metadata) throws IOException {
            for (MetadataIndexWriter metadataIndexWriter : this.metadataIndexWriters) {
                metadataIndexWriter.deleteAll();
            }
            return this.addMetadata(metadata);
        }

        private WriterStats addMetadata(Metadata metadata) throws IOException {
            try (DocumentBuffer documentBuffer = this.allocateBuffer();){
                Document globalMetadataDocument = this.makeGlobalMetadataDocument(metadata, documentBuffer);
                for (MetadataIndexWriter metadataIndexWriter : this.metadataIndexWriters) {
                    metadataIndexWriter.updateGlobalMetadata(globalMetadataDocument);
                }
                for (ObjectCursor cursor : metadata.indices().values()) {
                    IndexMetadata indexMetadata = (IndexMetadata)cursor.value;
                    Document indexMetadataDocument = this.makeIndexMetadataDocument(indexMetadata, documentBuffer);
                    for (MetadataIndexWriter metadataIndexWriter : this.metadataIndexWriters) {
                        metadataIndexWriter.updateIndexMetadataDocument(indexMetadataDocument, indexMetadata.getIndex());
                    }
                }
                this.documentBufferUsed = documentBuffer.getMaxUsed();
                for (MetadataIndexWriter metadataIndexWriter : this.metadataIndexWriters) {
                    metadataIndexWriter.flush();
                }
                WriterStats writerStats = new WriterStats(true, metadata.indices().size(), 0L);
                return writerStats;
            }
        }

        private DocumentBuffer allocateBuffer() {
            int extraSpace = this.documentBufferUsed <= 16384 ? 0 : 16384;
            return new DocumentBuffer(this.documentBufferUsed + extraSpace, this.bigArrays);
        }

        public void writeIncrementalTermUpdateAndCommit(long currentTerm, long lastAcceptedVersion) throws IOException {
            this.ensureOpen();
            this.ensureFullStateWritten();
            this.commit(currentTerm, lastAcceptedVersion);
        }

        void commit(long currentTerm, long lastAcceptedVersion) throws IOException {
            this.ensureOpen();
            try {
                for (MetadataIndexWriter metadataIndexWriter : this.metadataIndexWriters) {
                    metadataIndexWriter.prepareCommit(this.nodeId, currentTerm, lastAcceptedVersion);
                }
            }
            catch (Exception e) {
                try {
                    this.close();
                }
                catch (Exception e2) {
                    logger.warn("failed on closing cluster state writer", (Throwable)e2);
                    e.addSuppressed(e2);
                }
                throw e;
            }
            finally {
                this.closeIfAnyIndexWriterHasTragedyOrIsClosed();
            }
            try {
                for (MetadataIndexWriter metadataIndexWriter : this.metadataIndexWriters) {
                    metadataIndexWriter.commit();
                }
            }
            catch (IOException e) {
                try {
                    this.close();
                }
                catch (Exception e2) {
                    e.addSuppressed(e2);
                }
                throw new IOError(e);
            }
            finally {
                this.closeIfAnyIndexWriterHasTragedyOrIsClosed();
            }
        }

        @Override
        public void close() throws IOException {
            logger.trace("closing PersistedClusterStateService.Writer");
            if (this.closed.compareAndSet(false, true)) {
                IOUtils.close(this.metadataIndexWriters);
            }
        }

        private Document makeIndexMetadataDocument(IndexMetadata indexMetadata, DocumentBuffer documentBuffer) throws IOException {
            Document indexMetadataDocument = this.makeDocument(PersistedClusterStateService.INDEX_TYPE_NAME, (ToXContent)indexMetadata, documentBuffer);
            String indexUUID = indexMetadata.getIndexUUID();
            assert (!indexUUID.equals("_na_"));
            indexMetadataDocument.add((IndexableField)new StringField(PersistedClusterStateService.INDEX_UUID_FIELD_NAME, indexUUID, Field.Store.NO));
            return indexMetadataDocument;
        }

        private Document makeGlobalMetadataDocument(Metadata metadata, DocumentBuffer documentBuffer) throws IOException {
            return this.makeDocument(PersistedClusterStateService.GLOBAL_TYPE_NAME, (ToXContent)metadata, documentBuffer);
        }

        private Document makeDocument(String typeName, ToXContent metadata, DocumentBuffer documentBuffer) throws IOException {
            Document document = new Document();
            document.add((IndexableField)new StringField(PersistedClusterStateService.TYPE_FIELD_NAME, typeName, Field.Store.NO));
            try (RecyclingBytesStreamOutput streamOutput = documentBuffer.streamOutput();){
                try (XContentBuilder xContentBuilder = XContentFactory.contentBuilder((XContentType)XContentType.SMILE, (OutputStream)Streams.flushOnCloseStream(streamOutput));){
                    xContentBuilder.startObject();
                    metadata.toXContent(xContentBuilder, FORMAT_PARAMS);
                    xContentBuilder.endObject();
                }
                document.add((IndexableField)new StoredField(PersistedClusterStateService.DATA_FIELD_NAME, streamOutput.toBytesRef()));
            }
            return document;
        }

        static class WriterStats {
            final boolean globalMetaUpdated;
            final long numIndicesUpdated;
            final long numIndicesUnchanged;

            WriterStats(boolean globalMetaUpdated, long numIndicesUpdated, long numIndicesUnchanged) {
                this.globalMetaUpdated = globalMetaUpdated;
                this.numIndicesUpdated = numIndicesUpdated;
                this.numIndicesUnchanged = numIndicesUnchanged;
            }
        }
    }

    private static class MetadataIndexWriter
    implements Closeable {
        private final Logger logger;
        private final Directory directory;
        private final IndexWriter indexWriter;

        MetadataIndexWriter(Directory directory, IndexWriter indexWriter) {
            this.directory = directory;
            this.indexWriter = indexWriter;
            this.logger = Loggers.getLogger(MetadataIndexWriter.class, directory.toString());
        }

        void deleteAll() throws IOException {
            this.logger.trace("clearing existing metadata");
            this.indexWriter.deleteAll();
        }

        void updateIndexMetadataDocument(Document indexMetadataDocument, Index index) throws IOException {
            this.logger.trace("updating metadata for [{}]", (Object)index);
            this.indexWriter.updateDocument(new Term(PersistedClusterStateService.INDEX_UUID_FIELD_NAME, index.getUUID()), (Iterable)indexMetadataDocument);
        }

        void updateGlobalMetadata(Document globalMetadataDocument) throws IOException {
            this.logger.trace("updating global metadata doc");
            this.indexWriter.updateDocument(new Term(PersistedClusterStateService.TYPE_FIELD_NAME, PersistedClusterStateService.GLOBAL_TYPE_NAME), (Iterable)globalMetadataDocument);
        }

        void deleteIndexMetadata(String indexUUID) throws IOException {
            this.logger.trace("removing metadata for [{}]", (Object)indexUUID);
            this.indexWriter.deleteDocuments(new Term[]{new Term(PersistedClusterStateService.INDEX_UUID_FIELD_NAME, indexUUID)});
        }

        void flush() throws IOException {
            this.logger.trace("flushing");
            this.indexWriter.flush();
        }

        void prepareCommit(String nodeId, long currentTerm, long lastAcceptedVersion) throws IOException {
            HashMap<String, String> commitData = new HashMap<String, String>(4);
            commitData.put(PersistedClusterStateService.CURRENT_TERM_KEY, Long.toString(currentTerm));
            commitData.put(PersistedClusterStateService.LAST_ACCEPTED_VERSION_KEY, Long.toString(lastAcceptedVersion));
            commitData.put(PersistedClusterStateService.NODE_VERSION_KEY, Integer.toString(Version.CURRENT.id));
            commitData.put(PersistedClusterStateService.NODE_ID_KEY, nodeId);
            this.indexWriter.setLiveCommitData(commitData.entrySet());
            this.indexWriter.prepareCommit();
        }

        void commit() throws IOException {
            this.indexWriter.commit();
        }

        @Override
        public void close() throws IOException {
            IOUtils.close((Closeable[])new Closeable[]{this.indexWriter, this.directory});
        }
    }

    public static class OnDiskState {
        private static final OnDiskState NO_ON_DISK_STATE = new OnDiskState(null, null, 0L, 0L, Metadata.EMPTY_METADATA);
        private final String nodeId;
        private final Path dataPath;
        public final long currentTerm;
        public final long lastAcceptedVersion;
        public final Metadata metadata;

        private OnDiskState(String nodeId, Path dataPath, long currentTerm, long lastAcceptedVersion, Metadata metadata) {
            this.nodeId = nodeId;
            this.dataPath = dataPath;
            this.currentTerm = currentTerm;
            this.lastAcceptedVersion = lastAcceptedVersion;
            this.metadata = metadata;
        }

        public boolean empty() {
            return this == NO_ON_DISK_STATE;
        }
    }
}

