/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.watcher.actions.index;

import java.io.IOException;
import java.time.ZonedDateTime;
import java.util.HashMap;
import java.util.Map;
import java.util.stream.Stream;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.action.DocWriteResponse;
import org.elasticsearch.action.bulk.BulkItemResponse;
import org.elasticsearch.action.bulk.BulkRequest;
import org.elasticsearch.action.bulk.BulkResponse;
import org.elasticsearch.action.index.IndexRequest;
import org.elasticsearch.action.index.IndexResponse;
import org.elasticsearch.client.Client;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.common.unit.TimeValue;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentFactory;
import org.elasticsearch.common.xcontent.XContentType;
import org.elasticsearch.xpack.core.ClientHelper;
import org.elasticsearch.xpack.core.watcher.actions.Action;
import org.elasticsearch.xpack.core.watcher.actions.ExecutableAction;
import org.elasticsearch.xpack.core.watcher.execution.WatchExecutionContext;
import org.elasticsearch.xpack.core.watcher.support.Exceptions;
import org.elasticsearch.xpack.core.watcher.support.WatcherDateTimeUtils;
import org.elasticsearch.xpack.core.watcher.support.xcontent.XContentSource;
import org.elasticsearch.xpack.core.watcher.watch.Payload;
import org.elasticsearch.xpack.watcher.actions.index.IndexAction;
import org.elasticsearch.xpack.watcher.support.ArrayObjectIterator;

public class ExecutableIndexAction
extends ExecutableAction<IndexAction> {
    private static final String INDEX_FIELD = "_index";
    private static final String TYPE_FIELD = "_type";
    private static final String ID_FIELD = "_id";
    private final Client client;
    private final TimeValue indexDefaultTimeout;
    private final TimeValue bulkDefaultTimeout;

    public ExecutableIndexAction(IndexAction action, Logger logger, Client client, TimeValue indexDefaultTimeout, TimeValue bulkDefaultTimeout) {
        super((Action)action, logger);
        this.client = client;
        this.indexDefaultTimeout = action.timeout != null ? action.timeout : indexDefaultTimeout;
        this.bulkDefaultTimeout = action.timeout != null ? action.timeout : bulkDefaultTimeout;
    }

    public Action.Result execute(String actionId, WatchExecutionContext ctx, Payload payload) throws Exception {
        BytesReference bytesReference;
        Map<String, Object> data = payload.data();
        if (data.containsKey("_doc")) {
            Object doc = data.get("_doc");
            if (doc instanceof Iterable) {
                return this.indexBulk((Iterable)doc, actionId, ctx);
            }
            if (doc.getClass().isArray()) {
                return this.indexBulk(new ArrayObjectIterator.Iterable(doc), actionId, ctx);
            }
            if (doc instanceof Map) {
                data = (Map<String, Object>)doc;
            } else {
                throw Exceptions.illegalState((String)"could not execute action [{}] of watch [{}]. failed to index payload data.[_data] field must either hold a Map or an List/Array of Maps", (Object[])new Object[]{actionId, ctx.watch().id()});
            }
        }
        if (data.containsKey(INDEX_FIELD) || data.containsKey(TYPE_FIELD) || data.containsKey(ID_FIELD)) {
            data = this.mutableMap(data);
        }
        IndexRequest indexRequest = new IndexRequest();
        if (((IndexAction)this.action).refreshPolicy != null) {
            indexRequest.setRefreshPolicy(((IndexAction)this.action).refreshPolicy);
        }
        indexRequest.index(this.getField(actionId, ctx.id().watchId(), "index", data, INDEX_FIELD, ((IndexAction)this.action).index));
        indexRequest.type(this.getField(actionId, ctx.id().watchId(), "type", data, TYPE_FIELD, ((IndexAction)this.action).docType));
        indexRequest.id(this.getField(actionId, ctx.id().watchId(), "id", data, ID_FIELD, ((IndexAction)this.action).docId));
        if (((IndexAction)this.action).opType != null) {
            indexRequest.opType(((IndexAction)this.action).opType);
        }
        data = this.addTimestampToDocument(data, ctx.executionTime());
        try (XContentBuilder builder = XContentFactory.jsonBuilder();){
            indexRequest.source(builder.prettyPrint().map(data));
        }
        if (ctx.simulateAction(actionId)) {
            return new IndexAction.Simulated(indexRequest.index(), indexRequest.type(), indexRequest.id(), ((IndexAction)this.action).refreshPolicy, new XContentSource(indexRequest.source(), XContentType.JSON));
        }
        ClientHelper.assertNoAuthorizationHeader((Map)ctx.watch().status().getHeaders());
        IndexResponse response = (IndexResponse)ClientHelper.executeWithHeaders((Map)ctx.watch().status().getHeaders(), (String)"watcher", (Client)this.client, () -> (IndexResponse)this.client.index(indexRequest).actionGet(this.indexDefaultTimeout));
        try (XContentBuilder builder = XContentFactory.jsonBuilder();){
            ExecutableIndexAction.indexResponseToXContent(builder, response);
            bytesReference = BytesReference.bytes((XContentBuilder)builder);
        }
        return new IndexAction.Result(Action.Result.Status.SUCCESS, new XContentSource(bytesReference, XContentType.JSON));
    }

    Action.Result indexBulk(Iterable list, String actionId, WatchExecutionContext ctx) throws Exception {
        if (((IndexAction)this.action).docId != null) {
            throw Exceptions.illegalState((String)"could not execute action [{}] of watch [{}]. [doc_id] cannot be used with bulk [_doc] indexing", (Object[])new Object[0]);
        }
        BulkRequest bulkRequest = new BulkRequest();
        if (((IndexAction)this.action).refreshPolicy != null) {
            bulkRequest.setRefreshPolicy(((IndexAction)this.action).refreshPolicy);
        }
        for (Object item : list) {
            if (!(item instanceof Map)) {
                throw Exceptions.illegalState((String)"could not execute action [{}] of watch [{}]. failed to index payload data. [_data] field must either hold a Map or an List/Array of Maps", (Object[])new Object[]{actionId, ctx.watch().id()});
            }
            Map<String, Object> doc = (Map<String, Object>)item;
            if (doc.containsKey(INDEX_FIELD) || doc.containsKey(TYPE_FIELD) || doc.containsKey(ID_FIELD)) {
                doc = this.mutableMap(doc);
            }
            IndexRequest indexRequest = new IndexRequest();
            indexRequest.index(this.getField(actionId, ctx.id().watchId(), "index", doc, INDEX_FIELD, ((IndexAction)this.action).index));
            indexRequest.type(this.getField(actionId, ctx.id().watchId(), "type", doc, TYPE_FIELD, ((IndexAction)this.action).docType));
            indexRequest.id(this.getField(actionId, ctx.id().watchId(), "id", doc, ID_FIELD, ((IndexAction)this.action).docId));
            if (((IndexAction)this.action).opType != null) {
                indexRequest.opType(((IndexAction)this.action).opType);
            }
            doc = this.addTimestampToDocument(doc, ctx.executionTime());
            try (XContentBuilder builder = XContentFactory.jsonBuilder();){
                indexRequest.source(builder.prettyPrint().map(doc));
            }
            bulkRequest.add(indexRequest);
        }
        ClientHelper.assertNoAuthorizationHeader((Map)ctx.watch().status().getHeaders());
        BulkResponse bulkResponse = (BulkResponse)ClientHelper.executeWithHeaders((Map)ctx.watch().status().getHeaders(), (String)"watcher", (Client)this.client, () -> (BulkResponse)this.client.bulk(bulkRequest).actionGet(this.bulkDefaultTimeout));
        try (XContentBuilder jsonBuilder = XContentFactory.jsonBuilder().startArray();){
            IndexAction.Result result;
            for (BulkItemResponse item : bulkResponse) {
                ExecutableIndexAction.itemResponseToXContent(jsonBuilder, item);
            }
            jsonBuilder.endArray();
            long failures = Stream.of(bulkResponse.getItems()).filter(BulkItemResponse::isFailed).count();
            if (failures == 0L) {
                result = new IndexAction.Result(Action.Result.Status.SUCCESS, new XContentSource(BytesReference.bytes((XContentBuilder)jsonBuilder), XContentType.JSON));
                return result;
            }
            if (failures == (long)bulkResponse.getItems().length) {
                result = new IndexAction.Result(Action.Result.Status.FAILURE, new XContentSource(BytesReference.bytes((XContentBuilder)jsonBuilder), XContentType.JSON));
                return result;
            }
            result = new IndexAction.Result(Action.Result.Status.PARTIAL_FAILURE, new XContentSource(BytesReference.bytes((XContentBuilder)jsonBuilder), XContentType.JSON));
            return result;
        }
    }

    private Map<String, Object> addTimestampToDocument(Map<String, Object> data, ZonedDateTime executionTime) {
        if (((IndexAction)this.action).executionTimeField != null) {
            data = this.mutableMap(data);
            data.put(((IndexAction)this.action).executionTimeField, WatcherDateTimeUtils.formatDate((ZonedDateTime)executionTime));
        }
        return data;
    }

    private String getField(String actionId, String watchId, String name, Map<String, Object> data, String fieldName, String defaultValue) {
        Object obj = data.remove(fieldName);
        if (obj != null) {
            if (defaultValue != null) {
                throw Exceptions.illegalState((String)"could not execute action [{}] of watch [{}]. [ctx.payload.{}] or [ctx.payload._doc.{}] were set together with action [{}] field. Only set one of them", (Object[])new Object[]{actionId, watchId, fieldName, fieldName, name});
            }
            return obj.toString();
        }
        return defaultValue;
    }

    private Map<String, Object> mutableMap(Map<String, Object> data) {
        return data instanceof HashMap ? data : new HashMap(data);
    }

    private static void itemResponseToXContent(XContentBuilder builder, BulkItemResponse item) throws IOException {
        if (item.isFailed()) {
            builder.startObject().field("failed", item.isFailed()).field("message", item.getFailureMessage()).field("id", item.getId()).field("type", item.getType()).field("index", item.getIndex()).endObject();
        } else {
            ExecutableIndexAction.indexResponseToXContent(builder, (IndexResponse)item.getResponse());
        }
    }

    static void indexResponseToXContent(XContentBuilder builder, IndexResponse response) throws IOException {
        builder.startObject().field("created", response.getResult() == DocWriteResponse.Result.CREATED).field("result", response.getResult().getLowercase()).field("id", response.getId()).field("version", response.getVersion()).field("type", response.getType()).field("index", response.getIndex()).endObject();
    }
}

