/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.watcher.rest.action;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.rest.BaseRestHandler;
import org.elasticsearch.rest.BytesRestResponse;
import org.elasticsearch.rest.RestHandler;
import org.elasticsearch.rest.RestRequest;
import org.elasticsearch.rest.RestResponse;
import org.elasticsearch.rest.RestStatus;
import org.elasticsearch.rest.action.RestBuilderListener;
import org.elasticsearch.xpack.core.watcher.client.WatcherClient;
import org.elasticsearch.xpack.core.watcher.support.xcontent.WatcherParams;
import org.elasticsearch.xpack.core.watcher.transport.actions.activate.ActivateWatchRequest;
import org.elasticsearch.xpack.core.watcher.transport.actions.activate.ActivateWatchResponse;
import org.elasticsearch.xpack.core.watcher.watch.WatchField;
import org.elasticsearch.xpack.watcher.rest.WatcherRestHandler;

public class RestActivateWatchAction
extends WatcherRestHandler {
    public List<RestHandler.Route> routes() {
        return Collections.emptyList();
    }

    public List<RestHandler.ReplacedRoute> replacedRoutes() {
        return Collections.unmodifiableList(Arrays.asList(new RestHandler.ReplacedRoute(RestRequest.Method.POST, "/_watcher/watch/{id}/_activate", RestRequest.Method.POST, URI_BASE + "/watcher/watch/{id}/_activate"), new RestHandler.ReplacedRoute(RestRequest.Method.PUT, "/_watcher/watch/{id}/_activate", RestRequest.Method.PUT, URI_BASE + "/watcher/watch/{id}/_activate")));
    }

    public String getName() {
        return "watcher_activate_watch";
    }

    @Override
    public BaseRestHandler.RestChannelConsumer doPrepareRequest(RestRequest request, WatcherClient client) {
        String watchId = request.param("id");
        return channel -> client.activateWatch(new ActivateWatchRequest(watchId, true), (ActionListener)new RestBuilderListener<ActivateWatchResponse>(channel){

            public RestResponse buildResponse(ActivateWatchResponse response, XContentBuilder builder) throws Exception {
                return new BytesRestResponse(RestStatus.OK, builder.startObject().field(WatchField.STATUS.getPreferredName(), (ToXContent)response.getStatus(), (ToXContent.Params)WatcherParams.HIDE_SECRETS).endObject());
            }
        });
    }

    public static class DeactivateRestHandler
    extends WatcherRestHandler {
        public List<RestHandler.Route> routes() {
            return Collections.emptyList();
        }

        public List<RestHandler.ReplacedRoute> replacedRoutes() {
            return Collections.unmodifiableList(Arrays.asList(new RestHandler.ReplacedRoute(RestRequest.Method.POST, "/_watcher/watch/{id}/_deactivate", RestRequest.Method.POST, URI_BASE + "/watcher/watch/{id}/_deactivate"), new RestHandler.ReplacedRoute(RestRequest.Method.PUT, "/_watcher/watch/{id}/_deactivate", RestRequest.Method.PUT, URI_BASE + "/watcher/watch/{id}/_deactivate")));
        }

        public String getName() {
            return "watcher_deactivate_watch";
        }

        @Override
        public BaseRestHandler.RestChannelConsumer doPrepareRequest(RestRequest request, WatcherClient client) {
            String watchId = request.param("id");
            return channel -> client.activateWatch(new ActivateWatchRequest(watchId, false), (ActionListener)new RestBuilderListener<ActivateWatchResponse>(channel){

                public RestResponse buildResponse(ActivateWatchResponse response, XContentBuilder builder) throws Exception {
                    return new BytesRestResponse(RestStatus.OK, builder.startObject().field(WatchField.STATUS.getPreferredName(), (ToXContent)response.getStatus(), (ToXContent.Params)WatcherParams.HIDE_SECRETS).endObject());
                }
            });
        }
    }
}

