/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.analytics.aggregations.metrics;

import java.io.IOException;
import java.util.Map;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.search.ScoreMode;
import org.elasticsearch.common.lease.Releasable;
import org.elasticsearch.common.lease.Releasables;
import org.elasticsearch.common.util.BigArrays;
import org.elasticsearch.common.util.DoubleArray;
import org.elasticsearch.index.fielddata.HistogramValue;
import org.elasticsearch.index.fielddata.HistogramValues;
import org.elasticsearch.search.DocValueFormat;
import org.elasticsearch.search.aggregations.Aggregator;
import org.elasticsearch.search.aggregations.InternalAggregation;
import org.elasticsearch.search.aggregations.LeafBucketCollector;
import org.elasticsearch.search.aggregations.LeafBucketCollectorBase;
import org.elasticsearch.search.aggregations.metrics.CompensatedSum;
import org.elasticsearch.search.aggregations.metrics.InternalSum;
import org.elasticsearch.search.aggregations.metrics.NumericMetricsAggregator;
import org.elasticsearch.search.aggregations.support.ValuesSourceConfig;
import org.elasticsearch.search.internal.SearchContext;
import org.elasticsearch.xpack.analytics.aggregations.support.HistogramValuesSource;

public class HistoBackedSumAggregator
extends NumericMetricsAggregator.SingleValue {
    private final HistogramValuesSource.Histogram valuesSource;
    private final DocValueFormat format;
    private DoubleArray sums;
    private DoubleArray compensations;

    public HistoBackedSumAggregator(String name, ValuesSourceConfig valuesSourceConfig, SearchContext context, Aggregator parent, Map<String, Object> metadata) throws IOException {
        super(name, context, parent, metadata);
        this.valuesSource = valuesSourceConfig.hasValues() ? (HistogramValuesSource.Histogram)valuesSourceConfig.getValuesSource() : null;
        this.format = valuesSourceConfig.format();
        if (this.valuesSource != null) {
            this.sums = context.bigArrays().newDoubleArray(1L, true);
            this.compensations = context.bigArrays().newDoubleArray(1L, true);
        }
    }

    public ScoreMode scoreMode() {
        return this.valuesSource != null && this.valuesSource.needsScores() ? ScoreMode.COMPLETE : ScoreMode.COMPLETE_NO_SCORES;
    }

    public LeafBucketCollector getLeafCollector(LeafReaderContext ctx, LeafBucketCollector sub) throws IOException {
        if (this.valuesSource == null) {
            return LeafBucketCollector.NO_OP_COLLECTOR;
        }
        final BigArrays bigArrays = this.context.bigArrays();
        final HistogramValues values = this.valuesSource.getHistogramValues(ctx);
        final CompensatedSum kahanSummation = new CompensatedSum(0.0, 0.0);
        return new LeafBucketCollectorBase(sub, values){

            public void collect(int doc, long bucket) throws IOException {
                HistoBackedSumAggregator.this.sums = bigArrays.grow(HistoBackedSumAggregator.this.sums, bucket + 1L);
                HistoBackedSumAggregator.this.compensations = bigArrays.grow(HistoBackedSumAggregator.this.compensations, bucket + 1L);
                if (values.advanceExact(doc)) {
                    HistogramValue sketch = values.histogram();
                    double sum = HistoBackedSumAggregator.this.sums.get(bucket);
                    double compensation = HistoBackedSumAggregator.this.compensations.get(bucket);
                    kahanSummation.reset(sum, compensation);
                    while (sketch.next()) {
                        double d = sketch.value() * (double)sketch.count();
                        kahanSummation.add(d);
                    }
                    HistoBackedSumAggregator.this.compensations.set(bucket, kahanSummation.delta());
                    HistoBackedSumAggregator.this.sums.set(bucket, kahanSummation.value());
                }
            }
        };
    }

    public double metric(long owningBucketOrd) {
        if (this.valuesSource == null || owningBucketOrd >= this.sums.size()) {
            return 0.0;
        }
        return this.sums.get(owningBucketOrd);
    }

    public InternalAggregation buildAggregation(long bucket) {
        if (this.valuesSource == null || bucket >= this.sums.size()) {
            return this.buildEmptyAggregation();
        }
        return new InternalSum(this.name, this.sums.get(bucket), this.format, this.metadata());
    }

    public InternalAggregation buildEmptyAggregation() {
        return new InternalSum(this.name, 0.0, this.format, this.metadata());
    }

    public void doClose() {
        Releasables.close((Releasable[])new Releasable[]{this.sums, this.compensations});
    }
}

