/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.analytics.boxplot;

import java.io.IOException;
import java.util.Arrays;
import java.util.Map;
import org.elasticsearch.index.query.QueryShardContext;
import org.elasticsearch.search.aggregations.Aggregator;
import org.elasticsearch.search.aggregations.AggregatorFactories;
import org.elasticsearch.search.aggregations.AggregatorFactory;
import org.elasticsearch.search.aggregations.CardinalityUpperBound;
import org.elasticsearch.search.aggregations.support.CoreValuesSourceType;
import org.elasticsearch.search.aggregations.support.ValuesSourceAggregatorFactory;
import org.elasticsearch.search.aggregations.support.ValuesSourceConfig;
import org.elasticsearch.search.aggregations.support.ValuesSourceRegistry;
import org.elasticsearch.search.aggregations.support.ValuesSourceType;
import org.elasticsearch.search.internal.SearchContext;
import org.elasticsearch.xpack.analytics.aggregations.support.AnalyticsValuesSourceType;
import org.elasticsearch.xpack.analytics.boxplot.BoxplotAggregationBuilder;
import org.elasticsearch.xpack.analytics.boxplot.BoxplotAggregator;
import org.elasticsearch.xpack.analytics.boxplot.BoxplotAggregatorSupplier;

public class BoxplotAggregatorFactory
extends ValuesSourceAggregatorFactory {
    private final double compression;

    static void registerAggregators(ValuesSourceRegistry.Builder builder) {
        builder.register(BoxplotAggregationBuilder.REGISTRY_KEY, Arrays.asList(new ValuesSourceType[]{CoreValuesSourceType.NUMERIC, AnalyticsValuesSourceType.HISTOGRAM}), BoxplotAggregator::new, true);
    }

    BoxplotAggregatorFactory(String name, ValuesSourceConfig config, double compression, QueryShardContext queryShardContext, AggregatorFactory parent, AggregatorFactories.Builder subFactoriesBuilder, Map<String, Object> metadata) throws IOException {
        super(name, config, queryShardContext, parent, subFactoriesBuilder, metadata);
        this.compression = compression;
    }

    protected Aggregator createUnmapped(SearchContext searchContext, Aggregator parent, Map<String, Object> metadata) throws IOException {
        return new BoxplotAggregator(this.name, null, this.config.format(), this.compression, searchContext, parent, metadata);
    }

    protected Aggregator doCreateInternal(SearchContext searchContext, Aggregator parent, CardinalityUpperBound cardinality, Map<String, Object> metadata) throws IOException {
        return ((BoxplotAggregatorSupplier)this.queryShardContext.getValuesSourceRegistry().getAggregator(BoxplotAggregationBuilder.REGISTRY_KEY, this.config)).build(this.name, this.config.getValuesSource(), this.config.format(), this.compression, searchContext, parent, metadata);
    }
}

