/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.analytics.rate;

import java.io.IOException;
import java.util.Map;
import java.util.Objects;
import org.elasticsearch.common.ParseField;
import org.elasticsearch.common.Rounding;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.xcontent.ObjectParser;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.index.query.QueryShardContext;
import org.elasticsearch.search.DocValueFormat;
import org.elasticsearch.search.aggregations.AggregationBuilder;
import org.elasticsearch.search.aggregations.AggregatorFactories;
import org.elasticsearch.search.aggregations.AggregatorFactory;
import org.elasticsearch.search.aggregations.bucket.histogram.DateHistogramAggregationBuilder;
import org.elasticsearch.search.aggregations.support.CoreValuesSourceType;
import org.elasticsearch.search.aggregations.support.ValuesSource;
import org.elasticsearch.search.aggregations.support.ValuesSourceAggregationBuilder;
import org.elasticsearch.search.aggregations.support.ValuesSourceConfig;
import org.elasticsearch.search.aggregations.support.ValuesSourceRegistry;
import org.elasticsearch.search.aggregations.support.ValuesSourceType;
import org.elasticsearch.xpack.analytics.rate.RateAggregatorFactory;
import org.elasticsearch.xpack.analytics.rate.RateAggregatorSupplier;

public class RateAggregationBuilder
extends ValuesSourceAggregationBuilder.LeafOnly<ValuesSource.Numeric, RateAggregationBuilder> {
    public static final String NAME = "rate";
    public static final ParseField UNIT_FIELD = new ParseField("unit", new String[0]);
    public static final ValuesSourceRegistry.RegistryKey<RateAggregatorSupplier> REGISTRY_KEY = new ValuesSourceRegistry.RegistryKey("rate", RateAggregatorSupplier.class);
    public static final ObjectParser<RateAggregationBuilder, String> PARSER = ObjectParser.fromBuilder((String)"rate", RateAggregationBuilder::new);
    Rounding.DateTimeUnit rateUnit;

    public static void registerAggregators(ValuesSourceRegistry.Builder builder) {
        RateAggregatorFactory.registerAggregators(builder);
    }

    public RateAggregationBuilder(String name) {
        super(name);
    }

    protected RateAggregationBuilder(RateAggregationBuilder clone, AggregatorFactories.Builder factoriesBuilder, Map<String, Object> metadata) {
        super((ValuesSourceAggregationBuilder.LeafOnly)clone, factoriesBuilder, metadata);
    }

    protected AggregationBuilder shallowCopy(AggregatorFactories.Builder factoriesBuilder, Map<String, Object> metadata) {
        return new RateAggregationBuilder(this, factoriesBuilder, metadata);
    }

    public RateAggregationBuilder(StreamInput in) throws IOException {
        super(in);
        byte b = in.readByte();
        this.rateUnit = b > 0 ? Rounding.DateTimeUnit.resolve((byte)b) : null;
    }

    protected ValuesSourceType defaultValueSourceType() {
        return CoreValuesSourceType.NUMERIC;
    }

    protected void innerWriteTo(StreamOutput out) throws IOException {
        if (this.rateUnit != null) {
            out.writeByte(this.rateUnit.getId());
        } else {
            out.writeByte((byte)0);
        }
    }

    protected ValuesSourceRegistry.RegistryKey<?> getRegistryKey() {
        return REGISTRY_KEY;
    }

    protected RateAggregatorFactory innerBuild(QueryShardContext queryShardContext, ValuesSourceConfig config, AggregatorFactory parent, AggregatorFactories.Builder subFactoriesBuilder) throws IOException {
        return new RateAggregatorFactory(this.name, config, this.rateUnit, queryShardContext, parent, subFactoriesBuilder, this.metadata);
    }

    public XContentBuilder doXContentBody(XContentBuilder builder, ToXContent.Params params) throws IOException {
        if (this.rateUnit != null) {
            builder.field(UNIT_FIELD.getPreferredName(), this.rateUnit.shortName());
        }
        return builder;
    }

    public String getType() {
        return NAME;
    }

    public RateAggregationBuilder rateUnit(String rateUnit) {
        return this.rateUnit(RateAggregationBuilder.parse(rateUnit));
    }

    public RateAggregationBuilder rateUnit(Rounding.DateTimeUnit rateUnit) {
        this.rateUnit = rateUnit;
        return this;
    }

    static Rounding.DateTimeUnit parse(String rateUnit) {
        Rounding.DateTimeUnit parsedRate = (Rounding.DateTimeUnit)DateHistogramAggregationBuilder.DATE_FIELD_UNITS.get(rateUnit);
        if (parsedRate == null) {
            throw new IllegalArgumentException("Unsupported unit " + rateUnit);
        }
        return parsedRate;
    }

    protected ValuesSourceConfig resolveConfig(QueryShardContext queryShardContext) {
        if (this.field() == null && this.script() == null) {
            return new ValuesSourceConfig((ValuesSourceType)CoreValuesSourceType.NUMERIC, null, true, null, null, (Object)1.0, null, DocValueFormat.RAW, () -> ((QueryShardContext)queryShardContext).nowInMillis());
        }
        return super.resolveConfig(queryShardContext);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        RateAggregationBuilder that = (RateAggregationBuilder)((Object)o);
        return this.rateUnit == that.rateUnit;
    }

    public int hashCode() {
        return Objects.hash(super.hashCode(), this.rateUnit);
    }

    static {
        ValuesSourceAggregationBuilder.declareFields(PARSER, (boolean)true, (boolean)true, (boolean)false, (boolean)false);
        PARSER.declareString(RateAggregationBuilder::rateUnit, UNIT_FIELD);
    }
}

