/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.analytics.rate;

import java.io.IOException;
import java.util.Arrays;
import java.util.Map;
import org.apache.lucene.index.LeafReaderContext;
import org.elasticsearch.common.Rounding;
import org.elasticsearch.index.query.QueryShardContext;
import org.elasticsearch.search.aggregations.Aggregator;
import org.elasticsearch.search.aggregations.AggregatorFactories;
import org.elasticsearch.search.aggregations.AggregatorFactory;
import org.elasticsearch.search.aggregations.CardinalityUpperBound;
import org.elasticsearch.search.aggregations.LeafBucketCollector;
import org.elasticsearch.search.aggregations.support.CoreValuesSourceType;
import org.elasticsearch.search.aggregations.support.ValuesSourceAggregatorFactory;
import org.elasticsearch.search.aggregations.support.ValuesSourceConfig;
import org.elasticsearch.search.aggregations.support.ValuesSourceRegistry;
import org.elasticsearch.search.internal.SearchContext;
import org.elasticsearch.xpack.analytics.rate.RateAggregationBuilder;
import org.elasticsearch.xpack.analytics.rate.RateAggregator;
import org.elasticsearch.xpack.analytics.rate.RateAggregatorSupplier;

class RateAggregatorFactory
extends ValuesSourceAggregatorFactory {
    private final Rounding.DateTimeUnit rateUnit;

    RateAggregatorFactory(String name, ValuesSourceConfig config, Rounding.DateTimeUnit rateUnit, QueryShardContext queryShardContext, AggregatorFactory parent, AggregatorFactories.Builder subFactoriesBuilder, Map<String, Object> metadata) throws IOException {
        super(name, config, queryShardContext, parent, subFactoriesBuilder, metadata);
        this.rateUnit = rateUnit;
    }

    static void registerAggregators(ValuesSourceRegistry.Builder builder) {
        builder.register(RateAggregationBuilder.REGISTRY_KEY, Arrays.asList(CoreValuesSourceType.NUMERIC, CoreValuesSourceType.BOOLEAN), RateAggregator::new, true);
    }

    protected Aggregator createUnmapped(SearchContext searchContext, Aggregator parent, Map<String, Object> metadata) throws IOException {
        return new RateAggregator(this.name, this.config, this.rateUnit, searchContext, parent, metadata){

            @Override
            public LeafBucketCollector getLeafCollector(LeafReaderContext ctx, LeafBucketCollector sub) {
                return LeafBucketCollector.NO_OP_COLLECTOR;
            }
        };
    }

    protected Aggregator doCreateInternal(SearchContext searchContext, Aggregator parent, CardinalityUpperBound bucketCardinality, Map<String, Object> metadata) throws IOException {
        return ((RateAggregatorSupplier)this.queryShardContext.getValuesSourceRegistry().getAggregator(RateAggregationBuilder.REGISTRY_KEY, this.config)).build(this.name, this.config, this.rateUnit, searchContext, parent, metadata);
    }
}

