/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.analytics.ttest;

import java.io.IOException;
import java.util.Map;
import org.apache.lucene.index.LeafReaderContext;
import org.elasticsearch.common.lease.Releasable;
import org.elasticsearch.common.lease.Releasables;
import org.elasticsearch.common.util.BigArrays;
import org.elasticsearch.index.fielddata.SortedNumericDoubleValues;
import org.elasticsearch.search.DocValueFormat;
import org.elasticsearch.search.aggregations.AggregationExecutionException;
import org.elasticsearch.search.aggregations.Aggregator;
import org.elasticsearch.search.aggregations.LeafBucketCollector;
import org.elasticsearch.search.aggregations.LeafBucketCollectorBase;
import org.elasticsearch.search.aggregations.metrics.CompensatedSum;
import org.elasticsearch.search.aggregations.support.MultiValuesSource;
import org.elasticsearch.search.internal.SearchContext;
import org.elasticsearch.xpack.analytics.ttest.PairedTTestState;
import org.elasticsearch.xpack.analytics.ttest.TTestAggregationBuilder;
import org.elasticsearch.xpack.analytics.ttest.TTestAggregator;
import org.elasticsearch.xpack.analytics.ttest.TTestStats;
import org.elasticsearch.xpack.analytics.ttest.TTestStatsBuilder;

public class PairedTTestAggregator
extends TTestAggregator<PairedTTestState> {
    private TTestStatsBuilder statsBuilder;

    PairedTTestAggregator(String name, MultiValuesSource.NumericMultiValuesSource valuesSources, int tails, DocValueFormat format, SearchContext context, Aggregator parent, Map<String, Object> metadata) throws IOException {
        super(name, valuesSources, tails, format, context, parent, metadata);
        this.statsBuilder = new TTestStatsBuilder(context.bigArrays());
    }

    @Override
    protected PairedTTestState getState(long bucket) {
        return new PairedTTestState(this.statsBuilder.get(bucket), this.tails);
    }

    @Override
    protected PairedTTestState getEmptyState() {
        return new PairedTTestState(new TTestStats(0L, 0.0, 0.0), this.tails);
    }

    @Override
    protected long size() {
        return this.statsBuilder.getSize();
    }

    public LeafBucketCollector getLeafCollector(LeafReaderContext ctx, LeafBucketCollector sub) throws IOException {
        if (this.valuesSources == null) {
            return LeafBucketCollector.NO_OP_COLLECTOR;
        }
        final BigArrays bigArrays = this.context.bigArrays();
        final SortedNumericDoubleValues docAValues = this.valuesSources.getField(TTestAggregationBuilder.A_FIELD.getPreferredName(), ctx);
        final SortedNumericDoubleValues docBValues = this.valuesSources.getField(TTestAggregationBuilder.B_FIELD.getPreferredName(), ctx);
        final CompensatedSum compDiffSum = new CompensatedSum(0.0, 0.0);
        final CompensatedSum compDiffSumOfSqr = new CompensatedSum(0.0, 0.0);
        return new LeafBucketCollectorBase(sub, docAValues){

            public void collect(int doc, long bucket) throws IOException {
                if (docAValues.advanceExact(doc) && docBValues.advanceExact(doc)) {
                    if (docAValues.docValueCount() > 1 || docBValues.docValueCount() > 1) {
                        throw new AggregationExecutionException("Encountered more than one value for a single document. Use a script to combine multiple values per doc into a single value.");
                    }
                    PairedTTestAggregator.this.statsBuilder.grow(bigArrays, bucket + 1L);
                    assert (docAValues.docValueCount() == 1);
                    assert (docBValues.docValueCount() == 1);
                    double diff = docAValues.nextValue() - docBValues.nextValue();
                    PairedTTestAggregator.this.statsBuilder.addValue(compDiffSum, compDiffSumOfSqr, bucket, diff);
                }
            }
        };
    }

    public void doClose() {
        Releasables.close((Releasable)this.statsBuilder);
    }
}

