/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.analytics.ttest;

import java.io.IOException;
import java.util.Map;
import org.apache.lucene.search.ScoreMode;
import org.elasticsearch.search.DocValueFormat;
import org.elasticsearch.search.aggregations.Aggregator;
import org.elasticsearch.search.aggregations.InternalAggregation;
import org.elasticsearch.search.aggregations.metrics.NumericMetricsAggregator;
import org.elasticsearch.search.aggregations.support.MultiValuesSource;
import org.elasticsearch.search.internal.SearchContext;
import org.elasticsearch.xpack.analytics.ttest.InternalTTest;
import org.elasticsearch.xpack.analytics.ttest.TTestState;

public abstract class TTestAggregator<T extends TTestState>
extends NumericMetricsAggregator.SingleValue {
    protected final MultiValuesSource.NumericMultiValuesSource valuesSources;
    protected final int tails;
    private DocValueFormat format;

    TTestAggregator(String name, MultiValuesSource.NumericMultiValuesSource valuesSources, int tails, DocValueFormat format, SearchContext context, Aggregator parent, Map<String, Object> metadata) throws IOException {
        super(name, context, parent, metadata);
        this.valuesSources = valuesSources;
        this.tails = tails;
        this.format = format;
    }

    public ScoreMode scoreMode() {
        return this.valuesSources != null && this.valuesSources.needsScores() ? ScoreMode.COMPLETE : ScoreMode.COMPLETE_NO_SCORES;
    }

    protected abstract T getState(long var1);

    protected abstract T getEmptyState();

    protected abstract long size();

    public InternalAggregation buildAggregation(long bucket) {
        if (this.valuesSources == null || bucket >= this.size()) {
            return this.buildEmptyAggregation();
        }
        return new InternalTTest(this.name, (TTestState)this.getState(bucket), this.format, this.metadata());
    }

    public InternalAggregation buildEmptyAggregation() {
        return new InternalTTest(this.name, (TTestState)this.getEmptyState(), this.format, this.metadata());
    }

    public double metric(long owningBucketOrd) {
        return this.getState(owningBucketOrd).getValue();
    }
}

