/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.ql.execution.search.extractor;

import java.io.IOException;
import java.time.ZoneId;
import java.util.ArrayDeque;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.StringJoiner;
import org.elasticsearch.Version;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.collect.Tuple;
import org.elasticsearch.common.document.DocumentField;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.index.mapper.NumberFieldMapper;
import org.elasticsearch.search.SearchHit;
import org.elasticsearch.xpack.ql.QlIllegalArgumentException;
import org.elasticsearch.xpack.ql.execution.search.extractor.HitExtractor;
import org.elasticsearch.xpack.ql.type.DataType;
import org.elasticsearch.xpack.ql.type.DataTypes;

public abstract class AbstractFieldHitExtractor
implements HitExtractor {
    private static final Version SWITCHED_FROM_DOCVALUES_TO_SOURCE_EXTRACTION = Version.V_7_4_0;
    private final String fieldName;
    private final String hitName;
    private final String fullFieldName;
    private final DataType dataType;
    private final ZoneId zoneId;
    private final boolean useDocValue;
    private final boolean arrayLeniency;
    private final String[] path;

    private static String[] sourcePath(String name, boolean useDocValue, String hitName) {
        return useDocValue ? Strings.EMPTY_ARRAY : Strings.tokenizeToStringArray((String)(hitName == null ? name : name.substring(hitName.length() + 1)), (String)".");
    }

    protected AbstractFieldHitExtractor(String name, DataType dataType, ZoneId zoneId, boolean useDocValue) {
        this(name, null, dataType, zoneId, useDocValue, null, false);
    }

    protected AbstractFieldHitExtractor(String name, DataType dataType, ZoneId zoneId, boolean useDocValue, boolean arrayLeniency) {
        this(name, null, dataType, zoneId, useDocValue, null, arrayLeniency);
    }

    protected AbstractFieldHitExtractor(String name, String fullFieldName, DataType dataType, ZoneId zoneId, boolean useDocValue, String hitName, boolean arrayLeniency) {
        this.fieldName = name;
        this.fullFieldName = fullFieldName;
        this.dataType = dataType;
        this.zoneId = zoneId;
        this.useDocValue = useDocValue;
        this.arrayLeniency = arrayLeniency;
        this.hitName = hitName;
        if (hitName != null && !name.contains(hitName)) {
            throw new QlIllegalArgumentException("Hitname [{}] specified but not part of the name [{}]", hitName, name);
        }
        this.path = AbstractFieldHitExtractor.sourcePath(this.fieldName, useDocValue, hitName);
    }

    protected AbstractFieldHitExtractor(StreamInput in) throws IOException {
        this.fieldName = in.readString();
        this.fullFieldName = in.getVersion().onOrAfter(SWITCHED_FROM_DOCVALUES_TO_SOURCE_EXTRACTION) ? in.readOptionalString() : null;
        String typeName = in.readOptionalString();
        this.dataType = typeName != null ? this.loadTypeFromName(typeName) : null;
        this.useDocValue = in.readBoolean();
        this.hitName = in.readOptionalString();
        this.arrayLeniency = in.readBoolean();
        this.path = AbstractFieldHitExtractor.sourcePath(this.fieldName, this.useDocValue, this.hitName);
        this.zoneId = this.readZoneId(in);
    }

    protected DataType loadTypeFromName(String typeName) {
        return DataTypes.fromTypeName(typeName);
    }

    protected abstract ZoneId readZoneId(StreamInput var1) throws IOException;

    public void writeTo(StreamOutput out) throws IOException {
        out.writeString(this.fieldName);
        if (out.getVersion().onOrAfter(SWITCHED_FROM_DOCVALUES_TO_SOURCE_EXTRACTION)) {
            out.writeOptionalString(this.fullFieldName);
        }
        out.writeOptionalString(this.dataType == null ? null : this.dataType.typeName());
        out.writeBoolean(this.useDocValue);
        out.writeOptionalString(this.hitName);
        out.writeBoolean(this.arrayLeniency);
    }

    @Override
    public Object extract(SearchHit hit) {
        Object value = null;
        if (this.useDocValue) {
            DocumentField field = hit.field(this.fieldName);
            if (field != null) {
                value = this.unwrapMultiValue(field.getValues());
            }
        } else {
            if (this.fullFieldName != null && hit.getFields().containsKey("_ignored") && !this.isFromDocValuesOnly(this.dataType) && ((DocumentField)hit.getFields().get("_ignored")).getValues().contains(this.fullFieldName)) {
                return null;
            }
            Map source = hit.getSourceAsMap();
            if (source != null) {
                value = this.extractFromSource(source);
            }
        }
        return value;
    }

    protected Object unwrapMultiValue(Object values) {
        Object unwrapped;
        if (values == null) {
            return null;
        }
        if (values instanceof List) {
            List list = (List)values;
            if (list.isEmpty()) {
                return null;
            }
            if (!this.isPrimitive(list)) {
                if (list.size() == 1 || this.arrayLeniency) {
                    return this.unwrapMultiValue(list.get(0));
                }
                throw new QlIllegalArgumentException("Arrays (returned by [{}]) are not supported", this.fieldName);
            }
        }
        if ((unwrapped = this.unwrapCustomValue(values)) != null) {
            return unwrapped;
        }
        if (values instanceof Number || values instanceof String || values instanceof Boolean) {
            if (this.dataType == null) {
                return values;
            }
            if (this.dataType.isNumeric() && !this.isFromDocValuesOnly(this.dataType)) {
                if (this.dataType == DataTypes.DOUBLE || this.dataType == DataTypes.FLOAT || this.dataType == DataTypes.HALF_FLOAT) {
                    Number result = null;
                    try {
                        result = AbstractFieldHitExtractor.numberType(this.dataType).parse(values, true);
                    }
                    catch (IllegalArgumentException iae) {
                        return null;
                    }
                    return result.doubleValue();
                }
                Number result = null;
                try {
                    result = AbstractFieldHitExtractor.numberType(this.dataType).parse(values, true);
                }
                catch (IllegalArgumentException iae) {
                    return null;
                }
                return result;
            }
            if (DataTypes.isString(this.dataType) || this.dataType == DataTypes.IP) {
                return values.toString();
            }
            return values;
        }
        throw new QlIllegalArgumentException("Type {} (returned by [{}]) is not supported", values.getClass().getSimpleName(), this.fieldName);
    }

    protected boolean isFromDocValuesOnly(DataType dataType) {
        return dataType == DataTypes.KEYWORD || dataType == DataTypes.DATETIME || dataType == DataTypes.CONSTANT_KEYWORD || dataType == DataTypes.SCALED_FLOAT;
    }

    private static NumberFieldMapper.NumberType numberType(DataType dataType) {
        return NumberFieldMapper.NumberType.valueOf((String)dataType.esType().toUpperCase(Locale.ROOT));
    }

    protected abstract Object unwrapCustomValue(Object var1);

    protected abstract boolean isPrimitive(List<?> var1);

    public Object extractFromSource(Map<String, Object> map) {
        Object value = null;
        ArrayDeque<Tuple> queue = new ArrayDeque<Tuple>();
        queue.add(new Tuple((Object)-1, map));
        while (!queue.isEmpty()) {
            Tuple tuple = (Tuple)queue.removeLast();
            int idx = (Integer)tuple.v1();
            Map subMap = (Map)tuple.v2();
            StringJoiner sj = new StringJoiner(".");
            for (int i = idx + 1; i < this.path.length; ++i) {
                sj.add(this.path[i]);
                Object node = subMap.get(sj.toString());
                if (node instanceof List) {
                    List listOfValues = (List)node;
                    if (i < this.path.length - 1 && (listOfValues.size() == 1 || this.arrayLeniency)) {
                        node = listOfValues.get(0);
                    } else {
                        return this.unwrapMultiValue(node);
                    }
                }
                if (node instanceof Map) {
                    if (i < this.path.length - 1) {
                        queue.add(new Tuple((Object)i, (Object)((Map)node)));
                        continue;
                    }
                    value = node;
                    continue;
                }
                if (node == null) continue;
                if (i < this.path.length - 1) {
                    throw new QlIllegalArgumentException("Cannot extract value [{}] from source", this.fieldName);
                }
                if (value != null) {
                    throw new QlIllegalArgumentException("Multiple values (returned by [{}]) are not supported", this.fieldName);
                }
                value = node;
            }
        }
        return this.unwrapMultiValue(value);
    }

    @Override
    public String hitName() {
        return this.hitName;
    }

    public String fieldName() {
        return this.fieldName;
    }

    public String fullFieldName() {
        return this.fullFieldName;
    }

    public ZoneId zoneId() {
        return this.zoneId;
    }

    public DataType dataType() {
        return this.dataType;
    }

    public boolean useDocValues() {
        return this.useDocValue;
    }

    public boolean arrayLeniency() {
        return this.arrayLeniency;
    }

    public String toString() {
        return this.fieldName + "@" + this.hitName + "@" + this.zoneId;
    }

    public boolean equals(Object obj) {
        if (obj == null || obj.getClass() != this.getClass()) {
            return false;
        }
        AbstractFieldHitExtractor other = (AbstractFieldHitExtractor)obj;
        return this.fieldName.equals(other.fieldName) && this.hitName.equals(other.hitName) && this.useDocValue == other.useDocValue && this.arrayLeniency == other.arrayLeniency;
    }

    public int hashCode() {
        return Objects.hash(this.fieldName, this.useDocValue, this.hitName, this.arrayLeniency);
    }
}

