/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.ql.expression.function;

import java.util.List;
import org.elasticsearch.common.logging.LoggerMessageFormat;
import org.elasticsearch.xpack.ql.expression.function.Function;
import org.elasticsearch.xpack.ql.expression.function.UnresolvedFunction;
import org.elasticsearch.xpack.ql.session.Configuration;

public class FunctionDefinition {
    private final String name;
    private final List<String> aliases;
    private final Class<? extends Function> clazz;
    private final boolean extractViable;
    private final Builder builder;

    FunctionDefinition(String name, List<String> aliases, Class<? extends Function> clazz, boolean datetime, Builder builder) {
        this.name = name;
        this.aliases = aliases;
        this.clazz = clazz;
        this.extractViable = datetime;
        this.builder = builder;
    }

    public String name() {
        return this.name;
    }

    public List<String> aliases() {
        return this.aliases;
    }

    public Class<? extends Function> clazz() {
        return this.clazz;
    }

    Builder builder() {
        return this.builder;
    }

    boolean extractViable() {
        return this.extractViable;
    }

    public String toString() {
        return LoggerMessageFormat.format(null, (String)"{}({})", (Object[])new Object[]{this.name, this.aliases.isEmpty() ? "" : (this.aliases.size() == 1 ? this.aliases.get(0) : this.aliases)});
    }

    @FunctionalInterface
    public static interface Builder {
        public Function build(UnresolvedFunction var1, boolean var2, Configuration var3);
    }
}

