/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.ql.expression.function;

import java.time.ZoneId;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.function.BiFunction;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.elasticsearch.common.Strings;
import org.elasticsearch.xpack.ql.ParsingException;
import org.elasticsearch.xpack.ql.QlIllegalArgumentException;
import org.elasticsearch.xpack.ql.expression.Expression;
import org.elasticsearch.xpack.ql.expression.function.Function;
import org.elasticsearch.xpack.ql.expression.function.FunctionDefinition;
import org.elasticsearch.xpack.ql.expression.function.OptionalArgument;
import org.elasticsearch.xpack.ql.session.Configuration;
import org.elasticsearch.xpack.ql.tree.Source;
import org.elasticsearch.xpack.ql.type.DataType;
import org.elasticsearch.xpack.ql.util.Check;

public class FunctionRegistry {
    private static final String[] NUM_NAMES = new String[]{"zero", "one", "two", "three", "four", "five"};
    private final Map<String, FunctionDefinition> defs = new LinkedHashMap<String, FunctionDefinition>();
    private final Map<String, String> aliases = new HashMap<String, String>();

    public FunctionRegistry() {
    }

    public FunctionRegistry(FunctionDefinition ... functions) {
        this.register(functions);
    }

    public FunctionRegistry(FunctionDefinition[] ... groupFunctions) {
        for (FunctionDefinition[] group : groupFunctions) {
            this.register(group);
        }
    }

    protected void register(FunctionDefinition ... functions) {
        HashMap<String, FunctionDefinition> batchMap = new HashMap<String, FunctionDefinition>();
        for (FunctionDefinition f : functions) {
            batchMap.put(f.name(), f);
            for (String alias : f.aliases()) {
                FunctionDefinition old = batchMap.put(alias, f);
                if (old != null || this.defs.containsKey(alias)) {
                    throw new QlIllegalArgumentException("alias [" + alias + "] is used by [" + (old != null ? old : this.defs.get(alias).name()) + "] and [" + f.name() + "]");
                }
                this.aliases.put(alias, f.name());
            }
        }
        this.defs.putAll(batchMap.entrySet().stream().sorted(Map.Entry.comparingByKey()).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue, (oldValue, newValue) -> oldValue, LinkedHashMap::new)));
    }

    public FunctionDefinition resolveFunction(String functionName) {
        FunctionDefinition def = this.defs.get(functionName);
        if (def == null) {
            throw new QlIllegalArgumentException("Cannot find function {}; this should have been caught during analysis", functionName);
        }
        return def;
    }

    protected String normalize(String name) {
        return name.toUpperCase(Locale.ROOT);
    }

    public String resolveAlias(String alias) {
        String normalized = this.normalize(alias);
        return this.aliases.getOrDefault(normalized, normalized);
    }

    public boolean functionExists(String functionName) {
        return this.defs.containsKey(functionName);
    }

    public Collection<FunctionDefinition> listFunctions() {
        return this.defs.values();
    }

    public Collection<FunctionDefinition> listFunctions(String pattern) {
        Pattern p = Strings.hasText((String)pattern) ? Pattern.compile(this.normalize(pattern)) : null;
        return this.defs.entrySet().stream().filter(e -> p == null || p.matcher((CharSequence)e.getKey()).matches()).map(e -> new FunctionDefinition((String)e.getKey(), Collections.emptyList(), ((FunctionDefinition)e.getValue()).clazz(), ((FunctionDefinition)e.getValue()).extractViable(), ((FunctionDefinition)e.getValue()).builder())).collect(Collectors.toList());
    }

    protected static <T extends Function> FunctionDefinition def(Class<T> function, java.util.function.Function<Source, T> ctorRef, String ... names) {
        FunctionBuilder builder = (source, children, distinct, cfg) -> {
            if (!children.isEmpty()) {
                throw new QlIllegalArgumentException("expects no arguments");
            }
            if (distinct) {
                throw new QlIllegalArgumentException("does not support DISTINCT yet it was specified");
            }
            return (Function)ctorRef.apply(source);
        };
        return FunctionRegistry.def(function, builder, false, names);
    }

    protected static <T extends Function> FunctionDefinition def(Class<T> function, ConfigurationAwareFunctionBuilder<T> ctorRef, String ... names) {
        FunctionBuilder builder = (source, children, distinct, cfg) -> {
            if (!children.isEmpty()) {
                throw new QlIllegalArgumentException("expects no arguments");
            }
            if (distinct) {
                throw new QlIllegalArgumentException("does not support DISTINCT yet it was specified");
            }
            return (Function)ctorRef.build(source, cfg);
        };
        return FunctionRegistry.def(function, builder, false, names);
    }

    protected static <T extends Function> FunctionDefinition def(Class<T> function, UnaryConfigurationAwareFunctionBuilder<T> ctorRef, String ... names) {
        FunctionBuilder builder = (source, children, distinct, cfg) -> {
            if (children.size() > 1) {
                throw new QlIllegalArgumentException("expects exactly one argument");
            }
            if (distinct) {
                throw new QlIllegalArgumentException("does not support DISTINCT yet it was specified");
            }
            Expression ex = children.size() == 1 ? (Expression)children.get(0) : null;
            return (Function)ctorRef.build(source, ex, cfg);
        };
        return FunctionRegistry.def(function, builder, false, names);
    }

    protected static <T extends Function> FunctionDefinition def(Class<T> function, BiFunction<Source, Expression, T> ctorRef, String ... names) {
        FunctionBuilder builder = (source, children, distinct, cfg) -> {
            if (children.size() != 1) {
                throw new QlIllegalArgumentException("expects exactly one argument");
            }
            if (distinct) {
                throw new QlIllegalArgumentException("does not support DISTINCT yet it was specified");
            }
            return (Function)ctorRef.apply(source, (Expression)children.get(0));
        };
        return FunctionRegistry.def(function, builder, false, names);
    }

    public static <T extends Function> FunctionDefinition def(Class<T> function, MultiFunctionBuilder<T> ctorRef, String ... names) {
        FunctionBuilder builder = (source, children, distinct, cfg) -> {
            if (distinct) {
                throw new QlIllegalArgumentException("does not support DISTINCT yet it was specified");
            }
            return (Function)ctorRef.build(source, children);
        };
        return FunctionRegistry.def(function, builder, false, names);
    }

    public static <T extends Function> FunctionDefinition def(Class<T> function, DistinctAwareUnaryFunctionBuilder<T> ctorRef, String ... names) {
        FunctionBuilder builder = (source, children, distinct, cfg) -> {
            if (children.size() != 1) {
                throw new QlIllegalArgumentException("expects exactly one argument");
            }
            return (Function)ctorRef.build(source, (Expression)children.get(0), distinct);
        };
        return FunctionRegistry.def(function, builder, false, names);
    }

    public static <T extends Function> FunctionDefinition def(Class<T> function, DatetimeUnaryFunctionBuilder<T> ctorRef, String ... names) {
        FunctionBuilder builder = (source, children, distinct, cfg) -> {
            if (children.size() != 1) {
                throw new QlIllegalArgumentException("expects exactly one argument");
            }
            if (distinct) {
                throw new QlIllegalArgumentException("does not support DISTINCT yet it was specified");
            }
            return (Function)ctorRef.build(source, (Expression)children.get(0), cfg.zoneId());
        };
        return FunctionRegistry.def(function, builder, true, names);
    }

    public static <T extends Function> FunctionDefinition def(Class<T> function, DatetimeBinaryFunctionBuilder<T> ctorRef, String ... names) {
        FunctionBuilder builder = (source, children, distinct, cfg) -> {
            if (children.size() != 2) {
                throw new QlIllegalArgumentException("expects exactly two arguments");
            }
            if (distinct) {
                throw new QlIllegalArgumentException("does not support DISTINCT yet it was specified");
            }
            return (Function)ctorRef.build(source, (Expression)children.get(0), (Expression)children.get(1), cfg.zoneId());
        };
        return FunctionRegistry.def(function, builder, false, names);
    }

    public static <T extends Function> FunctionDefinition def(Class<T> function, DatetimeThreeArgsFunctionBuilder<T> ctorRef, String ... names) {
        FunctionBuilder builder = (source, children, distinct, cfg) -> {
            if (children.size() != 3) {
                throw new QlIllegalArgumentException("expects three arguments");
            }
            if (distinct) {
                throw new QlIllegalArgumentException("does not support DISTINCT yet it was specified");
            }
            return (Function)ctorRef.build(source, (Expression)children.get(0), (Expression)children.get(1), (Expression)children.get(2), cfg.zoneId());
        };
        return FunctionRegistry.def(function, builder, false, names);
    }

    public static <T extends Function> FunctionDefinition def(Class<T> function, BinaryFunctionBuilder<T> ctorRef, String ... names) {
        FunctionBuilder builder = (source, children, distinct, cfg) -> {
            boolean isBinaryOptionalParamFunction = OptionalArgument.class.isAssignableFrom(function);
            if (isBinaryOptionalParamFunction && (children.size() > 2 || children.size() < 1)) {
                throw new QlIllegalArgumentException("expects one or two arguments");
            }
            if (!isBinaryOptionalParamFunction && children.size() != 2) {
                throw new QlIllegalArgumentException("expects exactly two arguments");
            }
            if (distinct) {
                throw new QlIllegalArgumentException("does not support DISTINCT yet it was specified");
            }
            return (Function)ctorRef.build(source, (Expression)children.get(0), children.size() == 2 ? (Expression)children.get(1) : null);
        };
        return FunctionRegistry.def(function, builder, false, names);
    }

    public static FunctionDefinition def(Class<? extends Function> function, FunctionBuilder builder, boolean datetime, String ... names) {
        Check.isTrue(names.length > 0, "At least one name must be provided for the function");
        String primaryName = names[0];
        List<String> aliases = Arrays.asList(names).subList(1, names.length);
        FunctionDefinition.Builder realBuilder = (uf, distinct, cfg) -> {
            try {
                return builder.build(uf.source(), uf.children(), distinct, cfg);
            }
            catch (QlIllegalArgumentException e) {
                throw new ParsingException(uf.source(), "error building [" + primaryName + "]: " + e.getMessage(), new Object[]{e});
            }
        };
        return new FunctionDefinition(primaryName, Collections.unmodifiableList(aliases), function, datetime, realBuilder);
    }

    public static <T extends Function> FunctionDefinition def(Class<T> function, ThreeParametersFunctionBuilder<T> ctorRef, String ... names) {
        FunctionBuilder builder = (source, children, distinct, cfg) -> {
            boolean hasMinimumTwo = OptionalArgument.class.isAssignableFrom(function);
            if (hasMinimumTwo && (children.size() > 3 || children.size() < 2)) {
                throw new QlIllegalArgumentException("expects two or three arguments");
            }
            if (!hasMinimumTwo && children.size() != 3) {
                throw new QlIllegalArgumentException("expects exactly three arguments");
            }
            if (distinct) {
                throw new QlIllegalArgumentException("does not support DISTINCT yet it was specified");
            }
            return (Function)ctorRef.build(source, (Expression)children.get(0), (Expression)children.get(1), children.size() == 3 ? (Expression)children.get(2) : null);
        };
        return FunctionRegistry.def(function, builder, false, names);
    }

    public static <T extends Function> FunctionDefinition def(Class<T> function, ScalarTriFunctionConfigurationAwareBuilder<T> ctorRef, String ... names) {
        FunctionBuilder builder = (source, children, distinct, cfg) -> {
            boolean hasMinimumTwo = OptionalArgument.class.isAssignableFrom(function);
            if (hasMinimumTwo && (children.size() > 3 || children.size() < 2)) {
                throw new QlIllegalArgumentException("expects two or three arguments");
            }
            if (!hasMinimumTwo && children.size() != 3) {
                throw new QlIllegalArgumentException("expects exactly three arguments");
            }
            if (distinct) {
                throw new QlIllegalArgumentException("does not support DISTINCT yet it was specified");
            }
            return (Function)ctorRef.build(source, (Expression)children.get(0), (Expression)children.get(1), children.size() == 3 ? (Expression)children.get(2) : null, cfg);
        };
        return FunctionRegistry.def(function, builder, false, names);
    }

    public static <T extends Function> FunctionDefinition def(Class<T> function, FourParametersFunctionBuilder<T> ctorRef, String ... names) {
        FunctionBuilder builder = (source, children, distinct, cfg) -> {
            boolean hasMinimumThree = OptionalArgument.class.isAssignableFrom(function);
            if (hasMinimumThree && (children.size() > 4 || children.size() < 3)) {
                throw new QlIllegalArgumentException("expects three or four arguments");
            }
            if (!hasMinimumThree && children.size() != 4) {
                throw new QlIllegalArgumentException("expects exactly four arguments");
            }
            if (distinct) {
                throw new QlIllegalArgumentException("does not support DISTINCT yet it was specified");
            }
            return (Function)ctorRef.build(source, (Expression)children.get(0), (Expression)children.get(1), (Expression)children.get(2), children.size() == 4 ? (Expression)children.get(3) : null);
        };
        return FunctionRegistry.def(function, builder, false, names);
    }

    public static <T extends Function> FunctionDefinition def(Class<T> function, FiveParametersFunctionBuilder<T> ctorRef, int numOptionalParams, String ... names) {
        FunctionBuilder builder = (source, children, distinct, cfg) -> {
            int NUM_TOTAL_PARAMS = 5;
            boolean hasOptionalParams = OptionalArgument.class.isAssignableFrom(function);
            if (hasOptionalParams && (children.size() > 5 || children.size() < 5 - numOptionalParams)) {
                throw new QlIllegalArgumentException("expects between " + NUM_NAMES[5 - numOptionalParams] + " and " + NUM_NAMES[5] + " arguments");
            }
            if (!hasOptionalParams && children.size() != 5) {
                throw new QlIllegalArgumentException("expects exactly " + NUM_NAMES[5] + " arguments");
            }
            if (distinct) {
                throw new QlIllegalArgumentException("does not support DISTINCT yet it was specified");
            }
            return (Function)ctorRef.build(source, children.size() > 0 ? (Expression)children.get(0) : null, children.size() > 1 ? (Expression)children.get(1) : null, children.size() > 2 ? (Expression)children.get(2) : null, children.size() > 3 ? (Expression)children.get(3) : null, children.size() > 4 ? (Expression)children.get(4) : null);
        };
        return FunctionRegistry.def(function, builder, false, names);
    }

    public static <T extends Function> FunctionDefinition def(Class<T> function, CastFunctionBuilder<T> ctorRef, String ... names) {
        FunctionBuilder builder = (source, children, distinct, cfg) -> (Function)ctorRef.build(source, (Expression)children.get(0), ((Expression)children.get(0)).dataType());
        return FunctionRegistry.def(function, builder, false, names);
    }

    public static <T extends Function> FunctionDefinition def(Class<T> function, TwoParametersVariadicBuilder<T> ctorRef, String ... names) {
        FunctionBuilder builder = (source, children, distinct, cfg) -> {
            boolean hasMinimumOne = OptionalArgument.class.isAssignableFrom(function);
            if (hasMinimumOne && children.size() < 1) {
                throw new QlIllegalArgumentException("expects at least one argument");
            }
            if (!hasMinimumOne && children.size() < 2) {
                throw new QlIllegalArgumentException("expects at least two arguments");
            }
            if (distinct) {
                throw new QlIllegalArgumentException("does not support DISTINCT yet it was specified");
            }
            return (Function)ctorRef.build(source, (Expression)children.get(0), children.subList(1, children.size()));
        };
        return FunctionRegistry.def(function, builder, false, names);
    }

    public static <T extends Function> FunctionDefinition def(Class<T> function, ScalarBiFunctionConfigurationAwareBuilder<T> ctorRef, String ... names) {
        FunctionBuilder builder = (source, children, distinct, cfg) -> {
            if (children.size() != 2) {
                throw new QlIllegalArgumentException("expects exactly two arguments");
            }
            if (distinct) {
                throw new QlIllegalArgumentException("does not support DISTINCT yet it was specified");
            }
            return (Function)ctorRef.build(source, (Expression)children.get(0), (Expression)children.get(1), cfg);
        };
        return FunctionRegistry.def(function, builder, true, names);
    }

    protected static interface ScalarBiFunctionConfigurationAwareBuilder<T> {
        public T build(Source var1, Expression var2, Expression var3, Configuration var4);
    }

    protected static interface TwoParametersVariadicBuilder<T> {
        public T build(Source var1, Expression var2, List<Expression> var3);
    }

    protected static interface CastFunctionBuilder<T> {
        public T build(Source var1, Expression var2, DataType var3);
    }

    protected static interface FiveParametersFunctionBuilder<T> {
        public T build(Source var1, Expression var2, Expression var3, Expression var4, Expression var5, Expression var6);
    }

    protected static interface FourParametersFunctionBuilder<T> {
        public T build(Source var1, Expression var2, Expression var3, Expression var4, Expression var5);
    }

    protected static interface ScalarTriFunctionConfigurationAwareBuilder<T> {
        public T build(Source var1, Expression var2, Expression var3, Expression var4, Configuration var5);
    }

    protected static interface ThreeParametersFunctionBuilder<T> {
        public T build(Source var1, Expression var2, Expression var3, Expression var4);
    }

    public static interface FunctionBuilder {
        public Function build(Source var1, List<Expression> var2, boolean var3, Configuration var4);
    }

    protected static interface BinaryFunctionBuilder<T> {
        public T build(Source var1, Expression var2, Expression var3);
    }

    protected static interface DatetimeThreeArgsFunctionBuilder<T> {
        public T build(Source var1, Expression var2, Expression var3, Expression var4, ZoneId var5);
    }

    protected static interface DatetimeBinaryFunctionBuilder<T> {
        public T build(Source var1, Expression var2, Expression var3, ZoneId var4);
    }

    protected static interface DatetimeUnaryFunctionBuilder<T> {
        public T build(Source var1, Expression var2, ZoneId var3);
    }

    protected static interface DistinctAwareUnaryFunctionBuilder<T> {
        public T build(Source var1, Expression var2, boolean var3);
    }

    protected static interface MultiFunctionBuilder<T> {
        public T build(Source var1, List<Expression> var2);
    }

    protected static interface UnaryConfigurationAwareFunctionBuilder<T> {
        public T build(Source var1, Expression var2, Configuration var3);
    }

    protected static interface ConfigurationAwareFunctionBuilder<T> {
        public T build(Source var1, Configuration var2);
    }
}

