/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.ql.expression.gen.processor;

import java.io.IOException;
import java.util.Objects;
import org.elasticsearch.common.io.stream.NamedWriteable;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.xpack.ql.expression.gen.processor.ConstantNamedWriteable;
import org.elasticsearch.xpack.ql.expression.gen.processor.Processor;

public class ConstantProcessor
implements Processor {
    public static String NAME = "c";
    private final Object constant;
    private final boolean namedWriteable;

    public ConstantProcessor(Object value) {
        this.constant = value;
        this.namedWriteable = value instanceof NamedWriteable;
    }

    public ConstantProcessor(StreamInput in) throws IOException {
        this.namedWriteable = in.readBoolean();
        this.constant = this.namedWriteable ? in.readNamedWriteable(ConstantNamedWriteable.class) : in.readGenericValue();
    }

    public void writeTo(StreamOutput out) throws IOException {
        out.writeBoolean(this.namedWriteable);
        if (this.namedWriteable) {
            out.writeNamedWriteable((NamedWriteable)this.constant);
        } else {
            out.writeGenericValue(this.constant);
        }
    }

    public String getWriteableName() {
        return NAME;
    }

    @Override
    public Object process(Object input) {
        return this.constant;
    }

    public int hashCode() {
        return Objects.hashCode(this.constant);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        ConstantProcessor other = (ConstantProcessor)obj;
        return Objects.equals(this.constant, other.constant);
    }

    public String toString() {
        return "^" + this.constant;
    }
}

