/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.enrich.action;

import java.io.IOException;
import java.util.Comparator;
import java.util.List;
import java.util.stream.Collectors;
import org.elasticsearch.Version;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.ActionType;
import org.elasticsearch.action.FailedNodeException;
import org.elasticsearch.action.support.ActionFilters;
import org.elasticsearch.action.support.ChannelActionListener;
import org.elasticsearch.action.support.master.TransportMasterNodeAction;
import org.elasticsearch.client.Client;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.block.ClusterBlockException;
import org.elasticsearch.cluster.block.ClusterBlockLevel;
import org.elasticsearch.cluster.metadata.IndexNameExpressionResolver;
import org.elasticsearch.cluster.node.DiscoveryNode;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.TransportService;
import org.elasticsearch.xpack.core.enrich.action.EnrichStatsAction;
import org.elasticsearch.xpack.enrich.action.EnrichCoordinatorStatsAction;

public class TransportEnrichStatsAction
extends TransportMasterNodeAction<EnrichStatsAction.Request, EnrichStatsAction.Response> {
    private final Client client;

    @Inject
    public TransportEnrichStatsAction(TransportService transportService, ClusterService clusterService, ThreadPool threadPool, ActionFilters actionFilters, IndexNameExpressionResolver indexNameExpressionResolver, Client client) {
        super("cluster:monitor/xpack/enrich/stats", transportService, clusterService, threadPool, actionFilters, EnrichStatsAction.Request::new, indexNameExpressionResolver);
        this.client = client;
        transportService.registerRequestHandler("cluster:admin/xpack/enrich/stats", "same", false, true, EnrichStatsAction.Request::new, (request, channel, task) -> this.execute(task, (ActionRequest)request, (ActionListener)new ChannelActionListener(channel, "cluster:admin/xpack/enrich/stats", request)));
    }

    protected String executor() {
        return "same";
    }

    protected EnrichStatsAction.Response read(StreamInput in) throws IOException {
        return new EnrichStatsAction.Response(in);
    }

    protected void masterOperation(EnrichStatsAction.Request request, ClusterState state, ActionListener<EnrichStatsAction.Response> listener) throws Exception {
        EnrichCoordinatorStatsAction.Request statsRequest = new EnrichCoordinatorStatsAction.Request();
        ActionListener statsListener = ActionListener.wrap(response -> {
            if (response.hasFailures()) {
                FailedNodeException failure = null;
                for (FailedNodeException nodeFailure : response.failures()) {
                    if (failure == null) {
                        failure = nodeFailure;
                        continue;
                    }
                    failure.addSuppressed((Throwable)nodeFailure);
                }
                listener.onFailure(failure);
                return;
            }
            List coordinatorStats = response.getNodes().stream().map(EnrichCoordinatorStatsAction.NodeResponse::getCoordinatorStats).sorted(Comparator.comparing(EnrichStatsAction.Response.CoordinatorStats::getNodeId)).collect(Collectors.toList());
            List policyExecutionTasks = this.taskManager.getTasks().values().stream().filter(t -> t.getAction().equals("policy_execution")).map(t -> t.taskInfo(this.clusterService.localNode().getId(), true)).map(t -> new EnrichStatsAction.Response.ExecutingPolicy(t.getDescription(), t)).sorted(Comparator.comparing(EnrichStatsAction.Response.ExecutingPolicy::getName)).collect(Collectors.toList());
            listener.onResponse((Object)new EnrichStatsAction.Response(policyExecutionTasks, coordinatorStats));
        }, arg_0 -> listener.onFailure(arg_0));
        this.client.execute((ActionType)EnrichCoordinatorStatsAction.INSTANCE, (ActionRequest)statsRequest, statsListener);
    }

    protected ClusterBlockException checkBlock(EnrichStatsAction.Request request, ClusterState state) {
        return state.blocks().globalBlockedException(ClusterBlockLevel.METADATA_READ);
    }

    protected String getMasterActionName(DiscoveryNode node) {
        return node.getVersion().before(Version.V_7_9_0) ? "cluster:admin/xpack/enrich/stats" : this.actionName;
    }
}

