/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.transform.transforms.pivot;

import java.io.IOException;
import java.io.InputStream;
import java.io.UncheckedIOException;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.ElasticsearchException;
import org.elasticsearch.ElasticsearchStatusException;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.ActionType;
import org.elasticsearch.action.index.IndexRequest;
import org.elasticsearch.action.search.SearchAction;
import org.elasticsearch.action.search.SearchRequest;
import org.elasticsearch.action.search.SearchResponse;
import org.elasticsearch.action.support.IndicesOptions;
import org.elasticsearch.client.Client;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.common.collect.Tuple;
import org.elasticsearch.common.xcontent.DeprecationHandler;
import org.elasticsearch.common.xcontent.LoggingDeprecationHandler;
import org.elasticsearch.common.xcontent.NamedXContentRegistry;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentFactory;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.index.query.BoolQueryBuilder;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;
import org.elasticsearch.rest.RestStatus;
import org.elasticsearch.search.aggregations.AggregationBuilder;
import org.elasticsearch.search.aggregations.Aggregations;
import org.elasticsearch.search.aggregations.bucket.composite.CompositeAggregation;
import org.elasticsearch.search.aggregations.bucket.composite.CompositeAggregationBuilder;
import org.elasticsearch.search.builder.SearchSourceBuilder;
import org.elasticsearch.xpack.core.ClientHelper;
import org.elasticsearch.xpack.core.ml.utils.ExceptionsHelper;
import org.elasticsearch.xpack.core.transform.TransformField;
import org.elasticsearch.xpack.core.transform.transforms.SourceConfig;
import org.elasticsearch.xpack.core.transform.transforms.TransformIndexerStats;
import org.elasticsearch.xpack.core.transform.transforms.TransformProgress;
import org.elasticsearch.xpack.core.transform.transforms.pivot.GroupConfig;
import org.elasticsearch.xpack.core.transform.transforms.pivot.PivotConfig;
import org.elasticsearch.xpack.core.transform.transforms.pivot.SingleGroupSource;
import org.elasticsearch.xpack.transform.Transform;
import org.elasticsearch.xpack.transform.transforms.Function;
import org.elasticsearch.xpack.transform.transforms.pivot.AggregationResultUtils;
import org.elasticsearch.xpack.transform.transforms.pivot.CompositeBucketsChangeCollector;
import org.elasticsearch.xpack.transform.transforms.pivot.SchemaUtil;
import org.elasticsearch.xpack.transform.transforms.pivot.TransformAggregations;

public class Pivot
implements Function {
    public static final int TEST_QUERY_PAGE_SIZE = 50;
    private static final String COMPOSITE_AGGREGATION_NAME = "_transform";
    private static final Logger logger = LogManager.getLogger(Pivot.class);
    private final PivotConfig config;
    private final String transformId;
    private final boolean supportsIncrementalBucketUpdate;
    private final CompositeAggregationBuilder cachedCompositeAggregation;

    public Pivot(PivotConfig config, String transformId) {
        this.config = config;
        this.transformId = transformId;
        this.cachedCompositeAggregation = Pivot.createCompositeAggregation(config);
        boolean supportsIncrementalBucketUpdate = false;
        for (Map.Entry entry : config.getGroupConfig().getGroups().entrySet()) {
            supportsIncrementalBucketUpdate |= ((SingleGroupSource)entry.getValue()).supportsIncrementalBucketUpdate();
        }
        this.supportsIncrementalBucketUpdate = supportsIncrementalBucketUpdate;
    }

    @Override
    public void validateConfig(ActionListener<Boolean> listener) {
        for (AggregationBuilder agg : this.config.getAggregationConfig().getAggregatorFactories()) {
            if (TransformAggregations.isSupportedByTransform(agg.getType())) continue;
            listener.onFailure((Exception)new ElasticsearchStatusException("Unsupported aggregation type [" + agg.getType() + "]", RestStatus.BAD_REQUEST, new Object[0]));
            return;
        }
        listener.onResponse((Object)true);
    }

    @Override
    public void validateQuery(Client client, SourceConfig sourceConfig, ActionListener<Boolean> listener) {
        SearchRequest searchRequest = this.buildSearchRequest(sourceConfig, null, 50);
        client.execute((ActionType)SearchAction.INSTANCE, (ActionRequest)searchRequest, ActionListener.wrap(response -> {
            if (response == null) {
                listener.onFailure((Exception)new ElasticsearchStatusException("Unexpected null response from test query", RestStatus.SERVICE_UNAVAILABLE, new Object[0]));
                return;
            }
            if (response.status() != RestStatus.OK) {
                listener.onFailure((Exception)new ElasticsearchStatusException("Unexpected status from response of test query: " + response.status(), response.status(), new Object[0]));
                return;
            }
            listener.onResponse((Object)true);
        }, e -> {
            Throwable unwrapped = ExceptionsHelper.unwrapCause((Throwable)e);
            RestStatus status = unwrapped instanceof ElasticsearchException ? ((ElasticsearchException)unwrapped).status() : RestStatus.SERVICE_UNAVAILABLE;
            listener.onFailure((Exception)new ElasticsearchStatusException("Failed to test query", status, unwrapped, new Object[0]));
        }));
    }

    @Override
    public void deduceMappings(Client client, SourceConfig sourceConfig, ActionListener<Map<String, String>> listener) {
        SchemaUtil.deduceMappings(client, this.config, sourceConfig.getIndex(), listener);
    }

    @Override
    public void preview(Client client, Map<String, String> headers, SourceConfig sourceConfig, Map<String, String> fieldTypeMap, int numberOfBuckets, ActionListener<List<Map<String, Object>>> listener) {
        ClientHelper.assertNoAuthorizationHeader(headers);
        ClientHelper.executeWithHeadersAsync(headers, (String)"transform", (Client)client, (ActionType)SearchAction.INSTANCE, (ActionRequest)this.buildSearchRequest(sourceConfig, null, numberOfBuckets), (ActionListener)ActionListener.wrap(r -> {
            try {
                Aggregations aggregations = r.getAggregations();
                if (aggregations == null) {
                    listener.onFailure((Exception)new ElasticsearchStatusException("Source indices have been deleted or closed.", RestStatus.BAD_REQUEST, new Object[0]));
                    return;
                }
                CompositeAggregation agg = (CompositeAggregation)aggregations.get(COMPOSITE_AGGREGATION_NAME);
                TransformIndexerStats stats = new TransformIndexerStats();
                List docs = this.extractResults(agg, fieldTypeMap, stats).peek(doc -> doc.keySet().removeIf(k -> k.startsWith("_"))).collect(Collectors.toList());
                listener.onResponse(docs);
            }
            catch (AggregationResultUtils.AggregationExtractionException extractionException) {
                listener.onFailure((Exception)new ElasticsearchStatusException(extractionException.getMessage(), RestStatus.BAD_REQUEST, new Object[0]));
            }
        }, arg_0 -> listener.onFailure(arg_0)));
    }

    @Override
    public int getInitialPageSize() {
        return this.config.getMaxPageSearchSize() == null ? Transform.DEFAULT_INITIAL_MAX_PAGE_SEARCH_SIZE : this.config.getMaxPageSearchSize();
    }

    public SearchRequest buildSearchRequest(SourceConfig sourceConfig, Map<String, Object> position, int pageSize) {
        QueryBuilder queryBuilder = sourceConfig.getQueryConfig().getQuery();
        SearchRequest searchRequest = new SearchRequest(sourceConfig.getIndex());
        SearchSourceBuilder sourceBuilder = new SearchSourceBuilder();
        this.buildSearchQuery(sourceBuilder, null, pageSize);
        sourceBuilder.query(queryBuilder);
        searchRequest.source(sourceBuilder);
        searchRequest.indicesOptions(IndicesOptions.LENIENT_EXPAND_OPEN);
        logger.trace("Search request: {}", (Object)searchRequest);
        return searchRequest;
    }

    @Override
    public SearchSourceBuilder buildSearchQuery(SearchSourceBuilder builder, Map<String, Object> position, int pageSize) {
        this.cachedCompositeAggregation.aggregateAfter(position);
        this.cachedCompositeAggregation.size(pageSize);
        return builder.size(0).aggregation((AggregationBuilder)this.cachedCompositeAggregation);
    }

    @Override
    public Function.ChangeCollector buildChangeCollector(String synchronizationField) {
        CompositeAggregationBuilder aggregationBuilder = null;
        if (this.supportsIncrementalBucketUpdate()) {
            aggregationBuilder = Pivot.createCompositeAggregationSources(this.config, true);
        }
        return CompositeBucketsChangeCollector.buildChangeCollector(aggregationBuilder, this.config.getGroupConfig().getGroups(), synchronizationField);
    }

    @Override
    public boolean supportsIncrementalBucketUpdate() {
        return this.supportsIncrementalBucketUpdate;
    }

    public Stream<Map<String, Object>> extractResults(CompositeAggregation agg, Map<String, String> fieldTypeMap, TransformIndexerStats transformIndexerStats) {
        GroupConfig groups = this.config.getGroupConfig();
        Collection aggregationBuilders = this.config.getAggregationConfig().getAggregatorFactories();
        Collection pipelineAggregationBuilders = this.config.getAggregationConfig().getPipelineAggregatorFactories();
        return AggregationResultUtils.extractCompositeAggregationResults(agg, groups, aggregationBuilders, pipelineAggregationBuilders, fieldTypeMap, transformIndexerStats);
    }

    @Override
    public Tuple<Stream<IndexRequest>, Map<String, Object>> processSearchResponse(SearchResponse searchResponse, String destinationIndex, String destinationPipeline, Map<String, String> fieldMappings, TransformIndexerStats stats) {
        Aggregations aggregations = searchResponse.getAggregations();
        if (aggregations == null) {
            return null;
        }
        CompositeAggregation compositeAgg = (CompositeAggregation)aggregations.get(COMPOSITE_AGGREGATION_NAME);
        if (compositeAgg == null || compositeAgg.getBuckets().isEmpty()) {
            return null;
        }
        return new Tuple(this.processBucketsToIndexRequests(compositeAgg, destinationIndex, destinationPipeline, fieldMappings, stats), (Object)compositeAgg.afterKey());
    }

    @Override
    public SearchSourceBuilder buildSearchQueryForInitialProgress(SearchSourceBuilder searchSourceBuilder) {
        BoolQueryBuilder existsClauses = QueryBuilders.boolQuery();
        this.config.getGroupConfig().getGroups().values().forEach(src -> {
            if (!src.getMissingBucket() && src.getField() != null) {
                existsClauses.must((QueryBuilder)QueryBuilders.existsQuery((String)src.getField()));
            }
        });
        return searchSourceBuilder.query((QueryBuilder)existsClauses).size(0).trackTotalHits(true);
    }

    @Override
    public void getInitialProgressFromResponse(SearchResponse response, ActionListener<TransformProgress> progressListener) {
        progressListener.onResponse((Object)new TransformProgress(Long.valueOf(response.getHits().getTotalHits().value), Long.valueOf(0L), Long.valueOf(0L)));
    }

    private Stream<IndexRequest> processBucketsToIndexRequests(CompositeAggregation agg, String destinationIndex, String destinationPipeline, Map<String, String> fieldMappings, TransformIndexerStats stats) {
        return this.extractResults(agg, fieldMappings, stats).map(document -> {
            XContentBuilder builder;
            String id = (String)document.get(TransformField.DOCUMENT_ID_FIELD);
            if (id == null) {
                throw new RuntimeException("Expected a document id but got null.");
            }
            try {
                builder = XContentFactory.jsonBuilder();
                builder.startObject();
                for (Map.Entry value : document.entrySet()) {
                    if (((String)value.getKey()).startsWith("_")) continue;
                    builder.field((String)value.getKey(), value.getValue());
                }
                builder.endObject();
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
            IndexRequest request = new IndexRequest(destinationIndex).source(builder).id(id);
            if (destinationPipeline != null) {
                request.setPipeline(destinationPipeline);
            }
            return request;
        });
    }

    private static CompositeAggregationBuilder createCompositeAggregation(PivotConfig config) {
        CompositeAggregationBuilder compositeAggregation = Pivot.createCompositeAggregationSources(config, false);
        config.getAggregationConfig().getAggregatorFactories().forEach(agg -> compositeAggregation.subAggregation(agg));
        config.getAggregationConfig().getPipelineAggregatorFactories().forEach(agg -> compositeAggregation.subAggregation(agg));
        return compositeAggregation;
    }

    private static CompositeAggregationBuilder createCompositeAggregationSources(PivotConfig config, boolean forChangeDetection) {
        CompositeAggregationBuilder compositeAggregation;
        try (XContentBuilder builder = XContentFactory.jsonBuilder();){
            config.toCompositeAggXContent(builder, forChangeDetection);
            XContentParser parser = builder.generator().contentType().xContent().createParser(NamedXContentRegistry.EMPTY, (DeprecationHandler)LoggingDeprecationHandler.INSTANCE, (InputStream)BytesReference.bytes((XContentBuilder)builder).streamInput());
            compositeAggregation = (CompositeAggregationBuilder)CompositeAggregationBuilder.PARSER.parse(parser, (Object)COMPOSITE_AGGREGATION_NAME);
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to create composite aggregation from pivot function", e);
        }
        return compositeAggregation;
    }
}

