/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.datastreams.mapper;

import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.lucene.index.DocValuesType;
import org.apache.lucene.index.IndexableField;
import org.apache.lucene.search.Query;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentFactory;
import org.elasticsearch.common.xcontent.XContentHelper;
import org.elasticsearch.common.xcontent.XContentType;
import org.elasticsearch.index.mapper.DateFieldMapper;
import org.elasticsearch.index.mapper.FieldMapper;
import org.elasticsearch.index.mapper.MappedFieldType;
import org.elasticsearch.index.mapper.Mapper;
import org.elasticsearch.index.mapper.MapperService;
import org.elasticsearch.index.mapper.MappingLookup;
import org.elasticsearch.index.mapper.MetadataFieldMapper;
import org.elasticsearch.index.mapper.ParametrizedFieldMapper;
import org.elasticsearch.index.mapper.ParseContext;
import org.elasticsearch.index.mapper.TextSearchInfo;
import org.elasticsearch.index.mapper.ValueFetcher;
import org.elasticsearch.index.query.QueryShardContext;
import org.elasticsearch.search.lookup.SearchLookup;

public class DataStreamTimestampFieldMapper
extends MetadataFieldMapper {
    public static final String NAME = "_data_stream_timestamp";
    private static final String DEFAULT_PATH = "@timestamp";
    public static final MetadataFieldMapper.TypeParser PARSER = new MetadataFieldMapper.ConfigurableTypeParser(c -> new DataStreamTimestampFieldMapper(new TimestampFieldType(), false), c -> new Builder());
    private final String path = "@timestamp";
    private final boolean enabled;

    private static DataStreamTimestampFieldMapper toType(FieldMapper in) {
        return (DataStreamTimestampFieldMapper)in;
    }

    private DataStreamTimestampFieldMapper(MappedFieldType mappedFieldType, boolean enabled) {
        super(mappedFieldType);
        this.enabled = enabled;
    }

    public ParametrizedFieldMapper.Builder getMergeBuilder() {
        return new Builder().init((FieldMapper)this);
    }

    public void doValidate(MappingLookup lookup) {
        if (!this.enabled) {
            return;
        }
        Mapper mapper = lookup.getMapper(DEFAULT_PATH);
        if (mapper == null) {
            throw new IllegalArgumentException("data stream timestamp field [@timestamp] does not exist");
        }
        if (!"date".equals(mapper.typeName()) && !"date_nanos".equals(mapper.typeName())) {
            throw new IllegalArgumentException("data stream timestamp field [@timestamp] is of type [" + mapper.typeName() + "], but [" + "date" + "," + "date_nanos" + "] is expected");
        }
        DateFieldMapper dateFieldMapper = (DateFieldMapper)mapper;
        if (!dateFieldMapper.fieldType().isSearchable()) {
            throw new IllegalArgumentException("data stream timestamp field [@timestamp] is not indexed");
        }
        if (!dateFieldMapper.fieldType().hasDocValues()) {
            throw new IllegalArgumentException("data stream timestamp field [@timestamp] doesn't have doc values");
        }
        if (dateFieldMapper.getNullValue() != null) {
            throw new IllegalArgumentException("data stream timestamp field [@timestamp] has disallowed [null_value] attribute specified");
        }
        if (dateFieldMapper.getIgnoreMalformed()) {
            throw new IllegalArgumentException("data stream timestamp field [@timestamp] has disallowed [ignore_malformed] attribute specified");
        }
        try (XContentBuilder builder = XContentFactory.jsonBuilder();){
            builder.startObject();
            dateFieldMapper.toXContent(builder, EMPTY_PARAMS);
            builder.endObject();
            Map configuredSettings = (Map)XContentHelper.convertToMap((BytesReference)BytesReference.bytes((XContentBuilder)builder), (boolean)false, (XContentType)XContentType.JSON).v2();
            configuredSettings = (Map)configuredSettings.values().iterator().next();
            configuredSettings.remove("type");
            configuredSettings.remove("meta");
            configuredSettings.remove("format");
            if (!configuredSettings.isEmpty()) {
                throw new IllegalArgumentException("data stream timestamp field [@timestamp] has disallowed attributes: " + configuredSettings.keySet());
            }
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    public void postParse(ParseContext context) throws IOException {
        if (!this.enabled) {
            return;
        }
        IndexableField[] fields = context.rootDoc().getFields(DEFAULT_PATH);
        if (fields.length == 0) {
            throw new IllegalArgumentException("data stream timestamp field [@timestamp] is missing");
        }
        long numberOfValues = Arrays.stream(fields).filter(indexableField -> indexableField.fieldType().docValuesType() == DocValuesType.SORTED_NUMERIC).count();
        if (numberOfValues > 1L) {
            throw new IllegalArgumentException("data stream timestamp field [@timestamp] encountered multiple values");
        }
    }

    protected String contentType() {
        return NAME;
    }

    public static class Builder
    extends MetadataFieldMapper.Builder {
        private final ParametrizedFieldMapper.Parameter<Boolean> enabled = ParametrizedFieldMapper.Parameter.boolParam((String)"enabled", (boolean)false, m -> DataStreamTimestampFieldMapper.access$200(DataStreamTimestampFieldMapper.toType(m)), (boolean)false);

        public Builder() {
            super(DataStreamTimestampFieldMapper.NAME);
        }

        protected List<ParametrizedFieldMapper.Parameter<?>> getParameters() {
            return Collections.singletonList(this.enabled);
        }

        public MetadataFieldMapper build(Mapper.BuilderContext context) {
            return new DataStreamTimestampFieldMapper(new TimestampFieldType(), (Boolean)this.enabled.getValue());
        }
    }

    public static final class TimestampFieldType
    extends MappedFieldType {
        public TimestampFieldType() {
            super(DataStreamTimestampFieldMapper.NAME, false, false, false, TextSearchInfo.NONE, Collections.emptyMap());
        }

        public String typeName() {
            return DataStreamTimestampFieldMapper.NAME;
        }

        public Query termQuery(Object value, QueryShardContext context) {
            throw new IllegalArgumentException("Field [" + this.name() + "] of type [" + this.typeName() + "] does not support term queries");
        }

        public Query existsQuery(QueryShardContext context) {
            throw new IllegalArgumentException("Field [" + this.name() + "] of type [" + this.typeName() + "] does not support exists queries");
        }

        public ValueFetcher valueFetcher(MapperService mapperService, SearchLookup searchLookup, String format) {
            throw new UnsupportedOperationException();
        }
    }
}

