/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.ml;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import org.elasticsearch.ElasticsearchStatusException;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.support.ActionFilter;
import org.elasticsearch.cluster.ClusterChangedEvent;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.rest.RestStatus;
import org.elasticsearch.xpack.core.ml.MlMetadata;

class MlUpgradeModeActionFilter
extends ActionFilter.Simple {
    private static final Set<String> ACTIONS_DISALLOWED_IN_UPGRADE_MODE = Collections.unmodifiableSet(new HashSet<String>(Arrays.asList("cluster:admin/xpack/ml/job/put", "cluster:admin/xpack/ml/job/update", "cluster:admin/xpack/ml/job/delete", "cluster:admin/xpack/ml/job/open", "cluster:admin/xpack/ml/job/flush", "cluster:admin/xpack/ml/job/close", "cluster:admin/xpack/ml/job/persist", "cluster:internal/xpack/ml/job/finalize_job_execution", "cluster:admin/xpack/ml/job/data/post", "cluster:admin/xpack/ml/job/model_snapshots/revert", "cluster:admin/xpack/ml/job/model_snapshots/update", "cluster:admin/xpack/ml/job/model_snapshots/delete", "cluster:admin/xpack/ml/datafeeds/put", "cluster:admin/xpack/ml/datafeeds/update", "cluster:admin/xpack/ml/datafeeds/delete", "cluster:admin/xpack/ml/datafeed/start", "cluster:admin/xpack/ml/datafeed/stop", "cluster:admin/xpack/ml/filters/put", "cluster:admin/xpack/ml/filters/update", "cluster:admin/xpack/ml/filters/delete", "cluster:admin/xpack/ml/calendars/put", "cluster:admin/xpack/ml/calendars/jobs/update", "cluster:admin/xpack/ml/calendars/events/post", "cluster:admin/xpack/ml/calendars/delete", "cluster:admin/xpack/ml/calendars/events/delete", "cluster:internal/xpack/ml/job/update/process", "cluster:internal/xpack/ml/job/kill/process", "cluster:admin/xpack/ml/delete_expired_data", "cluster:admin/xpack/ml/job/forecast", "cluster:admin/xpack/ml/job/forecast/delete", "cluster:admin/xpack/ml/data_frame/analytics/put", "cluster:admin/xpack/ml/data_frame/analytics/delete", "cluster:admin/xpack/ml/data_frame/analytics/start", "cluster:admin/xpack/ml/data_frame/analytics/stop", "cluster:admin/xpack/ml/inference/put", "cluster:admin/xpack/ml/inference/delete")));
    private final AtomicBoolean isUpgradeMode = new AtomicBoolean();

    MlUpgradeModeActionFilter(ClusterService clusterService) {
        Objects.requireNonNull(clusterService);
        clusterService.addListener(this::setIsUpgradeMode);
    }

    protected boolean apply(String action, ActionRequest request, ActionListener<?> listener) {
        if (this.isUpgradeMode.get() && ACTIONS_DISALLOWED_IN_UPGRADE_MODE.contains(action)) {
            throw new ElasticsearchStatusException("Cannot perform {} action while upgrade mode is enabled", RestStatus.TOO_MANY_REQUESTS, new Object[]{action});
        }
        return true;
    }

    public int order() {
        return Integer.MAX_VALUE;
    }

    void setIsUpgradeMode(ClusterChangedEvent event) {
        this.isUpgradeMode.set(MlMetadata.getMlMetadata((ClusterState)event.state()).isUpgradeMode());
    }
}

