/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.ml.action;

import java.io.IOException;
import org.elasticsearch.ResourceNotFoundException;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.ActionType;
import org.elasticsearch.action.delete.DeleteResponse;
import org.elasticsearch.action.support.ActionFilters;
import org.elasticsearch.action.support.master.AcknowledgedResponse;
import org.elasticsearch.action.support.master.TransportMasterNodeAction;
import org.elasticsearch.client.Client;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.block.ClusterBlockException;
import org.elasticsearch.cluster.block.ClusterBlockLevel;
import org.elasticsearch.cluster.metadata.IndexNameExpressionResolver;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.xcontent.NamedXContentRegistry;
import org.elasticsearch.index.reindex.BulkByScrollResponse;
import org.elasticsearch.persistent.PersistentTasksCustomMetadata;
import org.elasticsearch.persistent.PersistentTasksService;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.TransportService;
import org.elasticsearch.xpack.core.ClientHelper;
import org.elasticsearch.xpack.core.ml.MlTasks;
import org.elasticsearch.xpack.core.ml.action.DeleteDatafeedAction;
import org.elasticsearch.xpack.core.ml.action.IsolateDatafeedAction;
import org.elasticsearch.xpack.core.ml.datafeed.DatafeedConfig;
import org.elasticsearch.xpack.core.ml.datafeed.DatafeedState;
import org.elasticsearch.xpack.core.ml.job.messages.Messages;
import org.elasticsearch.xpack.core.ml.utils.ExceptionsHelper;
import org.elasticsearch.xpack.ml.MlConfigMigrationEligibilityCheck;
import org.elasticsearch.xpack.ml.datafeed.persistence.DatafeedConfigProvider;
import org.elasticsearch.xpack.ml.job.persistence.JobDataDeleter;

public class TransportDeleteDatafeedAction
extends TransportMasterNodeAction<DeleteDatafeedAction.Request, AcknowledgedResponse> {
    private final Client client;
    private final DatafeedConfigProvider datafeedConfigProvider;
    private final ClusterService clusterService;
    private final PersistentTasksService persistentTasksService;
    private final MlConfigMigrationEligibilityCheck migrationEligibilityCheck;

    @Inject
    public TransportDeleteDatafeedAction(Settings settings, TransportService transportService, ClusterService clusterService, ThreadPool threadPool, ActionFilters actionFilters, IndexNameExpressionResolver indexNameExpressionResolver, Client client, PersistentTasksService persistentTasksService, NamedXContentRegistry xContentRegistry) {
        super("cluster:admin/xpack/ml/datafeeds/delete", transportService, clusterService, threadPool, actionFilters, DeleteDatafeedAction.Request::new, indexNameExpressionResolver);
        this.client = client;
        this.datafeedConfigProvider = new DatafeedConfigProvider(client, xContentRegistry);
        this.persistentTasksService = persistentTasksService;
        this.clusterService = clusterService;
        this.migrationEligibilityCheck = new MlConfigMigrationEligibilityCheck(settings, clusterService);
    }

    protected String executor() {
        return "same";
    }

    protected AcknowledgedResponse read(StreamInput in) throws IOException {
        return new AcknowledgedResponse(in);
    }

    protected void masterOperation(DeleteDatafeedAction.Request request, ClusterState state, ActionListener<AcknowledgedResponse> listener) {
        if (this.migrationEligibilityCheck.datafeedIsEligibleForMigration(request.getDatafeedId(), state)) {
            listener.onFailure((Exception)ExceptionsHelper.configHasNotBeenMigrated((String)"delete datafeed", (String)request.getDatafeedId()));
            return;
        }
        if (request.isForce()) {
            this.forceDeleteDatafeed(request, state, listener);
        } else {
            this.deleteDatafeedConfig(request, listener);
        }
    }

    private void forceDeleteDatafeed(DeleteDatafeedAction.Request request, ClusterState state, ActionListener<AcknowledgedResponse> listener) {
        ActionListener finalListener = ActionListener.wrap(response -> this.deleteDatafeedConfig(request, listener), arg_0 -> listener.onFailure(arg_0));
        ActionListener isolateDatafeedHandler = ActionListener.wrap(response -> this.removeDatafeedTask(request, state, (ActionListener<Boolean>)finalListener), arg_0 -> listener.onFailure(arg_0));
        IsolateDatafeedAction.Request isolateDatafeedRequest = new IsolateDatafeedAction.Request(request.getDatafeedId());
        ClientHelper.executeAsyncWithOrigin((Client)this.client, (String)"ml", (ActionType)IsolateDatafeedAction.INSTANCE, (ActionRequest)isolateDatafeedRequest, (ActionListener)isolateDatafeedHandler);
    }

    private void removeDatafeedTask(DeleteDatafeedAction.Request request, ClusterState state, final ActionListener<Boolean> listener) {
        PersistentTasksCustomMetadata tasks = (PersistentTasksCustomMetadata)state.getMetadata().custom("persistent_tasks");
        PersistentTasksCustomMetadata.PersistentTask datafeedTask = MlTasks.getDatafeedTask((String)request.getDatafeedId(), (PersistentTasksCustomMetadata)tasks);
        if (datafeedTask == null) {
            listener.onResponse((Object)true);
        } else {
            this.persistentTasksService.sendRemoveRequest(datafeedTask.getId(), new ActionListener<PersistentTasksCustomMetadata.PersistentTask<?>>(){

                public void onResponse(PersistentTasksCustomMetadata.PersistentTask<?> persistentTask) {
                    listener.onResponse((Object)Boolean.TRUE);
                }

                public void onFailure(Exception e) {
                    if (ExceptionsHelper.unwrapCause((Throwable)e) instanceof ResourceNotFoundException) {
                        listener.onResponse((Object)true);
                    } else {
                        listener.onFailure(e);
                    }
                }
            });
        }
    }

    private void deleteDatafeedConfig(DeleteDatafeedAction.Request request, ActionListener<AcknowledgedResponse> listener) {
        PersistentTasksCustomMetadata tasks = (PersistentTasksCustomMetadata)this.clusterService.state().getMetadata().custom("persistent_tasks");
        if (MlTasks.getDatafeedTask((String)request.getDatafeedId(), (PersistentTasksCustomMetadata)tasks) != null) {
            listener.onFailure((Exception)ExceptionsHelper.conflictStatusException((String)Messages.getMessage((String)"Cannot delete datafeed [{0}] while its status is {1}", (Object[])new Object[]{request.getDatafeedId(), DatafeedState.STARTED}), (Object[])new Object[0]));
            return;
        }
        String datafeedId = request.getDatafeedId();
        this.datafeedConfigProvider.getDatafeedConfig(datafeedId, (ActionListener<DatafeedConfig.Builder>)ActionListener.wrap(datafeedConfigBuilder -> {
            String jobId = datafeedConfigBuilder.build().getJobId();
            JobDataDeleter jobDataDeleter = new JobDataDeleter(this.client, jobId);
            jobDataDeleter.deleteDatafeedTimingStats((ActionListener<BulkByScrollResponse>)ActionListener.wrap(unused1 -> this.datafeedConfigProvider.deleteDatafeedConfig(datafeedId, (ActionListener<DeleteResponse>)ActionListener.wrap(unused2 -> listener.onResponse((Object)new AcknowledgedResponse(true)), arg_0 -> ((ActionListener)listener).onFailure(arg_0))), arg_0 -> ((ActionListener)listener).onFailure(arg_0)));
        }, arg_0 -> listener.onFailure(arg_0)));
    }

    protected ClusterBlockException checkBlock(DeleteDatafeedAction.Request request, ClusterState state) {
        return state.blocks().globalBlockedException(ClusterBlockLevel.METADATA_WRITE);
    }
}

