/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.ml.action;

import com.carrotsearch.hppc.cursors.ObjectObjectCursor;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Consumer;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.ElasticsearchStatusException;
import org.elasticsearch.ResourceNotFoundException;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.ActionType;
import org.elasticsearch.action.admin.indices.alias.IndicesAliasesRequest;
import org.elasticsearch.action.admin.indices.alias.get.GetAliasesRequest;
import org.elasticsearch.action.admin.indices.alias.get.GetAliasesResponse;
import org.elasticsearch.action.admin.indices.delete.DeleteIndexRequest;
import org.elasticsearch.action.bulk.BulkItemResponse;
import org.elasticsearch.action.delete.DeleteResponse;
import org.elasticsearch.action.search.MultiSearchAction;
import org.elasticsearch.action.search.MultiSearchRequest;
import org.elasticsearch.action.search.MultiSearchResponse;
import org.elasticsearch.action.search.SearchRequest;
import org.elasticsearch.action.search.SearchResponse;
import org.elasticsearch.action.support.ActionFilters;
import org.elasticsearch.action.support.IndicesOptions;
import org.elasticsearch.action.support.master.AcknowledgedResponse;
import org.elasticsearch.action.support.master.TransportMasterNodeAction;
import org.elasticsearch.client.Client;
import org.elasticsearch.client.IndicesAdminClient;
import org.elasticsearch.client.ParentTaskAssigningClient;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.block.ClusterBlockException;
import org.elasticsearch.cluster.block.ClusterBlockLevel;
import org.elasticsearch.cluster.metadata.IndexNameExpressionResolver;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.CheckedConsumer;
import org.elasticsearch.common.Nullable;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.util.concurrent.ThreadContext;
import org.elasticsearch.index.IndexNotFoundException;
import org.elasticsearch.index.query.ConstantScoreQueryBuilder;
import org.elasticsearch.index.query.IdsQueryBuilder;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;
import org.elasticsearch.index.query.TermQueryBuilder;
import org.elasticsearch.index.reindex.BulkByScrollResponse;
import org.elasticsearch.index.reindex.DeleteByQueryAction;
import org.elasticsearch.index.reindex.DeleteByQueryRequest;
import org.elasticsearch.persistent.PersistentTasksCustomMetadata;
import org.elasticsearch.persistent.PersistentTasksService;
import org.elasticsearch.search.builder.SearchSourceBuilder;
import org.elasticsearch.tasks.Task;
import org.elasticsearch.tasks.TaskId;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.TransportService;
import org.elasticsearch.xpack.core.ClientHelper;
import org.elasticsearch.xpack.core.action.util.PageParams;
import org.elasticsearch.xpack.core.ml.MlTasks;
import org.elasticsearch.xpack.core.ml.action.DeleteJobAction;
import org.elasticsearch.xpack.core.ml.action.GetModelSnapshotsAction;
import org.elasticsearch.xpack.core.ml.action.KillProcessAction;
import org.elasticsearch.xpack.core.ml.job.config.Job;
import org.elasticsearch.xpack.core.ml.job.config.JobState;
import org.elasticsearch.xpack.core.ml.job.config.JobTaskState;
import org.elasticsearch.xpack.core.ml.job.messages.Messages;
import org.elasticsearch.xpack.core.ml.job.persistence.AnomalyDetectorsIndex;
import org.elasticsearch.xpack.core.ml.job.process.autodetect.state.CategorizerState;
import org.elasticsearch.xpack.core.ml.job.process.autodetect.state.Quantiles;
import org.elasticsearch.xpack.core.ml.utils.ExceptionsHelper;
import org.elasticsearch.xpack.ml.MlConfigMigrationEligibilityCheck;
import org.elasticsearch.xpack.ml.datafeed.persistence.DatafeedConfigProvider;
import org.elasticsearch.xpack.ml.job.persistence.JobConfigProvider;
import org.elasticsearch.xpack.ml.job.persistence.JobDataDeleter;
import org.elasticsearch.xpack.ml.job.persistence.JobResultsProvider;
import org.elasticsearch.xpack.ml.notifications.AnomalyDetectionAuditor;
import org.elasticsearch.xpack.ml.process.MlMemoryTracker;
import org.elasticsearch.xpack.ml.utils.MlIndicesUtils;

public class TransportDeleteJobAction
extends TransportMasterNodeAction<DeleteJobAction.Request, AcknowledgedResponse> {
    private static final Logger logger = LogManager.getLogger(TransportDeleteJobAction.class);
    private static final int MAX_SNAPSHOTS_TO_DELETE = 10000;
    private final Client client;
    private final PersistentTasksService persistentTasksService;
    private final AnomalyDetectionAuditor auditor;
    private final JobResultsProvider jobResultsProvider;
    private final JobConfigProvider jobConfigProvider;
    private final DatafeedConfigProvider datafeedConfigProvider;
    private final MlMemoryTracker memoryTracker;
    private final MlConfigMigrationEligibilityCheck migrationEligibilityCheck;
    private final Map<String, List<ActionListener<AcknowledgedResponse>>> listenersByJobId;

    @Inject
    public TransportDeleteJobAction(Settings settings, TransportService transportService, ClusterService clusterService, ThreadPool threadPool, ActionFilters actionFilters, IndexNameExpressionResolver indexNameExpressionResolver, PersistentTasksService persistentTasksService, Client client, AnomalyDetectionAuditor auditor, JobResultsProvider jobResultsProvider, JobConfigProvider jobConfigProvider, DatafeedConfigProvider datafeedConfigProvider, MlMemoryTracker memoryTracker) {
        super("cluster:admin/xpack/ml/job/delete", transportService, clusterService, threadPool, actionFilters, DeleteJobAction.Request::new, indexNameExpressionResolver);
        this.client = client;
        this.persistentTasksService = persistentTasksService;
        this.auditor = auditor;
        this.jobResultsProvider = jobResultsProvider;
        this.jobConfigProvider = jobConfigProvider;
        this.datafeedConfigProvider = datafeedConfigProvider;
        this.memoryTracker = memoryTracker;
        this.migrationEligibilityCheck = new MlConfigMigrationEligibilityCheck(settings, clusterService);
        this.listenersByJobId = new HashMap<String, List<ActionListener<AcknowledgedResponse>>>();
    }

    protected String executor() {
        return "same";
    }

    protected AcknowledgedResponse read(StreamInput in) throws IOException {
        return new AcknowledgedResponse(in);
    }

    protected ClusterBlockException checkBlock(DeleteJobAction.Request request, ClusterState state) {
        return state.blocks().globalBlockedException(ClusterBlockLevel.METADATA_WRITE);
    }

    protected void masterOperation(DeleteJobAction.Request request, ClusterState state, ActionListener<AcknowledgedResponse> listener) {
        throw new UnsupportedOperationException("the Task parameter is required");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void masterOperation(Task task, DeleteJobAction.Request request, ClusterState state, ActionListener<AcknowledgedResponse> listener) {
        if (this.migrationEligibilityCheck.jobIsEligibleForMigration(request.getJobId(), state)) {
            listener.onFailure((Exception)ExceptionsHelper.configHasNotBeenMigrated((String)"delete job", (String)request.getJobId()));
            return;
        }
        logger.debug("Deleting job '{}'", (Object)request.getJobId());
        if (!request.isForce()) {
            this.checkJobIsNotOpen(request.getJobId(), state);
        }
        TaskId taskId = new TaskId(this.clusterService.localNode().getId(), task.getId());
        ParentTaskAssigningClient parentTaskClient = new ParentTaskAssigningClient(this.client, taskId);
        Map<String, List<ActionListener<AcknowledgedResponse>>> map = this.listenersByJobId;
        synchronized (map) {
            if (this.listenersByJobId.containsKey(request.getJobId())) {
                logger.debug("[{}] Deletion task [{}] will wait for existing deletion task to complete", (Object)request.getJobId(), (Object)task.getId());
                this.listenersByJobId.get(request.getJobId()).add(listener);
                return;
            }
            ArrayList<ActionListener<AcknowledgedResponse>> listeners = new ArrayList<ActionListener<AcknowledgedResponse>>();
            listeners.add(listener);
            this.listenersByJobId.put(request.getJobId(), listeners);
        }
        ActionListener finalListener = ActionListener.wrap(ack -> this.notifyListeners(request.getJobId(), (AcknowledgedResponse)ack, null), e -> {
            this.notifyListeners(request.getJobId(), null, (Exception)e);
            this.auditor.error(request.getJobId(), Messages.getMessage((String)"Error deleting job: {0}", (Object[])new Object[]{e.getMessage()}));
        });
        ActionListener markAsDeletingListener = ActionListener.wrap(response -> {
            if (request.isForce()) {
                this.forceDeleteJob(parentTaskClient, request, (ActionListener<AcknowledgedResponse>)finalListener);
            } else {
                this.normalDeleteJob(parentTaskClient, request, (ActionListener<AcknowledgedResponse>)finalListener);
            }
        }, arg_0 -> ((ActionListener)finalListener).onFailure(arg_0));
        ActionListener jobExistsListener = ActionListener.wrap(response -> {
            this.auditor.info(request.getJobId(), Messages.getMessage((String)"Deleting job by task with id ''{0}''", (Object[])new Object[]{taskId}));
            this.markJobAsDeletingIfNotUsed(request.getJobId(), (ActionListener<Boolean>)markAsDeletingListener);
        }, e -> {
            if (request.isForce() && MlTasks.getJobTask((String)request.getJobId(), (PersistentTasksCustomMetadata)((PersistentTasksCustomMetadata)state.getMetadata().custom("persistent_tasks"))) != null) {
                logger.info("[{}] config is missing but task exists. Attempting to delete tasks and stop process", (Object)request.getJobId());
                this.forceDeleteJob(parentTaskClient, request, (ActionListener<AcknowledgedResponse>)finalListener);
            } else {
                finalListener.onFailure(e);
            }
        });
        this.jobConfigProvider.jobExists(request.getJobId(), true, (ActionListener<Boolean>)jobExistsListener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notifyListeners(String jobId, @Nullable AcknowledgedResponse ack, @Nullable Exception error) {
        Map<String, List<ActionListener<AcknowledgedResponse>>> map = this.listenersByJobId;
        synchronized (map) {
            List<ActionListener<AcknowledgedResponse>> listeners = this.listenersByJobId.remove(jobId);
            if (listeners == null) {
                logger.error("[{}] No deletion job listeners could be found", (Object)jobId);
                return;
            }
            for (ActionListener<AcknowledgedResponse> listener : listeners) {
                if (error != null) {
                    listener.onFailure(error);
                    continue;
                }
                listener.onResponse((Object)ack);
            }
        }
    }

    private void normalDeleteJob(ParentTaskAssigningClient parentTaskClient, DeleteJobAction.Request request, ActionListener<AcknowledgedResponse> listener) {
        String jobId = request.getJobId();
        this.memoryTracker.removeAnomalyDetectorJob(jobId);
        CheckedConsumer apiResponseHandler = jobDeleted -> {
            if (jobDeleted.booleanValue()) {
                logger.info("Job [" + jobId + "] deleted");
                this.auditor.info(jobId, Messages.getMessage((String)"Job deleted"));
                listener.onResponse((Object)new AcknowledgedResponse(true));
            } else {
                listener.onResponse((Object)new AcknowledgedResponse(false));
            }
        };
        CheckedConsumer deleteJobStateHandler = response -> this.jobConfigProvider.deleteJob(jobId, false, (ActionListener<DeleteResponse>)ActionListener.wrap(deleteResponse -> apiResponseHandler.accept((Object)Boolean.TRUE), arg_0 -> ((ActionListener)listener).onFailure(arg_0)));
        CheckedConsumer removeFromCalendarsHandler = response -> this.jobResultsProvider.removeJobFromCalendars(jobId, (ActionListener<Boolean>)ActionListener.wrap(arg_0 -> ((CheckedConsumer)deleteJobStateHandler).accept(arg_0), arg_0 -> ((ActionListener)listener).onFailure(arg_0)));
        this.deleteJobDocuments(parentTaskClient, jobId, (CheckedConsumer<Boolean, Exception>)removeFromCalendarsHandler, arg_0 -> listener.onFailure(arg_0));
    }

    private void deleteJobDocuments(ParentTaskAssigningClient parentTaskClient, String jobId, CheckedConsumer<Boolean, Exception> finishedHandler, Consumer<Exception> failureHandler) {
        AtomicReference indexNames = new AtomicReference();
        ActionListener completionHandler = ActionListener.wrap(response -> finishedHandler.accept((Object)response.isAcknowledged()), failureHandler);
        ActionListener dbqHandler = ActionListener.wrap(bulkByScrollResponse -> {
            if (bulkByScrollResponse == null) {
                completionHandler.onResponse((Object)new AcknowledgedResponse(true));
            } else {
                if (bulkByScrollResponse.isTimedOut()) {
                    logger.warn("[{}] DeleteByQuery for indices [{}] timed out.", (Object)jobId, (Object)String.join((CharSequence)", ", (CharSequence[])indexNames.get()));
                }
                if (!bulkByScrollResponse.getBulkFailures().isEmpty()) {
                    logger.warn("[{}] {} failures and {} conflicts encountered while running DeleteByQuery on indices [{}].", (Object)jobId, (Object)bulkByScrollResponse.getBulkFailures().size(), (Object)bulkByScrollResponse.getVersionConflicts(), (Object)String.join((CharSequence)", ", (CharSequence[])indexNames.get()));
                    for (BulkItemResponse.Failure failure : bulkByScrollResponse.getBulkFailures()) {
                        logger.warn("DBQ failure: " + failure);
                    }
                }
                this.deleteAliases(parentTaskClient, jobId, (ActionListener<AcknowledgedResponse>)completionHandler);
            }
        }, failureHandler);
        ActionListener deleteByQueryExecutor = ActionListener.wrap(response -> {
            if (response.booleanValue() && ((String[])indexNames.get()).length > 0) {
                logger.info("[{}] running delete by query on [{}]", (Object)jobId, (Object)String.join((CharSequence)", ", (CharSequence[])indexNames.get()));
                ConstantScoreQueryBuilder query = new ConstantScoreQueryBuilder((QueryBuilder)new TermQueryBuilder(Job.ID.getPreferredName(), jobId));
                DeleteByQueryRequest request = (DeleteByQueryRequest)((DeleteByQueryRequest)((DeleteByQueryRequest)new DeleteByQueryRequest((String[])indexNames.get()).setQuery((QueryBuilder)query).setIndicesOptions(MlIndicesUtils.addIgnoreUnavailable(IndicesOptions.lenientExpandOpenHidden())).setSlices(0)).setAbortOnVersionConflict(false)).setRefresh(true);
                ClientHelper.executeAsyncWithOrigin((Client)parentTaskClient, (String)"ml", (ActionType)DeleteByQueryAction.INSTANCE, (ActionRequest)request, (ActionListener)dbqHandler);
            } else {
                dbqHandler.onResponse(null);
            }
        }, failureHandler);
        ActionListener customIndexSearchHandler = ActionListener.wrap(multiSearchResponse -> {
            if (multiSearchResponse == null) {
                deleteByQueryExecutor.onResponse((Object)true);
                return;
            }
            String defaultSharedIndex = ".ml-anomalies-shared";
            ArrayList<String> indicesToDelete = new ArrayList<String>();
            boolean needToRunDBQTemp = false;
            assert (multiSearchResponse.getResponses().length == ((String[])indexNames.get()).length);
            int i = 0;
            for (MultiSearchResponse.Item item : multiSearchResponse.getResponses()) {
                if (item.isFailure()) {
                    ++i;
                    if (ExceptionsHelper.unwrapCause((Throwable)item.getFailure()) instanceof IndexNotFoundException) continue;
                    failureHandler.accept(item.getFailure());
                    return;
                }
                SearchResponse searchResponse = item.getResponse();
                if (searchResponse.getHits().getTotalHits().value > 0L || ((String[])indexNames.get())[i].equals(defaultSharedIndex)) {
                    needToRunDBQTemp = true;
                } else {
                    indicesToDelete.add(((String[])indexNames.get())[i]);
                }
                ++i;
            }
            boolean needToRunDBQ = needToRunDBQTemp;
            if (indicesToDelete.isEmpty()) {
                deleteByQueryExecutor.onResponse((Object)needToRunDBQ);
                return;
            }
            logger.info("[{}] deleting the following indices directly {}", (Object)jobId, indicesToDelete);
            DeleteIndexRequest request = new DeleteIndexRequest(indicesToDelete.toArray(new String[0]));
            request.indicesOptions(IndicesOptions.lenientExpandOpenHidden());
            ClientHelper.executeAsyncWithOrigin((ThreadContext)parentTaskClient.threadPool().getThreadContext(), (String)"ml", (ActionRequest)request, (ActionListener)ActionListener.wrap(response -> deleteByQueryExecutor.onResponse((Object)needToRunDBQ), (Consumer)failureHandler), (arg_0, arg_1) -> ((IndicesAdminClient)parentTaskClient.admin().indices()).delete(arg_0, arg_1));
        }, failure -> {
            if (ExceptionsHelper.unwrapCause((Throwable)failure) instanceof IndexNotFoundException) {
                deleteByQueryExecutor.onResponse((Object)false);
            } else {
                failureHandler.accept((Exception)failure);
            }
        });
        ActionListener getJobHandler = ActionListener.wrap(builder -> {
            indexNames.set(this.indexNameExpressionResolver.concreteIndexNames(this.clusterService.state(), IndicesOptions.lenientExpandOpen(), new String[]{AnomalyDetectorsIndex.jobResultsAliasedName((String)jobId)}));
            if (((String[])indexNames.get()).length == 0) {
                customIndexSearchHandler.onResponse(null);
                return;
            }
            MultiSearchRequest multiSearchRequest = new MultiSearchRequest();
            for (String indexName : (String[])indexNames.get()) {
                SearchSourceBuilder source = new SearchSourceBuilder().size(0).trackTotalHitsUpTo(1).query((QueryBuilder)QueryBuilders.boolQuery().filter((QueryBuilder)QueryBuilders.boolQuery().mustNot((QueryBuilder)QueryBuilders.termQuery((String)Job.ID.getPreferredName(), (String)jobId))));
                multiSearchRequest.add(new SearchRequest(new String[]{indexName}).source(source));
            }
            ClientHelper.executeAsyncWithOrigin((Client)parentTaskClient, (String)"ml", (ActionType)MultiSearchAction.INSTANCE, (ActionRequest)multiSearchRequest, (ActionListener)customIndexSearchHandler);
        }, failureHandler);
        ActionListener deleteAnnotationsHandler = ActionListener.wrap(response -> this.jobConfigProvider.getJob(jobId, (ActionListener<Job.Builder>)getJobHandler), failureHandler);
        ActionListener deleteCategorizerStateHandler = ActionListener.wrap(response -> this.deleteAnnotations(parentTaskClient, jobId, (ActionListener<Boolean>)deleteAnnotationsHandler), failureHandler);
        ActionListener deleteQuantilesHandler = ActionListener.wrap(response -> this.deleteCategorizerState(parentTaskClient, jobId, 1, (ActionListener<Boolean>)deleteCategorizerStateHandler), failureHandler);
        ActionListener deleteStateHandler = ActionListener.wrap(bulkResponse -> this.deleteQuantiles(parentTaskClient, jobId, (ActionListener<Boolean>)deleteQuantilesHandler), failureHandler);
        this.deleteModelState(parentTaskClient, jobId, (ActionListener<BulkByScrollResponse>)deleteStateHandler);
    }

    private void deleteQuantiles(ParentTaskAssigningClient parentTaskClient, String jobId, ActionListener<Boolean> finishedHandler) {
        IdsQueryBuilder query = new IdsQueryBuilder().addIds(new String[]{Quantiles.documentId((String)jobId)});
        DeleteByQueryRequest request = (DeleteByQueryRequest)((DeleteByQueryRequest)new DeleteByQueryRequest(new String[]{AnomalyDetectorsIndex.jobStateIndexPattern()}).setQuery((QueryBuilder)query).setIndicesOptions(MlIndicesUtils.addIgnoreUnavailable(IndicesOptions.lenientExpandOpen())).setAbortOnVersionConflict(false)).setRefresh(true);
        ClientHelper.executeAsyncWithOrigin((Client)parentTaskClient, (String)"ml", (ActionType)DeleteByQueryAction.INSTANCE, (ActionRequest)request, (ActionListener)ActionListener.wrap(response -> finishedHandler.onResponse((Object)true), TransportDeleteJobAction.ignoreIndexNotFoundException(finishedHandler)));
    }

    private void deleteModelState(ParentTaskAssigningClient parentTaskClient, String jobId, ActionListener<BulkByScrollResponse> listener) {
        GetModelSnapshotsAction.Request request = new GetModelSnapshotsAction.Request(jobId, null);
        request.setPageParams(new PageParams(0, 10000));
        ClientHelper.executeAsyncWithOrigin((Client)parentTaskClient, (String)"ml", (ActionType)GetModelSnapshotsAction.INSTANCE, (ActionRequest)request, (ActionListener)ActionListener.wrap(response -> {
            List deleteCandidates = response.getPage().results();
            JobDataDeleter deleter = new JobDataDeleter((Client)parentTaskClient, jobId);
            deleter.deleteModelSnapshots(deleteCandidates, listener);
        }, arg_0 -> listener.onFailure(arg_0)));
    }

    private void deleteCategorizerState(ParentTaskAssigningClient parentTaskClient, String jobId, int docNum, ActionListener<Boolean> finishedHandler) {
        IdsQueryBuilder query = new IdsQueryBuilder().addIds(new String[]{CategorizerState.documentId((String)jobId, (int)docNum)});
        DeleteByQueryRequest request = (DeleteByQueryRequest)((DeleteByQueryRequest)new DeleteByQueryRequest(new String[]{AnomalyDetectorsIndex.jobStateIndexPattern()}).setQuery((QueryBuilder)query).setIndicesOptions(MlIndicesUtils.addIgnoreUnavailable(IndicesOptions.lenientExpandOpen())).setAbortOnVersionConflict(false)).setRefresh(true);
        ClientHelper.executeAsyncWithOrigin((Client)parentTaskClient, (String)"ml", (ActionType)DeleteByQueryAction.INSTANCE, (ActionRequest)request, (ActionListener)ActionListener.wrap(response -> {
            if (response.getDeleted() > 0L) {
                this.deleteCategorizerState(parentTaskClient, jobId, docNum + 1, finishedHandler);
                return;
            }
            finishedHandler.onResponse((Object)true);
        }, TransportDeleteJobAction.ignoreIndexNotFoundException(finishedHandler)));
    }

    private void deleteAnnotations(ParentTaskAssigningClient parentTaskClient, String jobId, ActionListener<Boolean> finishedHandler) {
        JobDataDeleter deleter = new JobDataDeleter((Client)parentTaskClient, jobId);
        deleter.deleteAllAnnotations((ActionListener<Boolean>)ActionListener.wrap(r -> finishedHandler.onResponse((Object)true), TransportDeleteJobAction.ignoreIndexNotFoundException(finishedHandler)));
    }

    private static Consumer<Exception> ignoreIndexNotFoundException(ActionListener<Boolean> finishedHandler) {
        return e -> {
            if (ExceptionsHelper.unwrapCause((Throwable)e) instanceof IndexNotFoundException) {
                finishedHandler.onResponse((Object)true);
            } else {
                finishedHandler.onFailure(e);
            }
        };
    }

    private void deleteAliases(ParentTaskAssigningClient parentTaskClient, String jobId, ActionListener<AcknowledgedResponse> finishedHandler) {
        String readAliasName = AnomalyDetectorsIndex.jobResultsAliasedName((String)jobId);
        String writeAliasName = AnomalyDetectorsIndex.resultsWriteAlias((String)jobId);
        GetAliasesRequest aliasesRequest = new GetAliasesRequest().aliases(new String[]{readAliasName, writeAliasName}).indicesOptions(IndicesOptions.lenientExpandOpenHidden());
        ClientHelper.executeAsyncWithOrigin((ThreadContext)parentTaskClient.threadPool().getThreadContext(), (String)"ml", (ActionRequest)aliasesRequest, (ActionListener)ActionListener.wrap(getAliasesResponse -> {
            IndicesAliasesRequest removeRequest = this.buildRemoveAliasesRequest((GetAliasesResponse)getAliasesResponse);
            if (removeRequest == null) {
                finishedHandler.onResponse((Object)new AcknowledgedResponse(true));
                return;
            }
            ClientHelper.executeAsyncWithOrigin((ThreadContext)parentTaskClient.threadPool().getThreadContext(), (String)"ml", (ActionRequest)removeRequest, (ActionListener)finishedHandler, (arg_0, arg_1) -> ((IndicesAdminClient)parentTaskClient.admin().indices()).aliases(arg_0, arg_1));
        }, arg_0 -> finishedHandler.onFailure(arg_0)), (arg_0, arg_1) -> ((IndicesAdminClient)parentTaskClient.admin().indices()).getAliases(arg_0, arg_1));
    }

    private IndicesAliasesRequest buildRemoveAliasesRequest(GetAliasesResponse getAliasesResponse) {
        HashSet aliases = new HashSet();
        ArrayList<String> indices = new ArrayList<String>();
        for (ObjectObjectCursor entry : getAliasesResponse.getAliases()) {
            if (((List)entry.value).isEmpty()) continue;
            indices.add((String)entry.key);
            ((List)entry.value).forEach(metadata -> aliases.add(metadata.getAlias()));
        }
        return aliases.isEmpty() ? null : new IndicesAliasesRequest().addAliasAction(IndicesAliasesRequest.AliasActions.remove().aliases(aliases.toArray(new String[aliases.size()])).indices(indices.toArray(new String[indices.size()])));
    }

    private void forceDeleteJob(final ParentTaskAssigningClient parentTaskClient, final DeleteJobAction.Request request, final ActionListener<AcknowledgedResponse> listener) {
        logger.debug("Force deleting job [{}]", (Object)request.getJobId());
        ClusterState state = this.clusterService.state();
        String jobId = request.getJobId();
        ActionListener<Boolean> removeTaskListener = new ActionListener<Boolean>(){

            public void onResponse(Boolean response) {
                TransportDeleteJobAction.this.normalDeleteJob(parentTaskClient, request, (ActionListener<AcknowledgedResponse>)listener);
            }

            public void onFailure(Exception e) {
                if (ExceptionsHelper.unwrapCause((Throwable)e) instanceof ResourceNotFoundException) {
                    TransportDeleteJobAction.this.normalDeleteJob(parentTaskClient, request, (ActionListener<AcknowledgedResponse>)listener);
                } else {
                    listener.onFailure(e);
                }
            }
        };
        ActionListener killJobListener = ActionListener.wrap(arg_0 -> this.lambda$forceDeleteJob$27(request, state, (ActionListener)removeTaskListener, arg_0), arg_0 -> this.lambda$forceDeleteJob$28(request, state, (ActionListener)removeTaskListener, listener, arg_0));
        this.killProcess(parentTaskClient, jobId, (ActionListener<KillProcessAction.Response>)killJobListener);
    }

    private void killProcess(ParentTaskAssigningClient parentTaskClient, String jobId, ActionListener<KillProcessAction.Response> listener) {
        KillProcessAction.Request killRequest = new KillProcessAction.Request(jobId);
        ClientHelper.executeAsyncWithOrigin((Client)parentTaskClient, (String)"ml", (ActionType)KillProcessAction.INSTANCE, (ActionRequest)killRequest, listener);
    }

    private void removePersistentTask(String jobId, ClusterState currentState, final ActionListener<Boolean> listener) {
        PersistentTasksCustomMetadata tasks = (PersistentTasksCustomMetadata)currentState.getMetadata().custom("persistent_tasks");
        PersistentTasksCustomMetadata.PersistentTask jobTask = MlTasks.getJobTask((String)jobId, (PersistentTasksCustomMetadata)tasks);
        if (jobTask == null) {
            listener.onResponse(null);
        } else {
            this.persistentTasksService.sendRemoveRequest(jobTask.getId(), new ActionListener<PersistentTasksCustomMetadata.PersistentTask<?>>(){

                public void onResponse(PersistentTasksCustomMetadata.PersistentTask<?> task) {
                    listener.onResponse((Object)Boolean.TRUE);
                }

                public void onFailure(Exception e) {
                    listener.onFailure(e);
                }
            });
        }
    }

    private void checkJobIsNotOpen(String jobId, ClusterState state) {
        PersistentTasksCustomMetadata tasks = (PersistentTasksCustomMetadata)state.metadata().custom("persistent_tasks");
        PersistentTasksCustomMetadata.PersistentTask jobTask = MlTasks.getJobTask((String)jobId, (PersistentTasksCustomMetadata)tasks);
        if (jobTask != null) {
            JobTaskState jobTaskState = (JobTaskState)jobTask.getState();
            throw ExceptionsHelper.conflictStatusException((String)("Cannot delete job [" + jobId + "] because the job is " + (jobTaskState == null ? JobState.OPENING : jobTaskState.getState())), (Object[])new Object[0]);
        }
    }

    private void markJobAsDeletingIfNotUsed(String jobId, ActionListener<Boolean> listener) {
        this.datafeedConfigProvider.findDatafeedsForJobIds(Collections.singletonList(jobId), (ActionListener<Set<String>>)ActionListener.wrap(datafeedIds -> {
            if (!datafeedIds.isEmpty()) {
                listener.onFailure((Exception)ExceptionsHelper.conflictStatusException((String)("Cannot delete job [" + jobId + "] because datafeed [" + (String)datafeedIds.iterator().next() + "] refers to it"), (Object[])new Object[0]));
                return;
            }
            this.jobConfigProvider.markJobAsDeleting(jobId, listener);
        }, arg_0 -> listener.onFailure(arg_0)));
    }

    private /* synthetic */ void lambda$forceDeleteJob$28(DeleteJobAction.Request request, ClusterState state, ActionListener removeTaskListener, ActionListener listener, Exception e) {
        if (ExceptionsHelper.unwrapCause((Throwable)e) instanceof ElasticsearchStatusException) {
            this.removePersistentTask(request.getJobId(), state, (ActionListener<Boolean>)removeTaskListener);
        } else {
            listener.onFailure(e);
        }
    }

    private /* synthetic */ void lambda$forceDeleteJob$27(DeleteJobAction.Request request, ClusterState state, ActionListener removeTaskListener, KillProcessAction.Response response) throws Exception {
        this.removePersistentTask(request.getJobId(), state, (ActionListener<Boolean>)removeTaskListener);
    }
}

