/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.ml.action;

import java.io.IOException;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.message.Message;
import org.apache.logging.log4j.message.ParameterizedMessage;
import org.elasticsearch.ElasticsearchStatusException;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.support.ActionFilters;
import org.elasticsearch.action.support.master.AcknowledgedResponse;
import org.elasticsearch.action.support.master.TransportMasterNodeAction;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.block.ClusterBlockException;
import org.elasticsearch.cluster.block.ClusterBlockLevel;
import org.elasticsearch.cluster.metadata.IndexNameExpressionResolver;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.ingest.IngestMetadata;
import org.elasticsearch.ingest.IngestService;
import org.elasticsearch.ingest.Pipeline;
import org.elasticsearch.ingest.PipelineConfiguration;
import org.elasticsearch.rest.RestStatus;
import org.elasticsearch.script.ScriptService;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.TransportService;
import org.elasticsearch.xpack.core.ml.action.DeleteTrainedModelAction;
import org.elasticsearch.xpack.ml.inference.ingest.InferenceProcessor;
import org.elasticsearch.xpack.ml.inference.persistence.TrainedModelProvider;
import org.elasticsearch.xpack.ml.notifications.InferenceAuditor;

public class TransportDeleteTrainedModelAction
extends TransportMasterNodeAction<DeleteTrainedModelAction.Request, AcknowledgedResponse> {
    private static final Logger logger = LogManager.getLogger(TransportDeleteTrainedModelAction.class);
    private final TrainedModelProvider trainedModelProvider;
    private final InferenceAuditor auditor;
    private final IngestService ingestService;

    @Inject
    public TransportDeleteTrainedModelAction(TransportService transportService, ClusterService clusterService, ThreadPool threadPool, ActionFilters actionFilters, IndexNameExpressionResolver indexNameExpressionResolver, TrainedModelProvider configProvider, InferenceAuditor auditor, IngestService ingestService) {
        super("cluster:admin/xpack/ml/inference/delete", transportService, clusterService, threadPool, actionFilters, DeleteTrainedModelAction.Request::new, indexNameExpressionResolver);
        this.trainedModelProvider = configProvider;
        this.ingestService = ingestService;
        this.auditor = Objects.requireNonNull(auditor);
    }

    protected String executor() {
        return "same";
    }

    protected AcknowledgedResponse read(StreamInput in) throws IOException {
        return new AcknowledgedResponse(in);
    }

    protected void masterOperation(DeleteTrainedModelAction.Request request, ClusterState state, ActionListener<AcknowledgedResponse> listener) {
        String id = request.getId();
        IngestMetadata currentIngestMetadata = (IngestMetadata)state.metadata().custom("ingest");
        Set<String> referencedModels = this.getReferencedModelKeys(currentIngestMetadata);
        if (referencedModels.contains(id)) {
            listener.onFailure((Exception)new ElasticsearchStatusException("Cannot delete model [{}] as it is still referenced by ingest processors", RestStatus.CONFLICT, new Object[]{id}));
            return;
        }
        this.trainedModelProvider.deleteTrainedModel(request.getId(), (ActionListener<Boolean>)ActionListener.wrap(r -> {
            this.auditor.info(request.getId(), "trained model deleted");
            listener.onResponse((Object)new AcknowledgedResponse(true));
        }, arg_0 -> listener.onFailure(arg_0)));
    }

    private Set<String> getReferencedModelKeys(IngestMetadata ingestMetadata) {
        HashSet<String> allReferencedModelKeys = new HashSet<String>();
        if (ingestMetadata == null) {
            return allReferencedModelKeys;
        }
        for (Map.Entry entry : ingestMetadata.getPipelines().entrySet()) {
            String pipelineId = (String)entry.getKey();
            Map config = ((PipelineConfiguration)entry.getValue()).getConfigAsMap();
            try {
                Pipeline pipeline = Pipeline.create((String)pipelineId, (Map)config, (Map)this.ingestService.getProcessorFactories(), (ScriptService)this.ingestService.getScriptService());
                pipeline.getProcessors().stream().filter(p -> p instanceof InferenceProcessor).map(p -> (InferenceProcessor)((Object)p)).map(InferenceProcessor::getModelId).forEach(allReferencedModelKeys::add);
            }
            catch (Exception ex) {
                logger.warn((Message)new ParameterizedMessage("failed to load pipeline [{}]", (Object)pipelineId), (Throwable)ex);
            }
        }
        return allReferencedModelKeys;
    }

    protected ClusterBlockException checkBlock(DeleteTrainedModelAction.Request request, ClusterState state) {
        return state.blocks().globalBlockedException(ClusterBlockLevel.METADATA_WRITE);
    }
}

