/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.ml.action;

import java.util.List;
import org.elasticsearch.ExceptionsHelper;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.FailedNodeException;
import org.elasticsearch.action.TaskOperationFailure;
import org.elasticsearch.action.support.ActionFilters;
import org.elasticsearch.action.support.tasks.BaseTasksRequest;
import org.elasticsearch.action.support.tasks.TransportTasksAction;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.persistent.PersistentTasksCustomMetadata;
import org.elasticsearch.tasks.Task;
import org.elasticsearch.transport.TransportService;
import org.elasticsearch.xpack.core.ml.MlTasks;
import org.elasticsearch.xpack.core.ml.action.IsolateDatafeedAction;
import org.elasticsearch.xpack.ml.action.TransportStartDatafeedAction;

public class TransportIsolateDatafeedAction
extends TransportTasksAction<TransportStartDatafeedAction.DatafeedTask, IsolateDatafeedAction.Request, IsolateDatafeedAction.Response, IsolateDatafeedAction.Response> {
    @Inject
    public TransportIsolateDatafeedAction(TransportService transportService, ActionFilters actionFilters, ClusterService clusterService) {
        super("cluster:internal/xpack/ml/datafeed/isolate", clusterService, transportService, actionFilters, IsolateDatafeedAction.Request::new, IsolateDatafeedAction.Response::new, IsolateDatafeedAction.Response::new, "ml_utility");
    }

    protected void doExecute(Task task, IsolateDatafeedAction.Request request, ActionListener<IsolateDatafeedAction.Response> listener) {
        ClusterState state = this.clusterService.state();
        PersistentTasksCustomMetadata tasks = (PersistentTasksCustomMetadata)state.getMetadata().custom("persistent_tasks");
        PersistentTasksCustomMetadata.PersistentTask datafeedTask = MlTasks.getDatafeedTask((String)request.getDatafeedId(), (PersistentTasksCustomMetadata)tasks);
        if (datafeedTask == null || datafeedTask.getExecutorNode() == null) {
            listener.onResponse((Object)new IsolateDatafeedAction.Response(false));
            return;
        }
        request.setNodes(new String[]{datafeedTask.getExecutorNode()});
        super.doExecute(task, (BaseTasksRequest)request, listener);
    }

    protected IsolateDatafeedAction.Response newResponse(IsolateDatafeedAction.Request request, List<IsolateDatafeedAction.Response> tasks, List<TaskOperationFailure> taskOperationFailures, List<FailedNodeException> failedNodeExceptions) {
        if (!taskOperationFailures.isEmpty()) {
            throw ExceptionsHelper.convertToElastic((Exception)taskOperationFailures.get(0).getCause());
        }
        if (!failedNodeExceptions.isEmpty()) {
            throw ExceptionsHelper.convertToElastic((Exception)((Exception)failedNodeExceptions.get(0)));
        }
        return new IsolateDatafeedAction.Response(false);
    }

    protected void taskOperation(IsolateDatafeedAction.Request request, TransportStartDatafeedAction.DatafeedTask datafeedTask, ActionListener<IsolateDatafeedAction.Response> listener) {
        datafeedTask.isolate();
        listener.onResponse((Object)new IsolateDatafeedAction.Response(false));
    }
}

