/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.ml.action;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Predicate;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.message.Message;
import org.apache.logging.log4j.message.ParameterizedMessage;
import org.elasticsearch.ElasticsearchException;
import org.elasticsearch.ElasticsearchStatusException;
import org.elasticsearch.ResourceAlreadyExistsException;
import org.elasticsearch.ResourceNotFoundException;
import org.elasticsearch.Version;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.ActionType;
import org.elasticsearch.action.support.ActionFilters;
import org.elasticsearch.action.support.IndicesOptions;
import org.elasticsearch.action.support.master.TransportMasterNodeAction;
import org.elasticsearch.client.Client;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.block.ClusterBlockException;
import org.elasticsearch.cluster.block.ClusterBlockLevel;
import org.elasticsearch.cluster.metadata.IndexNameExpressionResolver;
import org.elasticsearch.cluster.node.DiscoveryNode;
import org.elasticsearch.cluster.routing.IndexRoutingTable;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.unit.TimeValue;
import org.elasticsearch.index.engine.DocumentMissingException;
import org.elasticsearch.license.LicenseUtils;
import org.elasticsearch.license.XPackLicenseState;
import org.elasticsearch.persistent.AllocatedPersistentTask;
import org.elasticsearch.persistent.PersistentTaskParams;
import org.elasticsearch.persistent.PersistentTaskState;
import org.elasticsearch.persistent.PersistentTasksCustomMetadata;
import org.elasticsearch.persistent.PersistentTasksExecutor;
import org.elasticsearch.persistent.PersistentTasksService;
import org.elasticsearch.persistent.decider.EnableAssignmentDecider;
import org.elasticsearch.rest.RestStatus;
import org.elasticsearch.tasks.TaskId;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.TransportService;
import org.elasticsearch.xpack.core.ClientHelper;
import org.elasticsearch.xpack.core.ml.MlConfigIndex;
import org.elasticsearch.xpack.core.ml.MlMetaIndex;
import org.elasticsearch.xpack.core.ml.MlMetadata;
import org.elasticsearch.xpack.core.ml.MlTasks;
import org.elasticsearch.xpack.core.ml.action.FinalizeJobExecutionAction;
import org.elasticsearch.xpack.core.ml.action.NodeAcknowledgedResponse;
import org.elasticsearch.xpack.core.ml.action.OpenJobAction;
import org.elasticsearch.xpack.core.ml.job.config.Job;
import org.elasticsearch.xpack.core.ml.job.config.JobState;
import org.elasticsearch.xpack.core.ml.job.config.JobTaskState;
import org.elasticsearch.xpack.core.ml.job.config.JobUpdate;
import org.elasticsearch.xpack.core.ml.job.persistence.AnomalyDetectorsIndex;
import org.elasticsearch.xpack.core.ml.job.persistence.ElasticsearchMappings;
import org.elasticsearch.xpack.core.ml.utils.ExceptionsHelper;
import org.elasticsearch.xpack.ml.MachineLearning;
import org.elasticsearch.xpack.ml.MlConfigMigrationEligibilityCheck;
import org.elasticsearch.xpack.ml.job.JobNodeSelector;
import org.elasticsearch.xpack.ml.job.persistence.JobConfigProvider;
import org.elasticsearch.xpack.ml.job.persistence.JobResultsProvider;
import org.elasticsearch.xpack.ml.job.process.autodetect.AutodetectProcessManager;
import org.elasticsearch.xpack.ml.process.MlMemoryTracker;

public class TransportOpenJobAction
extends TransportMasterNodeAction<OpenJobAction.Request, NodeAcknowledgedResponse> {
    private static final Logger logger = LogManager.getLogger(TransportOpenJobAction.class);
    static final PersistentTasksCustomMetadata.Assignment AWAITING_MIGRATION = new PersistentTasksCustomMetadata.Assignment(null, "job cannot be assigned until it has been migrated.");
    private final XPackLicenseState licenseState;
    private final PersistentTasksService persistentTasksService;
    private final JobConfigProvider jobConfigProvider;
    private final MlMemoryTracker memoryTracker;
    private final MlConfigMigrationEligibilityCheck migrationEligibilityCheck;
    private final Client client;

    @Inject
    public TransportOpenJobAction(Settings settings, TransportService transportService, ThreadPool threadPool, XPackLicenseState licenseState, ClusterService clusterService, PersistentTasksService persistentTasksService, ActionFilters actionFilters, IndexNameExpressionResolver indexNameExpressionResolver, JobConfigProvider jobConfigProvider, MlMemoryTracker memoryTracker, Client client) {
        super("cluster:admin/xpack/ml/job/open", transportService, clusterService, threadPool, actionFilters, OpenJobAction.Request::new, indexNameExpressionResolver);
        this.licenseState = licenseState;
        this.persistentTasksService = persistentTasksService;
        this.jobConfigProvider = jobConfigProvider;
        this.memoryTracker = memoryTracker;
        this.migrationEligibilityCheck = new MlConfigMigrationEligibilityCheck(settings, clusterService);
        this.client = client;
    }

    static void validate(String jobId, Job job) {
        if (job == null) {
            throw ExceptionsHelper.missingJobException((String)jobId);
        }
        if (job.isDeleting()) {
            throw ExceptionsHelper.conflictStatusException((String)("Cannot open job [" + jobId + "] because it is being deleted"), (Object[])new Object[0]);
        }
        if (job.getJobVersion() == null) {
            throw ExceptionsHelper.badRequestException((String)("Cannot open job [" + jobId + "] because jobs created prior to version 5.5 are not supported"), (Object[])new Object[0]);
        }
    }

    static String[] indicesOfInterest(String resultsIndex) {
        if (resultsIndex == null) {
            return new String[]{AnomalyDetectorsIndex.jobStateIndexPattern(), MlMetaIndex.indexName(), MlConfigIndex.indexName()};
        }
        return new String[]{AnomalyDetectorsIndex.jobStateIndexPattern(), resultsIndex, MlMetaIndex.indexName(), MlConfigIndex.indexName()};
    }

    static List<String> verifyIndicesPrimaryShardsAreActive(String resultsWriteIndex, ClusterState clusterState, IndexNameExpressionResolver expressionResolver) {
        String[] indices = expressionResolver.concreteIndexNames(clusterState, IndicesOptions.lenientExpandOpen(), TransportOpenJobAction.indicesOfInterest(resultsWriteIndex));
        ArrayList<String> unavailableIndices = new ArrayList<String>(indices.length);
        for (String index : indices) {
            IndexRoutingTable routingTable;
            if (!clusterState.metadata().hasIndex(index) || (routingTable = clusterState.getRoutingTable().index(index)) != null && routingTable.allPrimaryShardsActive()) continue;
            unavailableIndices.add(index);
        }
        return unavailableIndices;
    }

    private static boolean nodeSupportsModelSnapshotVersion(DiscoveryNode node, Job job) {
        if (job.getModelSnapshotId() == null || job.getModelSnapshotMinVersion() == null) {
            return true;
        }
        return node.getVersion().onOrAfter(job.getModelSnapshotMinVersion());
    }

    public static String nodeFilter(DiscoveryNode node, Job job) {
        String jobId = job.getId();
        if (!TransportOpenJobAction.nodeSupportsModelSnapshotVersion(node, job)) {
            return "Not opening job [" + jobId + "] on node [" + JobNodeSelector.nodeNameAndVersion(node) + "], because the job's model snapshot requires a node of version [" + job.getModelSnapshotMinVersion() + "] or higher";
        }
        if (!Job.getCompatibleJobTypes((Version)node.getVersion()).contains(job.getJobType())) {
            return "Not opening job [" + jobId + "] on node [" + JobNodeSelector.nodeNameAndVersion(node) + "], because this node does not support jobs of type [" + job.getJobType() + "]";
        }
        return null;
    }

    protected String executor() {
        return "same";
    }

    protected NodeAcknowledgedResponse read(StreamInput in) throws IOException {
        return new NodeAcknowledgedResponse(in);
    }

    protected ClusterBlockException checkBlock(OpenJobAction.Request request, ClusterState state) {
        return state.blocks().globalBlockedException(ClusterBlockLevel.METADATA_WRITE);
    }

    protected void masterOperation(OpenJobAction.Request request, ClusterState state, final ActionListener<NodeAcknowledgedResponse> listener) {
        if (this.migrationEligibilityCheck.jobIsEligibleForMigration(request.getJobParams().getJobId(), state)) {
            listener.onFailure((Exception)ExceptionsHelper.configHasNotBeenMigrated((String)"open job", (String)request.getJobParams().getJobId()));
            return;
        }
        final OpenJobAction.JobParams jobParams = request.getJobParams();
        if (this.licenseState.checkFeature(XPackLicenseState.Feature.MACHINE_LEARNING)) {
            final ActionListener clearJobFinishTime = ActionListener.wrap(response -> {
                if (response.isAcknowledged()) {
                    this.clearJobFinishedTime((NodeAcknowledgedResponse)response, state, jobParams.getJobId(), listener);
                } else {
                    listener.onResponse(response);
                }
            }, arg_0 -> listener.onFailure(arg_0));
            ActionListener<PersistentTasksCustomMetadata.PersistentTask<OpenJobAction.JobParams>> waitForJobToStart = new ActionListener<PersistentTasksCustomMetadata.PersistentTask<OpenJobAction.JobParams>>(){

                public void onResponse(PersistentTasksCustomMetadata.PersistentTask<OpenJobAction.JobParams> task) {
                    TransportOpenJobAction.this.waitForJobStarted(task.getId(), jobParams, (ActionListener<NodeAcknowledgedResponse>)clearJobFinishTime);
                }

                public void onFailure(Exception e) {
                    if (ExceptionsHelper.unwrapCause((Throwable)e) instanceof ResourceAlreadyExistsException) {
                        e = new ElasticsearchStatusException("Cannot open job [" + jobParams.getJobId() + "] because it has already been opened", RestStatus.CONFLICT, (Throwable)e, new Object[0]);
                    }
                    listener.onFailure(e);
                }
            };
            ActionListener memoryRequirementRefreshListener = ActionListener.wrap(arg_0 -> this.lambda$masterOperation$1(jobParams, (ActionListener)waitForJobToStart, arg_0), arg_0 -> listener.onFailure(arg_0));
            ActionListener getJobHandler = ActionListener.wrap(response -> this.memoryTracker.refreshAnomalyDetectorJobMemoryAndAllOthers(jobParams.getJobId(), (ActionListener<Long>)memoryRequirementRefreshListener), arg_0 -> listener.onFailure(arg_0));
            this.jobConfigProvider.getJob(jobParams.getJobId(), (ActionListener<Job.Builder>)ActionListener.wrap(builder -> {
                jobParams.setJob(builder.build());
                getJobHandler.onResponse(null);
            }, arg_0 -> listener.onFailure(arg_0)));
        } else {
            listener.onFailure((Exception)LicenseUtils.newComplianceException((String)"ml"));
        }
    }

    private void waitForJobStarted(String taskId, final OpenJobAction.JobParams jobParams, final ActionListener<NodeAcknowledgedResponse> listener) {
        final JobPredicate predicate = new JobPredicate();
        this.persistentTasksService.waitForPersistentTaskCondition(taskId, (Predicate)predicate, jobParams.getTimeout(), (PersistentTasksService.WaitForPersistentTaskListener)new PersistentTasksService.WaitForPersistentTaskListener<OpenJobAction.JobParams>(){

            public void onResponse(PersistentTasksCustomMetadata.PersistentTask<OpenJobAction.JobParams> persistentTask) {
                if (predicate.exception != null) {
                    if (predicate.shouldCancel) {
                        TransportOpenJobAction.this.cancelJobStart((PersistentTasksCustomMetadata.PersistentTask<OpenJobAction.JobParams>)persistentTask, predicate.exception, (ActionListener<NodeAcknowledgedResponse>)listener);
                    } else {
                        listener.onFailure(predicate.exception);
                    }
                } else {
                    listener.onResponse((Object)new NodeAcknowledgedResponse(true, predicate.node));
                }
            }

            public void onFailure(Exception e) {
                listener.onFailure(e);
            }

            public void onTimeout(TimeValue timeout) {
                listener.onFailure((Exception)((Object)new ElasticsearchException("Opening job [" + jobParams.getJobId() + "] timed out after [" + timeout + "]", new Object[0])));
            }
        });
    }

    private void clearJobFinishedTime(NodeAcknowledgedResponse response, ClusterState clusterState, String jobId, ActionListener<NodeAcknowledgedResponse> listener) {
        JobUpdate update = new JobUpdate.Builder(jobId).setClearFinishTime(true).build();
        ActionListener clearedTimeListener = ActionListener.wrap(job -> listener.onResponse((Object)response), e -> {
            logger.error((Message)new ParameterizedMessage("[{}] Failed to clear finished_time", (Object)jobId), (Throwable)e);
            listener.onResponse((Object)response);
        });
        ActionListener mappingsUpdatedListener = ActionListener.wrap(mappingUpdateResponse -> this.jobConfigProvider.updateJob(jobId, update, null, (ActionListener<Job>)clearedTimeListener), e -> {
            logger.error((Message)new ParameterizedMessage("[{}] Failed to update mapping; not clearing finished_time", (Object)jobId), (Throwable)e);
            listener.onResponse((Object)response);
        });
        ElasticsearchMappings.addDocMappingIfMissing((String)MlConfigIndex.indexName(), MlConfigIndex::mapping, (Client)this.client, (ClusterState)clusterState, (ActionListener)mappingsUpdatedListener);
    }

    private void cancelJobStart(final PersistentTasksCustomMetadata.PersistentTask<OpenJobAction.JobParams> persistentTask, final Exception exception, final ActionListener<NodeAcknowledgedResponse> listener) {
        this.persistentTasksService.sendRemoveRequest(persistentTask.getId(), new ActionListener<PersistentTasksCustomMetadata.PersistentTask<?>>(){

            public void onResponse(PersistentTasksCustomMetadata.PersistentTask<?> task) {
                listener.onFailure(exception);
            }

            public void onFailure(Exception e) {
                logger.error("[" + ((OpenJobAction.JobParams)persistentTask.getParams()).getJobId() + "] Failed to cancel persistent task that could not be assigned due to [" + exception.getMessage() + "]", (Throwable)e);
                listener.onFailure(exception);
            }
        });
    }

    static ElasticsearchException makeNoSuitableNodesException(Logger logger, String jobId, String explanation) {
        String msg = "Could not open job because no suitable nodes were found, allocation explanation [" + explanation + "]";
        logger.warn("[{}] {}", (Object)jobId, (Object)msg);
        IllegalStateException detail = new IllegalStateException(msg);
        return new ElasticsearchStatusException("Could not open job because no ML nodes with sufficient capacity were found", RestStatus.TOO_MANY_REQUESTS, (Throwable)detail, new Object[0]);
    }

    static ElasticsearchException makeAssignmentsNotAllowedException(Logger logger, String jobId) {
        String msg = "Cannot open jobs because persistent task assignment is disabled by the [" + EnableAssignmentDecider.CLUSTER_TASKS_ALLOCATION_ENABLE_SETTING.getKey() + "] setting";
        logger.warn("[{}] {}", (Object)jobId, (Object)msg);
        return new ElasticsearchStatusException(msg, RestStatus.TOO_MANY_REQUESTS, new Object[0]);
    }

    static ElasticsearchException makeCurrentlyBeingUpgradedException(Logger logger, String jobId, String explanation) {
        String msg = "Cannot open jobs when upgrade mode is enabled";
        logger.warn("[{}] {}", (Object)jobId, (Object)msg);
        return new ElasticsearchStatusException(msg, RestStatus.TOO_MANY_REQUESTS, new Object[0]);
    }

    private /* synthetic */ void lambda$masterOperation$1(OpenJobAction.JobParams jobParams, ActionListener waitForJobToStart, Long mem) throws Exception {
        this.persistentTasksService.sendStartRequest(MlTasks.jobTaskId((String)jobParams.getJobId()), "xpack/ml/job", (PersistentTaskParams)jobParams, waitForJobToStart);
    }

    private static class JobPredicate
    implements Predicate<PersistentTasksCustomMetadata.PersistentTask<?>> {
        private volatile Exception exception;
        private volatile String node = "";
        private volatile boolean shouldCancel;

        private JobPredicate() {
        }

        @Override
        public boolean test(PersistentTasksCustomMetadata.PersistentTask<?> persistentTask) {
            JobState jobState = JobState.CLOSED;
            if (persistentTask != null) {
                JobTaskState jobTaskState = (JobTaskState)persistentTask.getState();
                jobState = jobTaskState == null ? JobState.OPENING : jobTaskState.getState();
                PersistentTasksCustomMetadata.Assignment assignment = persistentTask.getAssignment();
                if (assignment != null && assignment.equals((Object)JobNodeSelector.AWAITING_LAZY_ASSIGNMENT)) {
                    return true;
                }
                if (assignment != null && !assignment.equals((Object)PersistentTasksCustomMetadata.INITIAL_ASSIGNMENT) && !assignment.isAssigned()) {
                    OpenJobAction.JobParams params = (OpenJobAction.JobParams)persistentTask.getParams();
                    this.exception = assignment.equals((Object)MlTasks.AWAITING_UPGRADE) ? TransportOpenJobAction.makeCurrentlyBeingUpgradedException(logger, params.getJobId(), assignment.getExplanation()) : (assignment.getExplanation().contains("[no persistent task assignments are allowed due to cluster settings]") ? TransportOpenJobAction.makeAssignmentsNotAllowedException(logger, params.getJobId()) : TransportOpenJobAction.makeNoSuitableNodesException(logger, params.getJobId(), assignment.getExplanation()));
                    this.shouldCancel = true;
                    return true;
                }
            }
            switch (jobState) {
                case OPENING: 
                case CLOSED: {
                    return false;
                }
                case OPENED: {
                    this.node = persistentTask.getExecutorNode();
                    return true;
                }
                case CLOSING: {
                    this.exception = ExceptionsHelper.conflictStatusException((String)("The job has been " + JobState.CLOSED + " while waiting to be " + JobState.OPENED), (Object[])new Object[0]);
                    return true;
                }
            }
            this.exception = ExceptionsHelper.serverError((String)("Unexpected job state [" + jobState + "] while waiting for job to be " + JobState.OPENED));
            return true;
        }
    }

    public static class JobTask
    extends AllocatedPersistentTask
    implements OpenJobAction.JobTaskMatcher {
        private static final Logger LOGGER = LogManager.getLogger(JobTask.class);
        private final String jobId;
        private volatile AutodetectProcessManager autodetectProcessManager;

        JobTask(String jobId, long id, String type, String action, TaskId parentTask, Map<String, String> headers) {
            super(id, type, action, "job-" + jobId, parentTask, headers);
            this.jobId = jobId;
        }

        public String getJobId() {
            return this.jobId;
        }

        protected void onCancelled() {
            String reason = this.getReasonCancelled();
            LOGGER.trace("[{}] Cancelling job task because: {}", (Object)this.jobId, (Object)reason);
            this.killJob(reason);
        }

        void killJob(String reason) {
            this.autodetectProcessManager.killProcess(this, false, reason);
        }

        void closeJob(String reason) {
            this.autodetectProcessManager.closeJob(this, false, reason);
        }
    }

    public static class OpenJobPersistentTasksExecutor
    extends PersistentTasksExecutor<OpenJobAction.JobParams> {
        private static final Logger logger = LogManager.getLogger(OpenJobPersistentTasksExecutor.class);
        private final AutodetectProcessManager autodetectProcessManager;
        private final MlMemoryTracker memoryTracker;
        private final Client client;
        private final IndexNameExpressionResolver expressionResolver;
        private final JobResultsProvider jobResultsProvider;
        private volatile int maxConcurrentJobAllocations;
        private volatile int maxMachineMemoryPercent;
        private volatile int maxLazyMLNodes;
        private volatile int maxOpenJobs;
        private volatile ClusterState clusterState;

        public OpenJobPersistentTasksExecutor(Settings settings, ClusterService clusterService, AutodetectProcessManager autodetectProcessManager, MlMemoryTracker memoryTracker, Client client, IndexNameExpressionResolver expressionResolver) {
            super("xpack/ml/job", "ml_utility");
            this.autodetectProcessManager = Objects.requireNonNull(autodetectProcessManager);
            this.memoryTracker = Objects.requireNonNull(memoryTracker);
            this.client = Objects.requireNonNull(client);
            this.expressionResolver = Objects.requireNonNull(expressionResolver);
            this.jobResultsProvider = new JobResultsProvider(client, settings, expressionResolver);
            this.maxConcurrentJobAllocations = (Integer)MachineLearning.CONCURRENT_JOB_ALLOCATIONS.get(settings);
            this.maxMachineMemoryPercent = (Integer)MachineLearning.MAX_MACHINE_MEMORY_PERCENT.get(settings);
            this.maxLazyMLNodes = (Integer)MachineLearning.MAX_LAZY_ML_NODES.get(settings);
            this.maxOpenJobs = (Integer)MachineLearning.MAX_OPEN_JOBS_PER_NODE.get(settings);
            clusterService.getClusterSettings().addSettingsUpdateConsumer(MachineLearning.CONCURRENT_JOB_ALLOCATIONS, this::setMaxConcurrentJobAllocations);
            clusterService.getClusterSettings().addSettingsUpdateConsumer(MachineLearning.MAX_MACHINE_MEMORY_PERCENT, this::setMaxMachineMemoryPercent);
            clusterService.getClusterSettings().addSettingsUpdateConsumer(MachineLearning.MAX_LAZY_ML_NODES, this::setMaxLazyMLNodes);
            clusterService.getClusterSettings().addSettingsUpdateConsumer(MachineLearning.MAX_OPEN_JOBS_PER_NODE, this::setMaxOpenJobs);
            clusterService.addListener(event -> {
                this.clusterState = event.state();
            });
        }

        public PersistentTasksCustomMetadata.Assignment getAssignment(OpenJobAction.JobParams params, ClusterState clusterState) {
            boolean scheduledRefresh;
            Job job = params.getJob();
            if (job == null) {
                return AWAITING_MIGRATION;
            }
            if (MlMetadata.getMlMetadata((ClusterState)clusterState).isUpgradeMode()) {
                return MlTasks.AWAITING_UPGRADE;
            }
            String jobId = params.getJobId();
            String resultsWriteAlias = AnomalyDetectorsIndex.resultsWriteAlias((String)jobId);
            List<String> unavailableIndices = TransportOpenJobAction.verifyIndicesPrimaryShardsAreActive(resultsWriteAlias, clusterState, this.expressionResolver);
            if (unavailableIndices.size() != 0) {
                String reason = "Not opening job [" + jobId + "], because not all primary shards are active for the following indices [" + String.join((CharSequence)",", unavailableIndices) + "]";
                logger.debug(reason);
                return new PersistentTasksCustomMetadata.Assignment(null, reason);
            }
            boolean isMemoryTrackerRecentlyRefreshed = this.memoryTracker.isRecentlyRefreshed();
            if (!isMemoryTrackerRecentlyRefreshed && (scheduledRefresh = this.memoryTracker.asyncRefresh())) {
                String reason = "Not opening job [" + jobId + "] because job memory requirements are stale - refresh requested";
                logger.debug(reason);
                return new PersistentTasksCustomMetadata.Assignment(null, reason);
            }
            JobNodeSelector jobNodeSelector = new JobNodeSelector(clusterState, jobId, "xpack/ml/job", this.memoryTracker, job.allowLazyOpen() ? Integer.MAX_VALUE : this.maxLazyMLNodes, node -> TransportOpenJobAction.nodeFilter(node, job));
            return jobNodeSelector.selectNode(this.maxOpenJobs, this.maxConcurrentJobAllocations, this.maxMachineMemoryPercent, isMemoryTrackerRecentlyRefreshed);
        }

        public void validate(OpenJobAction.JobParams params, ClusterState clusterState) {
            TransportOpenJobAction.validate(params.getJobId(), params.getJob());
            PersistentTasksCustomMetadata.Assignment assignment = this.getAssignment(params, clusterState);
            if (assignment.equals((Object)MlTasks.AWAITING_UPGRADE)) {
                throw TransportOpenJobAction.makeCurrentlyBeingUpgradedException(logger, params.getJobId(), assignment.getExplanation());
            }
            if (assignment.getExecutorNode() == null && !assignment.equals((Object)JobNodeSelector.AWAITING_LAZY_ASSIGNMENT)) {
                throw TransportOpenJobAction.makeNoSuitableNodesException(logger, params.getJobId(), assignment.getExplanation());
            }
        }

        protected void nodeOperation(AllocatedPersistentTask task, OpenJobAction.JobParams params, PersistentTaskState state) {
            JobTask jobTask = (JobTask)task;
            jobTask.autodetectProcessManager = this.autodetectProcessManager;
            JobTaskState jobTaskState = (JobTaskState)state;
            JobState jobState = jobTaskState == null ? null : jobTaskState.getState();
            this.jobResultsProvider.setRunningForecastsToFailed(params.getJobId(), (ActionListener<Boolean>)ActionListener.wrap(r -> this.runJob(jobTask, jobState, params), e -> {
                logger.warn((Message)new ParameterizedMessage("[{}] failed to set forecasts to failed", (Object)params.getJobId()), (Throwable)e);
                this.runJob(jobTask, jobState, params);
            }));
        }

        private void runJob(JobTask jobTask, JobState jobState, OpenJobAction.JobParams params) {
            if (JobState.CLOSING.equals((Object)jobState)) {
                logger.info("[{}] job got reassigned while stopping. Marking as completed", (Object)params.getJobId());
                jobTask.markAsCompleted();
                return;
            }
            if (JobState.FAILED.equals((Object)jobState)) {
                return;
            }
            String jobId = jobTask.getJobId();
            this.autodetectProcessManager.openJob(jobTask, this.clusterState, (e2, shouldFinalizeJob) -> {
                if (e2 == null) {
                    if (shouldFinalizeJob.booleanValue()) {
                        FinalizeJobExecutionAction.Request finalizeRequest = new FinalizeJobExecutionAction.Request(new String[]{jobId});
                        ClientHelper.executeAsyncWithOrigin((Client)this.client, (String)"ml", (ActionType)FinalizeJobExecutionAction.INSTANCE, (ActionRequest)finalizeRequest, (ActionListener)ActionListener.wrap(response -> jobTask.markAsCompleted(), e -> {
                            logger.error("error finalizing job [" + jobId + "]", (Throwable)e);
                            Throwable unwrapped = ExceptionsHelper.unwrapCause((Throwable)e);
                            if (unwrapped instanceof DocumentMissingException || unwrapped instanceof ResourceNotFoundException) {
                                jobTask.markAsCompleted();
                            } else {
                                jobTask.markAsFailed((Exception)e);
                            }
                        }));
                    } else {
                        jobTask.markAsCompleted();
                    }
                } else {
                    jobTask.markAsFailed((Exception)e2);
                }
            });
        }

        protected AllocatedPersistentTask createTask(long id, String type, String action, TaskId parentTaskId, PersistentTasksCustomMetadata.PersistentTask<OpenJobAction.JobParams> persistentTask, Map<String, String> headers) {
            return new JobTask(((OpenJobAction.JobParams)persistentTask.getParams()).getJobId(), id, type, action, parentTaskId, headers);
        }

        void setMaxConcurrentJobAllocations(int maxConcurrentJobAllocations) {
            this.maxConcurrentJobAllocations = maxConcurrentJobAllocations;
        }

        void setMaxMachineMemoryPercent(int maxMachineMemoryPercent) {
            this.maxMachineMemoryPercent = maxMachineMemoryPercent;
        }

        void setMaxLazyMLNodes(int maxLazyMLNodes) {
            this.maxLazyMLNodes = maxLazyMLNodes;
        }

        void setMaxOpenJobs(int maxOpenJobs) {
            this.maxOpenJobs = maxOpenJobs;
        }
    }
}

