/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.ml.action;

import java.io.IOException;
import java.time.Instant;
import java.util.Map;
import java.util.Objects;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.Version;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.ActionType;
import org.elasticsearch.action.support.ActionFilters;
import org.elasticsearch.action.support.master.MasterNodeRequest;
import org.elasticsearch.action.support.master.TransportMasterNodeAction;
import org.elasticsearch.client.Client;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.block.ClusterBlockException;
import org.elasticsearch.cluster.block.ClusterBlockLevel;
import org.elasticsearch.cluster.metadata.IndexNameExpressionResolver;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.unit.ByteSizeValue;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.json.JsonXContent;
import org.elasticsearch.license.License;
import org.elasticsearch.license.LicenseUtils;
import org.elasticsearch.license.XPackLicenseState;
import org.elasticsearch.tasks.Task;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.TransportService;
import org.elasticsearch.xpack.core.XPackSettings;
import org.elasticsearch.xpack.core.common.validation.SourceDestValidator;
import org.elasticsearch.xpack.core.ml.MachineLearningField;
import org.elasticsearch.xpack.core.ml.MlConfigIndex;
import org.elasticsearch.xpack.core.ml.action.PutDataFrameAnalyticsAction;
import org.elasticsearch.xpack.core.ml.dataframe.DataFrameAnalyticsConfig;
import org.elasticsearch.xpack.core.ml.job.messages.Messages;
import org.elasticsearch.xpack.core.ml.job.persistence.ElasticsearchMappings;
import org.elasticsearch.xpack.core.security.SecurityContext;
import org.elasticsearch.xpack.core.security.action.user.HasPrivilegesAction;
import org.elasticsearch.xpack.core.security.action.user.HasPrivilegesRequest;
import org.elasticsearch.xpack.core.security.action.user.HasPrivilegesResponse;
import org.elasticsearch.xpack.core.security.authz.RoleDescriptor;
import org.elasticsearch.xpack.core.security.authz.permission.ResourcePrivileges;
import org.elasticsearch.xpack.core.security.support.Exceptions;
import org.elasticsearch.xpack.ml.dataframe.SourceDestValidations;
import org.elasticsearch.xpack.ml.dataframe.persistence.DataFrameAnalyticsConfigProvider;
import org.elasticsearch.xpack.ml.notifications.DataFrameAnalyticsAuditor;
import org.elasticsearch.xpack.ml.utils.SecondaryAuthorizationUtils;

public class TransportPutDataFrameAnalyticsAction
extends TransportMasterNodeAction<PutDataFrameAnalyticsAction.Request, PutDataFrameAnalyticsAction.Response> {
    private static final Logger logger = LogManager.getLogger(TransportPutDataFrameAnalyticsAction.class);
    private final XPackLicenseState licenseState;
    private final DataFrameAnalyticsConfigProvider configProvider;
    private final SecurityContext securityContext;
    private final Client client;
    private final DataFrameAnalyticsAuditor auditor;
    private final SourceDestValidator sourceDestValidator;
    private volatile ByteSizeValue maxModelMemoryLimit;

    @Inject
    public TransportPutDataFrameAnalyticsAction(Settings settings, TransportService transportService, ActionFilters actionFilters, XPackLicenseState licenseState, Client client, ThreadPool threadPool, ClusterService clusterService, IndexNameExpressionResolver indexNameExpressionResolver, DataFrameAnalyticsConfigProvider configProvider, DataFrameAnalyticsAuditor auditor) {
        super("cluster:admin/xpack/ml/data_frame/analytics/put", transportService, clusterService, threadPool, actionFilters, PutDataFrameAnalyticsAction.Request::new, indexNameExpressionResolver);
        this.licenseState = licenseState;
        this.configProvider = configProvider;
        this.securityContext = (Boolean)XPackSettings.SECURITY_ENABLED.get(settings) != false ? new SecurityContext(settings, threadPool.getThreadContext()) : null;
        this.client = client;
        this.auditor = Objects.requireNonNull(auditor);
        this.maxModelMemoryLimit = (ByteSizeValue)MachineLearningField.MAX_MODEL_MEMORY_LIMIT.get(settings);
        clusterService.getClusterSettings().addSettingsUpdateConsumer(MachineLearningField.MAX_MODEL_MEMORY_LIMIT, this::setMaxModelMemoryLimit);
        this.sourceDestValidator = new SourceDestValidator(indexNameExpressionResolver, transportService.getRemoteClusterService(), null, null, clusterService.getNodeName(), License.OperationMode.PLATINUM.description());
    }

    private void setMaxModelMemoryLimit(ByteSizeValue maxModelMemoryLimit) {
        this.maxModelMemoryLimit = maxModelMemoryLimit;
    }

    protected String executor() {
        return "same";
    }

    protected PutDataFrameAnalyticsAction.Response read(StreamInput in) throws IOException {
        return new PutDataFrameAnalyticsAction.Response(in);
    }

    protected ClusterBlockException checkBlock(PutDataFrameAnalyticsAction.Request request, ClusterState state) {
        return state.blocks().globalBlockedException(ClusterBlockLevel.METADATA_WRITE);
    }

    protected void masterOperation(PutDataFrameAnalyticsAction.Request request, ClusterState state, ActionListener<PutDataFrameAnalyticsAction.Response> listener) {
        DataFrameAnalyticsConfig config = request.getConfig();
        ActionListener sourceDestValidationListener = ActionListener.wrap(aBoolean -> this.putValidatedConfig(config, listener), arg_0 -> listener.onFailure(arg_0));
        this.sourceDestValidator.validate(this.clusterService.state(), config.getSource().getIndex(), config.getDest().getIndex(), null, SourceDestValidations.ALL_VALIDATIONS, sourceDestValidationListener);
    }

    private void putValidatedConfig(DataFrameAnalyticsConfig config, ActionListener<PutDataFrameAnalyticsAction.Response> listener) {
        DataFrameAnalyticsConfig preparedForPutConfig = new DataFrameAnalyticsConfig.Builder(config, this.maxModelMemoryLimit).setCreateTime(Instant.now()).setVersion(Version.CURRENT).build();
        if (this.licenseState.isSecurityEnabled()) {
            SecondaryAuthorizationUtils.useSecondaryAuthIfAvailable(this.securityContext, () -> {
                String username = this.securityContext.getUser().principal();
                RoleDescriptor.IndicesPrivileges sourceIndexPrivileges = RoleDescriptor.IndicesPrivileges.builder().indices(preparedForPutConfig.getSource().getIndex()).privileges(new String[]{"read"}).build();
                RoleDescriptor.IndicesPrivileges destIndexPrivileges = RoleDescriptor.IndicesPrivileges.builder().indices(new String[]{preparedForPutConfig.getDest().getIndex()}).privileges(new String[]{"read", "index", "create_index"}).build();
                HasPrivilegesRequest privRequest = new HasPrivilegesRequest();
                privRequest.applicationPrivileges(new RoleDescriptor.ApplicationResourcePrivileges[0]);
                privRequest.username(username);
                privRequest.clusterPrivileges(Strings.EMPTY_ARRAY);
                privRequest.indexPrivileges(new RoleDescriptor.IndicesPrivileges[]{sourceIndexPrivileges, destIndexPrivileges});
                ActionListener privResponseListener = ActionListener.wrap(r -> this.handlePrivsResponse(username, preparedForPutConfig, (HasPrivilegesResponse)r, listener), arg_0 -> ((ActionListener)listener).onFailure(arg_0));
                this.client.execute((ActionType)HasPrivilegesAction.INSTANCE, (ActionRequest)privRequest, privResponseListener);
            });
        } else {
            this.updateDocMappingAndPutConfig(preparedForPutConfig, this.threadPool.getThreadContext().getHeaders(), (ActionListener<DataFrameAnalyticsConfig>)ActionListener.wrap(unused -> listener.onResponse((Object)new PutDataFrameAnalyticsAction.Response(preparedForPutConfig)), arg_0 -> listener.onFailure(arg_0)));
        }
    }

    private void handlePrivsResponse(String username, DataFrameAnalyticsConfig memoryCappedConfig, HasPrivilegesResponse response, ActionListener<PutDataFrameAnalyticsAction.Response> listener) throws IOException {
        if (response.isCompleteMatch()) {
            this.updateDocMappingAndPutConfig(memoryCappedConfig, this.threadPool.getThreadContext().getHeaders(), (ActionListener<DataFrameAnalyticsConfig>)ActionListener.wrap(unused -> listener.onResponse((Object)new PutDataFrameAnalyticsAction.Response(memoryCappedConfig)), arg_0 -> listener.onFailure(arg_0)));
        } else {
            XContentBuilder builder = JsonXContent.contentBuilder();
            builder.startObject();
            for (ResourcePrivileges index : response.getIndexPrivileges()) {
                builder.field(index.getResource());
                builder.map(index.getPrivileges());
            }
            builder.endObject();
            listener.onFailure((Exception)Exceptions.authorizationError((String)"Cannot create data frame analytics [{}] because user {} lacks permissions on the indices: {}", (Object[])new Object[]{memoryCappedConfig.getId(), username, Strings.toString((XContentBuilder)builder)}));
        }
    }

    private void updateDocMappingAndPutConfig(DataFrameAnalyticsConfig config, Map<String, String> headers, ActionListener<DataFrameAnalyticsConfig> listener) {
        ClusterState clusterState = this.clusterService.state();
        if (clusterState == null) {
            logger.warn("Cannot update doc mapping because clusterState == null");
            this.configProvider.put(config, headers, listener);
            return;
        }
        ElasticsearchMappings.addDocMappingIfMissing((String)MlConfigIndex.indexName(), MlConfigIndex::mapping, (Client)this.client, (ClusterState)clusterState, (ActionListener)ActionListener.wrap(unused -> this.configProvider.put(config, headers, (ActionListener<DataFrameAnalyticsConfig>)ActionListener.wrap(indexResponse -> {
            this.auditor.info(config.getId(), Messages.getMessage((String)"Created analytics with analysis type [{0}]", (Object[])new Object[]{config.getAnalysis().getWriteableName()}));
            listener.onResponse((Object)config);
        }, arg_0 -> ((ActionListener)listener).onFailure(arg_0))), arg_0 -> listener.onFailure(arg_0)));
    }

    protected void doExecute(Task task, PutDataFrameAnalyticsAction.Request request, ActionListener<PutDataFrameAnalyticsAction.Response> listener) {
        if (this.licenseState.checkFeature(XPackLicenseState.Feature.MACHINE_LEARNING)) {
            super.doExecute(task, (MasterNodeRequest)request, listener);
        } else {
            listener.onFailure((Exception)LicenseUtils.newComplianceException((String)"ml"));
        }
    }
}

