/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.ml.datafeed.extractor;

import java.util.Collection;
import org.elasticsearch.ResourceNotFoundException;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.ActionType;
import org.elasticsearch.client.Client;
import org.elasticsearch.common.xcontent.NamedXContentRegistry;
import org.elasticsearch.index.IndexNotFoundException;
import org.elasticsearch.license.RemoteClusterLicenseChecker;
import org.elasticsearch.xpack.core.ClientHelper;
import org.elasticsearch.xpack.core.ml.datafeed.DatafeedConfig;
import org.elasticsearch.xpack.core.ml.datafeed.extractor.DataExtractor;
import org.elasticsearch.xpack.core.ml.job.config.Job;
import org.elasticsearch.xpack.core.ml.utils.ExceptionsHelper;
import org.elasticsearch.xpack.core.rollup.action.GetRollupIndexCapsAction;
import org.elasticsearch.xpack.ml.datafeed.DatafeedTimingStatsReporter;
import org.elasticsearch.xpack.ml.datafeed.extractor.aggregation.AggregationDataExtractorFactory;
import org.elasticsearch.xpack.ml.datafeed.extractor.aggregation.RollupDataExtractorFactory;
import org.elasticsearch.xpack.ml.datafeed.extractor.chunked.ChunkedDataExtractorFactory;
import org.elasticsearch.xpack.ml.datafeed.extractor.scroll.ScrollDataExtractorFactory;

public interface DataExtractorFactory {
    public DataExtractor newExtractor(long var1, long var3);

    public static void create(Client client, DatafeedConfig datafeed, Job job, NamedXContentRegistry xContentRegistry, DatafeedTimingStatsReporter timingStatsReporter, ActionListener<DataExtractorFactory> listener) {
        ActionListener factoryHandler = ActionListener.wrap(factory -> listener.onResponse((Object)(datafeed.getChunkingConfig().isEnabled() ? new ChunkedDataExtractorFactory(client, datafeed, job, xContentRegistry, (DataExtractorFactory)factory, timingStatsReporter) : factory)), arg_0 -> listener.onFailure(arg_0));
        ActionListener getRollupIndexCapsActionHandler = ActionListener.wrap(response -> {
            if (response.getJobs().isEmpty()) {
                if (datafeed.hasAggregations()) {
                    factoryHandler.onResponse((Object)new AggregationDataExtractorFactory(client, datafeed, job, xContentRegistry, timingStatsReporter));
                } else {
                    ScrollDataExtractorFactory.create(client, datafeed, job, xContentRegistry, timingStatsReporter, (ActionListener<DataExtractorFactory>)factoryHandler);
                }
            } else if (datafeed.hasAggregations()) {
                RollupDataExtractorFactory.create(client, datafeed, job, response.getJobs(), xContentRegistry, timingStatsReporter, (ActionListener<DataExtractorFactory>)factoryHandler);
            } else {
                listener.onFailure((Exception)new IllegalArgumentException("Aggregations are required when using Rollup indices"));
            }
        }, e -> {
            Throwable cause = ExceptionsHelper.unwrapCause((Throwable)e);
            if (cause instanceof IndexNotFoundException) {
                listener.onFailure((Exception)((Object)new ResourceNotFoundException("datafeed [" + datafeed.getId() + "] cannot retrieve data because index " + ((IndexNotFoundException)cause).getIndex() + " does not exist", new Object[0])));
            } else {
                listener.onFailure(e);
            }
        });
        if (RemoteClusterLicenseChecker.containsRemoteIndex((Collection)datafeed.getIndices())) {
            getRollupIndexCapsActionHandler.onResponse((Object)new GetRollupIndexCapsAction.Response());
        } else {
            ClientHelper.executeAsyncWithOrigin((Client)client, (String)"ml", (ActionType)GetRollupIndexCapsAction.INSTANCE, (ActionRequest)new GetRollupIndexCapsAction.Request(datafeed.getIndices().toArray(new String[0]), datafeed.getIndicesOptions()), (ActionListener)getRollupIndexCapsActionHandler);
        }
    }
}

