/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.ml.datafeed.extractor.aggregation;

import java.time.ZoneId;
import java.time.ZoneOffset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.elasticsearch.ElasticsearchStatusException;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.client.Client;
import org.elasticsearch.common.xcontent.NamedXContentRegistry;
import org.elasticsearch.search.aggregations.AggregationBuilder;
import org.elasticsearch.search.aggregations.bucket.histogram.DateHistogramAggregationBuilder;
import org.elasticsearch.search.aggregations.bucket.terms.TermsAggregationBuilder;
import org.elasticsearch.search.aggregations.support.ValuesSourceAggregationBuilder;
import org.elasticsearch.xpack.core.ml.datafeed.DatafeedConfig;
import org.elasticsearch.xpack.core.ml.datafeed.extractor.DataExtractor;
import org.elasticsearch.xpack.core.ml.datafeed.extractor.ExtractorUtils;
import org.elasticsearch.xpack.core.ml.job.config.Job;
import org.elasticsearch.xpack.core.ml.utils.Intervals;
import org.elasticsearch.xpack.core.rollup.action.RollableIndexCaps;
import org.elasticsearch.xpack.core.rollup.action.RollupJobCaps;
import org.elasticsearch.xpack.ml.datafeed.DatafeedTimingStatsReporter;
import org.elasticsearch.xpack.ml.datafeed.extractor.DataExtractorFactory;
import org.elasticsearch.xpack.ml.datafeed.extractor.aggregation.AggregationDataExtractorContext;
import org.elasticsearch.xpack.ml.datafeed.extractor.aggregation.RollupDataExtractor;

public class RollupDataExtractorFactory
implements DataExtractorFactory {
    private final Client client;
    private final DatafeedConfig datafeedConfig;
    private final Job job;
    private final NamedXContentRegistry xContentRegistry;
    private final DatafeedTimingStatsReporter timingStatsReporter;

    private RollupDataExtractorFactory(Client client, DatafeedConfig datafeedConfig, Job job, NamedXContentRegistry xContentRegistry, DatafeedTimingStatsReporter timingStatsReporter) {
        this.client = Objects.requireNonNull(client);
        this.datafeedConfig = Objects.requireNonNull(datafeedConfig);
        this.job = Objects.requireNonNull(job);
        this.xContentRegistry = xContentRegistry;
        this.timingStatsReporter = Objects.requireNonNull(timingStatsReporter);
    }

    @Override
    public DataExtractor newExtractor(long start, long end) {
        long histogramInterval = this.datafeedConfig.getHistogramIntervalMillis(this.xContentRegistry);
        AggregationDataExtractorContext dataExtractorContext = new AggregationDataExtractorContext(this.job.getId(), this.job.getDataDescription().getTimeField(), this.job.getAnalysisConfig().analysisFields(), this.datafeedConfig.getIndices(), this.datafeedConfig.getParsedQuery(this.xContentRegistry), this.datafeedConfig.getParsedAggregations(this.xContentRegistry), Intervals.alignToCeil((long)start, (long)histogramInterval), Intervals.alignToFloor((long)end, (long)histogramInterval), this.job.getAnalysisConfig().getSummaryCountFieldName().equals("doc_count"), this.datafeedConfig.getHeaders(), this.datafeedConfig.getIndicesOptions());
        return new RollupDataExtractor(this.client, dataExtractorContext, this.timingStatsReporter);
    }

    public static void create(Client client, DatafeedConfig datafeed, Job job, Map<String, RollableIndexCaps> rollupJobsWithCaps, NamedXContentRegistry xContentRegistry, DatafeedTimingStatsReporter timingStatsReporter, ActionListener<DataExtractorFactory> listener) {
        AggregationBuilder datafeedHistogramAggregation = ExtractorUtils.getHistogramAggregation((Collection)datafeed.getParsedAggregations(xContentRegistry).getAggregatorFactories());
        if (!(datafeedHistogramAggregation instanceof DateHistogramAggregationBuilder)) {
            listener.onFailure((Exception)new IllegalArgumentException("Rollup requires that the datafeed configuration use a [date_histogram] aggregation, not a [histogram] aggregation over the time field."));
            return;
        }
        String timeField = ((ValuesSourceAggregationBuilder)datafeedHistogramAggregation).field();
        Set rollupCapsSet = rollupJobsWithCaps.values().stream().flatMap(rollableIndexCaps -> rollableIndexCaps.getJobCaps().stream()).map(rollupJobCaps -> ParsedRollupCaps.fromJobFieldCaps(rollupJobCaps.getFieldCaps(), timeField)).collect(Collectors.toSet());
        long datafeedInterval = ExtractorUtils.getHistogramIntervalMillis((AggregationBuilder)datafeedHistogramAggregation);
        List validIntervalCaps = rollupCapsSet.stream().filter(rollupCaps -> RollupDataExtractorFactory.validInterval(datafeedInterval, rollupCaps)).collect(Collectors.toList());
        if (validIntervalCaps.isEmpty()) {
            listener.onFailure((Exception)new IllegalArgumentException("Rollup capabilities do not have a [date_histogram] aggregation with an interval that is a multiple of the datafeed's interval."));
            return;
        }
        ArrayList flattenedAggs = new ArrayList();
        RollupDataExtractorFactory.flattenAggregations(datafeed.getParsedAggregations(xContentRegistry).getAggregatorFactories(), datafeedHistogramAggregation, flattenedAggs);
        if (validIntervalCaps.stream().noneMatch(rollupJobConfig -> RollupDataExtractorFactory.hasAggregations(rollupJobConfig, flattenedAggs))) {
            listener.onFailure((Exception)new IllegalArgumentException("Rollup capabilities do not support all the datafeed aggregations at the desired interval."));
            return;
        }
        listener.onResponse((Object)new RollupDataExtractorFactory(client, datafeed, job, xContentRegistry, timingStatsReporter));
    }

    private static boolean validInterval(long datafeedInterval, ParsedRollupCaps rollupJobGroupConfig) {
        if (!rollupJobGroupConfig.hasDatehistogram()) {
            return false;
        }
        if (!ZoneId.of(rollupJobGroupConfig.getTimezone()).getRules().equals(ZoneOffset.UTC.getRules())) {
            return false;
        }
        try {
            long jobInterval = ExtractorUtils.validateAndGetCalendarInterval((String)rollupJobGroupConfig.getInterval());
            return datafeedInterval % jobInterval == 0L;
        }
        catch (ElasticsearchStatusException exception) {
            return false;
        }
    }

    private static void flattenAggregations(Collection<AggregationBuilder> datafeedAggregations, AggregationBuilder datafeedHistogramAggregation, List<ValuesSourceAggregationBuilder<?>> flattenedAggregations) {
        for (AggregationBuilder aggregationBuilder : datafeedAggregations) {
            if (!aggregationBuilder.equals(datafeedHistogramAggregation)) {
                flattenedAggregations.add((ValuesSourceAggregationBuilder)aggregationBuilder);
            }
            RollupDataExtractorFactory.flattenAggregations(aggregationBuilder.getSubAggregations(), datafeedHistogramAggregation, flattenedAggregations);
        }
    }

    private static boolean hasAggregations(ParsedRollupCaps rollupCaps, List<ValuesSourceAggregationBuilder<?>> datafeedAggregations) {
        for (ValuesSourceAggregationBuilder<?> aggregationBuilder : datafeedAggregations) {
            String type = aggregationBuilder.getType();
            String field = aggregationBuilder.field();
            if (!(aggregationBuilder instanceof TermsAggregationBuilder ? !rollupCaps.supportedTerms.contains(field) : !rollupCaps.supportedMetrics.contains(field + "_" + type))) continue;
            return false;
        }
        return true;
    }

    private static class ParsedRollupCaps {
        private final Set<String> supportedMetrics;
        private final Set<String> supportedTerms;
        private final Map<String, Object> datehistogramAgg;
        private static final List<String> aggsToIgnore = Arrays.asList("histogram", "date_histogram");

        private static ParsedRollupCaps fromJobFieldCaps(Map<String, RollupJobCaps.RollupFieldCaps> rollupFieldCaps, String timeField) {
            Map datehistogram = null;
            RollupJobCaps.RollupFieldCaps timeFieldCaps = rollupFieldCaps.get(timeField);
            if (timeFieldCaps != null) {
                for (Map agg : timeFieldCaps.getAggs()) {
                    if (!agg.get("agg").equals("date_histogram")) continue;
                    datehistogram = agg;
                }
            }
            HashSet<String> supportedMetrics = new HashSet<String>();
            HashSet<String> supportedTerms = new HashSet<String>();
            rollupFieldCaps.forEach((field, fieldCaps) -> fieldCaps.getAggs().forEach(agg -> {
                String type = (String)agg.get("agg");
                if (type.equals("terms")) {
                    supportedTerms.add((String)field);
                } else if (!aggsToIgnore.contains(type)) {
                    supportedMetrics.add(field + "_" + type);
                }
            }));
            return new ParsedRollupCaps(supportedMetrics, supportedTerms, datehistogram);
        }

        private ParsedRollupCaps(Set<String> supportedMetrics, Set<String> supportedTerms, Map<String, Object> datehistogramAgg) {
            this.supportedMetrics = supportedMetrics;
            this.supportedTerms = supportedTerms;
            this.datehistogramAgg = datehistogramAgg;
        }

        private String getInterval() {
            if (this.datehistogramAgg == null) {
                return null;
            }
            if (this.datehistogramAgg.get("interval") != null) {
                return (String)this.datehistogramAgg.get("interval");
            }
            if (this.datehistogramAgg.get("calendar_interval") != null) {
                return (String)this.datehistogramAgg.get("calendar_interval");
            }
            if (this.datehistogramAgg.get("fixed_interval") != null) {
                return (String)this.datehistogramAgg.get("fixed_interval");
            }
            return null;
        }

        private String getTimezone() {
            if (this.datehistogramAgg == null) {
                return null;
            }
            return (String)this.datehistogramAgg.get("time_zone");
        }

        private boolean hasDatehistogram() {
            return this.datehistogramAgg != null;
        }
    }
}

