/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.ml.dataframe;

import java.io.IOException;
import java.util.List;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.elasticsearch.common.Nullable;
import org.elasticsearch.common.ParseField;
import org.elasticsearch.common.xcontent.ConstructingObjectParser;
import org.elasticsearch.common.xcontent.ContextParser;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.ToXContentObject;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.xpack.core.ml.utils.PhaseProgress;

public class StoredProgress
implements ToXContentObject {
    private static final ParseField PROGRESS = new ParseField("progress", new String[0]);
    public static final ConstructingObjectParser<StoredProgress, Void> PARSER = new ConstructingObjectParser(PROGRESS.getPreferredName(), true, a -> new StoredProgress((List)a[0]));
    private final List<PhaseProgress> progress;

    public StoredProgress(List<PhaseProgress> progress) {
        this.progress = Objects.requireNonNull(progress);
    }

    public List<PhaseProgress> get() {
        return this.progress;
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        builder.field(PROGRESS.getPreferredName(), this.progress);
        builder.endObject();
        return builder;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || !o.getClass().equals(this.getClass())) {
            return false;
        }
        StoredProgress that = (StoredProgress)o;
        return Objects.equals(this.progress, that.progress);
    }

    public int hashCode() {
        return Objects.hash(this.progress);
    }

    public static String documentId(String id) {
        return "data_frame_analytics-" + id + "-progress";
    }

    @Nullable
    public static String extractJobIdFromDocId(String docId) {
        Pattern pattern = Pattern.compile("^data_frame_analytics-(.*)-progress$");
        Matcher matcher = pattern.matcher(docId);
        return matcher.find() ? matcher.group(1) : null;
    }

    static {
        PARSER.declareObjectArray(ConstructingObjectParser.constructorArg(), (ContextParser)PhaseProgress.PARSER, PROGRESS);
    }
}

