/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.ml.dataframe.process.results;

import java.io.IOException;
import java.util.List;
import java.util.Objects;
import org.elasticsearch.common.ParseField;
import org.elasticsearch.common.xcontent.ConstructingObjectParser;
import org.elasticsearch.common.xcontent.ContextParser;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.ToXContentObject;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.xpack.core.ml.inference.trainedmodel.metadata.FeatureImportanceBaseline;
import org.elasticsearch.xpack.core.ml.inference.trainedmodel.metadata.TotalFeatureImportance;

public class ModelMetadata
implements ToXContentObject {
    public static final ParseField TOTAL_FEATURE_IMPORTANCE = new ParseField("total_feature_importance", new String[0]);
    public static final ParseField FEATURE_IMPORTANCE_BASELINE = new ParseField("feature_importance_baseline", new String[0]);
    public static final ConstructingObjectParser<ModelMetadata, Void> PARSER = new ConstructingObjectParser("trained_model_metadata", a -> new ModelMetadata((List)a[0], (FeatureImportanceBaseline)a[1]));
    private final List<TotalFeatureImportance> featureImportances;
    private final FeatureImportanceBaseline featureImportanceBaseline;

    public ModelMetadata(List<TotalFeatureImportance> featureImportances, FeatureImportanceBaseline featureImportanceBaseline) {
        this.featureImportances = featureImportances;
        this.featureImportanceBaseline = featureImportanceBaseline;
    }

    public List<TotalFeatureImportance> getFeatureImportances() {
        return this.featureImportances;
    }

    public FeatureImportanceBaseline getFeatureImportanceBaseline() {
        return this.featureImportanceBaseline;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ModelMetadata that = (ModelMetadata)o;
        return Objects.equals(this.featureImportances, that.featureImportances) && Objects.equals(this.featureImportanceBaseline, that.featureImportanceBaseline);
    }

    public int hashCode() {
        return Objects.hash(this.featureImportances, this.featureImportanceBaseline);
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        builder.field(TOTAL_FEATURE_IMPORTANCE.getPreferredName(), this.featureImportances);
        if (this.featureImportanceBaseline != null) {
            builder.field(FEATURE_IMPORTANCE_BASELINE.getPreferredName(), (ToXContent)this.featureImportanceBaseline);
        }
        builder.endObject();
        return builder;
    }

    static {
        PARSER.declareObjectArray(ConstructingObjectParser.constructorArg(), (ContextParser)TotalFeatureImportance.STRICT_PARSER, TOTAL_FEATURE_IMPORTANCE);
        PARSER.declareObject(ConstructingObjectParser.optionalConstructorArg(), (ContextParser)FeatureImportanceBaseline.STRICT_PARSER, FEATURE_IMPORTANCE_BASELINE);
    }
}

