/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.ml.dataframe.stats;

import java.util.List;
import java.util.concurrent.atomic.AtomicReference;
import org.elasticsearch.xpack.core.ml.dataframe.stats.AnalysisStats;
import org.elasticsearch.xpack.core.ml.dataframe.stats.common.MemoryUsage;
import org.elasticsearch.xpack.core.ml.utils.PhaseProgress;
import org.elasticsearch.xpack.ml.dataframe.stats.DataCountsTracker;
import org.elasticsearch.xpack.ml.dataframe.stats.ProgressTracker;

public class StatsHolder {
    private volatile ProgressTracker progressTracker;
    private final AtomicReference<MemoryUsage> memoryUsageHolder;
    private final AtomicReference<AnalysisStats> analysisStatsHolder;
    private final DataCountsTracker dataCountsTracker;

    public StatsHolder(List<PhaseProgress> progressOnStart) {
        this.progressTracker = new ProgressTracker(progressOnStart);
        this.memoryUsageHolder = new AtomicReference();
        this.analysisStatsHolder = new AtomicReference();
        this.dataCountsTracker = new DataCountsTracker();
    }

    public void adjustProgressTracker(List<String> analysisPhases, boolean hasInferencePhase) {
        int reindexingProgressPercent = this.progressTracker.getReindexingProgressPercent();
        this.progressTracker = ProgressTracker.fromZeroes(analysisPhases, hasInferencePhase);
        this.progressTracker.updateReindexingProgress(reindexingProgressPercent < 100 ? 1 : reindexingProgressPercent);
    }

    public void resetProgressTracker(List<String> analysisPhases, boolean hasInferencePhase) {
        this.progressTracker = ProgressTracker.fromZeroes(analysisPhases, hasInferencePhase);
        this.progressTracker.updateReindexingProgress(1);
    }

    public ProgressTracker getProgressTracker() {
        return this.progressTracker;
    }

    public void setMemoryUsage(MemoryUsage memoryUsage) {
        this.memoryUsageHolder.set(memoryUsage);
    }

    public MemoryUsage getMemoryUsage() {
        return this.memoryUsageHolder.get();
    }

    public void setAnalysisStats(AnalysisStats analysisStats) {
        this.analysisStatsHolder.set(analysisStats);
    }

    public AnalysisStats getAnalysisStats() {
        return this.analysisStatsHolder.get();
    }

    public DataCountsTracker getDataCountsTracker() {
        return this.dataCountsTracker;
    }
}

