/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.ml.filestructurefinder;

import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.List;
import java.util.Locale;
import org.elasticsearch.common.xcontent.DeprecationHandler;
import org.elasticsearch.common.xcontent.NamedXContentRegistry;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.common.xcontent.json.JsonXContent;
import org.elasticsearch.xpack.core.ml.filestructurefinder.FileStructure;
import org.elasticsearch.xpack.ml.filestructurefinder.FileStructureFinder;
import org.elasticsearch.xpack.ml.filestructurefinder.FileStructureFinderFactory;
import org.elasticsearch.xpack.ml.filestructurefinder.FileStructureOverrides;
import org.elasticsearch.xpack.ml.filestructurefinder.NdJsonFileStructureFinder;
import org.elasticsearch.xpack.ml.filestructurefinder.TimeoutChecker;

public class NdJsonFileStructureFinderFactory
implements FileStructureFinderFactory {
    @Override
    public boolean canFindFormat(FileStructure.Format format) {
        return format == null || format == FileStructure.Format.NDJSON;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean canCreateFromSample(List<String> explanation, String sample, double allowedFractionOfBadLines) {
        int completeDocCount = 0;
        try {
            String[] sampleLines;
            String[] stringArray = sampleLines = sample.split("\n");
            int n = stringArray.length;
            for (int i = 0; i < n; ++completeDocCount, ++i) {
                String sampleLine = stringArray[i];
                try (XContentParser parser = JsonXContent.jsonXContent.createParser(NamedXContentRegistry.EMPTY, DeprecationHandler.THROW_UNSUPPORTED_OPERATION, (Reader)new ContextPrintingStringReader(sampleLine));){
                    if (parser.map().isEmpty()) {
                        explanation.add("Not NDJSON because an empty object was parsed: [" + sampleLine + "]");
                        boolean bl = false;
                        return bl;
                    }
                    if (parser.nextToken() == null) continue;
                    explanation.add("Not newline delimited NDJSON because a line contained more than a single object: [" + sampleLine + "]");
                    boolean bl = false;
                    return bl;
                }
            }
        }
        catch (IOException | IllegalStateException e) {
            explanation.add("Not NDJSON because there was a parsing exception: [" + e.getMessage().replaceAll("\\s?\r?\n\\s?", " ") + "]");
            return false;
        }
        if (completeDocCount == 0) {
            explanation.add("Not NDJSON because sample didn't contain a complete document");
            return false;
        }
        explanation.add("Deciding sample is newline delimited NDJSON");
        return true;
    }

    @Override
    public FileStructureFinder createFromSample(List<String> explanation, String sample, String charsetName, Boolean hasByteOrderMarker, int lineMergeSizeLimit, FileStructureOverrides overrides, TimeoutChecker timeoutChecker) throws IOException {
        return NdJsonFileStructureFinder.makeNdJsonFileStructureFinder(explanation, sample, charsetName, hasByteOrderMarker, overrides, timeoutChecker);
    }

    private static class ContextPrintingStringReader
    extends StringReader {
        private final String str;

        ContextPrintingStringReader(String str) {
            super(str);
            this.str = str;
        }

        public String toString() {
            if (this.str.length() <= 80) {
                return String.format(Locale.ROOT, "\"%s\"", this.str);
            }
            return String.format(Locale.ROOT, "\"%.77s...\"", this.str);
        }
    }
}

