/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.ml.job;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.message.ParameterizedMessage;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.node.DiscoveryNode;
import org.elasticsearch.common.Nullable;
import org.elasticsearch.common.Strings;
import org.elasticsearch.persistent.PersistentTasksCustomMetadata;
import org.elasticsearch.xpack.core.ml.MlTasks;
import org.elasticsearch.xpack.core.ml.action.OpenJobAction;
import org.elasticsearch.xpack.core.ml.action.StartDataFrameAnalyticsAction;
import org.elasticsearch.xpack.core.ml.dataframe.DataFrameAnalyticsState;
import org.elasticsearch.xpack.core.ml.job.config.JobState;
import org.elasticsearch.xpack.ml.MachineLearning;
import org.elasticsearch.xpack.ml.process.MlMemoryTracker;

public class NodeLoadDetector {
    private static final Logger logger = LogManager.getLogger(NodeLoadDetector.class);
    private final MlMemoryTracker mlMemoryTracker;

    public NodeLoadDetector(MlMemoryTracker memoryTracker) {
        this.mlMemoryTracker = memoryTracker;
    }

    public MlMemoryTracker getMlMemoryTracker() {
        return this.mlMemoryTracker;
    }

    public NodeLoad detectNodeLoad(ClusterState clusterState, boolean allNodesHaveDynamicMaxWorkers, DiscoveryNode node, int dynamicMaxOpenJobs, int maxMachineMemoryPercent, boolean isMemoryTrackerRecentlyRefreshed) {
        PersistentTasksCustomMetadata persistentTasks = (PersistentTasksCustomMetadata)clusterState.getMetadata().custom("persistent_tasks");
        Map nodeAttributes = node.getAttributes();
        ArrayList<String> errors = new ArrayList<String>();
        int maxNumberOfOpenJobs = dynamicMaxOpenJobs;
        if (!allNodesHaveDynamicMaxWorkers) {
            String maxNumberOfOpenJobsStr = (String)nodeAttributes.get("ml.max_open_jobs");
            try {
                maxNumberOfOpenJobs = Integer.parseInt(maxNumberOfOpenJobsStr);
            }
            catch (NumberFormatException e) {
                errors.add("ml.max_open_jobs attribute [" + maxNumberOfOpenJobsStr + "] is not an integer");
                maxNumberOfOpenJobs = -1;
            }
        }
        String machineMemoryStr = (String)nodeAttributes.get("ml.machine_memory");
        long machineMemory = -1L;
        try {
            machineMemory = Long.parseLong(machineMemoryStr);
        }
        catch (NumberFormatException e) {
            errors.add("ml.machine_memory attribute [" + machineMemoryStr + "] is not a long");
        }
        long maxMlMemory = machineMemory * (long)maxMachineMemoryPercent / 100L;
        NodeLoad nodeLoad = new NodeLoad(node.getId(), maxMlMemory, maxNumberOfOpenJobs, isMemoryTrackerRecentlyRefreshed);
        if (!errors.isEmpty()) {
            nodeLoad.error = Strings.collectionToCommaDelimitedString(errors);
            return nodeLoad;
        }
        this.updateLoadGivenTasks(nodeLoad, persistentTasks);
        return nodeLoad;
    }

    private void updateLoadGivenTasks(NodeLoad nodeLoad, PersistentTasksCustomMetadata persistentTasks) {
        if (persistentTasks != null) {
            Collection assignedAnomalyDetectorTasks = persistentTasks.findTasks("xpack/ml/job", task -> nodeLoad.getNodeId().equals(task.getExecutorNode()));
            for (PersistentTasksCustomMetadata.PersistentTask assignedTask : assignedAnomalyDetectorTasks) {
                OpenJobAction.JobParams params;
                Long jobMemoryRequirement;
                JobState jobState = MlTasks.getJobStateModifiedForReassignments((PersistentTasksCustomMetadata.PersistentTask)assignedTask);
                if (jobState.isAnyOf(new JobState[]{JobState.CLOSED, JobState.FAILED})) continue;
                ++nodeLoad.numAssignedJobs;
                if (jobState == JobState.OPENING) {
                    ++nodeLoad.numAllocatingJobs;
                }
                if ((jobMemoryRequirement = this.mlMemoryTracker.getAnomalyDetectorJobMemoryRequirement((params = (OpenJobAction.JobParams)assignedTask.getParams()).getJobId())) == null) {
                    nodeLoad.useMemory = false;
                    logger.debug(() -> new ParameterizedMessage("[{}] memory requirement was not available. Calculating load by number of assigned jobs.", (Object)params.getJobId()));
                    continue;
                }
                nodeLoad.assignedJobMemory += jobMemoryRequirement;
            }
            Collection assignedAnalyticsTasks = persistentTasks.findTasks("xpack/ml/data_frame/analytics", task -> nodeLoad.getNodeId().equals(task.getExecutorNode()));
            for (PersistentTasksCustomMetadata.PersistentTask assignedTask : assignedAnalyticsTasks) {
                DataFrameAnalyticsState dataFrameAnalyticsState = MlTasks.getDataFrameAnalyticsState((PersistentTasksCustomMetadata.PersistentTask)assignedTask);
                if (dataFrameAnalyticsState.isAnyOf(new DataFrameAnalyticsState[]{DataFrameAnalyticsState.STOPPED, DataFrameAnalyticsState.FAILED})) continue;
                ++nodeLoad.numAssignedJobs;
                StartDataFrameAnalyticsAction.TaskParams params = (StartDataFrameAnalyticsAction.TaskParams)assignedTask.getParams();
                Long jobMemoryRequirement = this.mlMemoryTracker.getDataFrameAnalyticsJobMemoryRequirement(params.getId());
                if (jobMemoryRequirement == null) {
                    nodeLoad.useMemory = false;
                    logger.debug(() -> new ParameterizedMessage("[{}] memory requirement was not available. Calculating load by number of assigned jobs.", (Object)params.getId()));
                    continue;
                }
                nodeLoad.assignedJobMemory += jobMemoryRequirement;
            }
            if (nodeLoad.numAssignedJobs > 0L) {
                nodeLoad.assignedJobMemory += MachineLearning.NATIVE_EXECUTABLE_CODE_OVERHEAD.getBytes();
            }
        }
    }

    public static class NodeLoad {
        private final long maxMemory;
        private final int maxJobs;
        private final String nodeId;
        private boolean useMemory;
        private String error;
        private long numAssignedJobs;
        private long assignedJobMemory;
        private long numAllocatingJobs;

        private NodeLoad(String nodeId, long maxMemory, int maxJobs, boolean useMemory) {
            this.maxJobs = maxJobs;
            this.maxMemory = maxMemory;
            this.nodeId = nodeId;
            this.useMemory = useMemory;
        }

        public long getNumAssignedJobs() {
            return this.numAssignedJobs;
        }

        public long getAssignedJobMemory() {
            return this.assignedJobMemory;
        }

        public long getMaxMlMemory() {
            return this.maxMemory;
        }

        public int getMaxJobs() {
            return this.maxJobs;
        }

        public boolean isUseMemory() {
            return this.useMemory;
        }

        public String getNodeId() {
            return this.nodeId;
        }

        @Nullable
        public String getError() {
            return this.error;
        }

        public long getNumAllocatingJobs() {
            return this.numAllocatingJobs;
        }
    }
}

