/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.ml.job.process.autodetect;

import java.io.Closeable;
import java.io.IOException;
import java.nio.file.Path;
import java.time.Duration;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.ExecutorService;
import java.util.function.Consumer;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.unit.TimeValue;
import org.elasticsearch.common.util.concurrent.EsRejectedExecutionException;
import org.elasticsearch.common.xcontent.NamedXContentRegistry;
import org.elasticsearch.core.internal.io.IOUtils;
import org.elasticsearch.env.Environment;
import org.elasticsearch.xpack.core.ml.job.config.Job;
import org.elasticsearch.xpack.core.ml.utils.ExceptionsHelper;
import org.elasticsearch.xpack.ml.MachineLearning;
import org.elasticsearch.xpack.ml.job.process.autodetect.AutodetectBuilder;
import org.elasticsearch.xpack.ml.job.process.autodetect.AutodetectProcess;
import org.elasticsearch.xpack.ml.job.process.autodetect.AutodetectProcessFactory;
import org.elasticsearch.xpack.ml.job.process.autodetect.NativeAutodetectProcess;
import org.elasticsearch.xpack.ml.job.process.autodetect.params.AutodetectParams;
import org.elasticsearch.xpack.ml.job.results.AutodetectResult;
import org.elasticsearch.xpack.ml.notifications.AnomalyDetectionAuditor;
import org.elasticsearch.xpack.ml.process.IndexingStateProcessor;
import org.elasticsearch.xpack.ml.process.NativeController;
import org.elasticsearch.xpack.ml.process.ProcessPipes;
import org.elasticsearch.xpack.ml.process.ProcessResultsParser;
import org.elasticsearch.xpack.ml.utils.NamedPipeHelper;
import org.elasticsearch.xpack.ml.utils.persistence.ResultsPersisterService;

public class NativeAutodetectProcessFactory
implements AutodetectProcessFactory {
    private static final Logger LOGGER = LogManager.getLogger(NativeAutodetectProcessFactory.class);
    private static final NamedPipeHelper NAMED_PIPE_HELPER = new NamedPipeHelper();
    private final Environment env;
    private final Settings settings;
    private final NativeController nativeController;
    private final ClusterService clusterService;
    private final ResultsPersisterService resultsPersisterService;
    private final AnomalyDetectionAuditor auditor;
    private volatile Duration processConnectTimeout;

    public NativeAutodetectProcessFactory(Environment env, Settings settings, NativeController nativeController, ClusterService clusterService, ResultsPersisterService resultsPersisterService, AnomalyDetectionAuditor auditor) {
        this.env = Objects.requireNonNull(env);
        this.settings = Objects.requireNonNull(settings);
        this.nativeController = Objects.requireNonNull(nativeController);
        this.clusterService = clusterService;
        this.resultsPersisterService = resultsPersisterService;
        this.auditor = auditor;
        this.setProcessConnectTimeout((TimeValue)MachineLearning.PROCESS_CONNECT_TIMEOUT.get(settings));
        clusterService.getClusterSettings().addSettingsUpdateConsumer(MachineLearning.PROCESS_CONNECT_TIMEOUT, this::setProcessConnectTimeout);
    }

    void setProcessConnectTimeout(TimeValue processConnectTimeout) {
        this.processConnectTimeout = Duration.ofMillis(processConnectTimeout.getMillis());
    }

    @Override
    public AutodetectProcess createAutodetectProcess(Job job, AutodetectParams params, ExecutorService executorService, Consumer<String> onProcessCrash) {
        ArrayList<Path> filesToDelete = new ArrayList<Path>();
        ProcessPipes processPipes = new ProcessPipes(this.env, NAMED_PIPE_HELPER, this.processConnectTimeout, "autodetect", job.getId(), false, true, true, params.modelSnapshot() != null, (Boolean)AutodetectBuilder.DONT_PERSIST_MODEL_STATE_SETTING.get(this.settings) == false);
        this.createNativeProcess(job, params, processPipes, filesToDelete);
        boolean includeTokensField = job.getAnalysisConfig().getCategorizationFieldName() != null;
        int numberOfFields = job.allInputFields().size() + (includeTokensField ? 1 : 0) + 1;
        IndexingStateProcessor stateProcessor = new IndexingStateProcessor(job.getId(), this.resultsPersisterService, this.auditor);
        ProcessResultsParser<AutodetectResult> resultsParser = new ProcessResultsParser<AutodetectResult>(AutodetectResult.PARSER, NamedXContentRegistry.EMPTY);
        NativeAutodetectProcess autodetect = new NativeAutodetectProcess(job.getId(), processPipes, numberOfFields, filesToDelete, resultsParser, onProcessCrash);
        try {
            autodetect.start(executorService, stateProcessor);
            return autodetect;
        }
        catch (IOException | EsRejectedExecutionException e) {
            String msg = "Failed to connect to autodetect for job " + job.getId();
            LOGGER.error(msg);
            try {
                IOUtils.close((Closeable)autodetect);
            }
            catch (IOException ioe) {
                LOGGER.error("Can't close autodetect", (Throwable)ioe);
            }
            throw ExceptionsHelper.serverError((String)msg, (Throwable)e);
        }
    }

    void createNativeProcess(Job job, AutodetectParams autodetectParams, ProcessPipes processPipes, List<Path> filesToDelete) {
        try {
            Settings updatedSettings = Settings.builder().put(this.settings).put(AutodetectBuilder.MAX_ANOMALY_RECORDS_SETTING_DYNAMIC.getKey(), ((Integer)this.clusterService.getClusterSettings().get(AutodetectBuilder.MAX_ANOMALY_RECORDS_SETTING_DYNAMIC)).intValue()).build();
            AutodetectBuilder autodetectBuilder = new AutodetectBuilder(job, filesToDelete, LOGGER, this.env, updatedSettings, this.nativeController, processPipes).referencedFilters(autodetectParams.filters()).scheduledEvents(autodetectParams.scheduledEvents());
            if (autodetectParams.quantiles() != null) {
                autodetectBuilder.quantiles(autodetectParams.quantiles());
            }
            autodetectBuilder.build();
        }
        catch (IOException e) {
            String msg = "Failed to launch autodetect for job " + job.getId();
            LOGGER.error(msg);
            throw ExceptionsHelper.serverError((String)msg, (Throwable)e);
        }
    }
}

